/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.ExactPhraseSearchExpression;
import com.mathworks.search.PartialWordSearchExpression;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchVisitor;
import com.mathworks.search.SimpleSearchExpression;
import com.mathworks.search.UnarySearchExpression;
import com.mathworks.search.WildcardSearchExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SearchKeywordsVisitor
implements SearchVisitor {
    private Collection<String> fSearchKeywords;

    @Override
    public void visit(SimpleSearchExpression simpleExpr) {
        this.visitUnaryExpression(simpleExpr);
    }

    @Override
    public void visit(PartialWordSearchExpression partialExpr) {
        this.fSearchKeywords = new ArrayList<String>();
        if (!partialExpr.getBooleanOperator().equals((Object)BooleanSearchOperator.MUST_NOT_OCCUR)) {
            this.fSearchKeywords.add(partialExpr.getSearchString() + "*");
        }
    }

    @Override
    public void visit(WildcardSearchExpression wildcardExpr) {
        this.visitUnaryExpression(wildcardExpr);
    }

    @Override
    public void visit(ExactPhraseSearchExpression exactExpr) {
        this.visitUnaryExpression(exactExpr);
    }

    @Override
    public void visit(CompoundSearchExpression compoundExpr) throws SearchException {
        ArrayList<String> keywords = new ArrayList<String>();
        for (SearchExpression searchExpression : compoundExpr.getExpressions()) {
            searchExpression.accept(this);
            keywords.addAll(this.getSearchKeywords());
        }
        this.fSearchKeywords = keywords;
    }

    private void visitUnaryExpression(UnarySearchExpression unaryExpr) {
        this.fSearchKeywords = new ArrayList<String>();
        if (!unaryExpr.getBooleanOperator().equals((Object)BooleanSearchOperator.MUST_NOT_OCCUR)) {
            this.fSearchKeywords.add(unaryExpr.getSearchString());
        }
    }

    public Collection<String> getSearchKeywords() {
        return Collections.unmodifiableCollection(this.fSearchKeywords);
    }

    public static Collection<String> getSearchKeywords(SearchExpression expr) {
        SearchKeywordsVisitor skv = new SearchKeywordsVisitor();
        try {
            expr.accept(skv);
            return skv.getSearchKeywords();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

