/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.provider;

import com.mathworks.storage.provider.Cache;
import com.mathworks.storage.provider.PackageLogger;
import com.mathworks.storage.provider.StorageURI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ConcurrentHashMapCacheImpl<V>
implements Cache<V> {
    private final ConcurrentMap<StorageURI, V> fCachedValues = new ConcurrentHashMap<StorageURI, V>();

    @Override
    public V get(StorageURI storageURI) {
        Object v = this.fCachedValues.get(storageURI);
        if (v != null) {
            PackageLogger.LOGGER.fine("Using cached " + v.getClass().getName() + " for " + storageURI);
        }
        return v;
    }

    @Override
    public void put(StorageURI storageURI, V v) {
        PackageLogger.LOGGER.fine("Caching " + v.getClass().getName() + " for " + storageURI);
        this.fCachedValues.put(storageURI, v);
    }

    @Override
    public void removeIf(StorageURI storageURI, Cache.Predicate<V> predicate) {
        boolean bl;
        boolean bl2 = false;
        do {
            V v;
            boolean bl3 = bl = (v = this.get(storageURI)) != null && predicate.test(v);
            if (!bl || !(bl2 = this.fCachedValues.remove(storageURI, v))) continue;
            PackageLogger.LOGGER.fine("Removed " + storageURI + " from cache because predicate was true");
        } while (bl && !bl2);
    }

    @Override
    public void remove(StorageURI storageURI) {
        PackageLogger.LOGGER.fine("Clearing cached value for " + storageURI);
        this.fCachedValues.remove(storageURI);
    }

    @Override
    public void clear() {
        PackageLogger.LOGGER.fine("Clearing all values from cache.");
        this.fCachedValues.clear();
    }
}

