/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt.rpc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Request {
    private final int m_ID;
    private final String[] m_args;

    public Request(int ID, String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("null input: args");
        }
        this.m_ID = ID;
        this.m_args = args;
    }

    public final int getID() {
        return this.m_ID;
    }

    public final String[] getArgs() {
        return (String[])this.m_args.clone();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.m_ID);
        s.append(" (");
        int aLimit = this.m_args.length;
        for (int a = 0; a < aLimit; ++a) {
            String arg;
            if (a != 0) {
                s.append(',');
            }
            if ((arg = this.m_args[a]) == null) continue;
            s.append(arg);
        }
        s.append(')');
        return s.toString();
    }

    public static Request read(DataInput in) throws IOException {
        byte ID = in.readByte();
        int argLength = in.readInt();
        String[] args = new String[argLength];
        for (int a = 0; a < argLength; ++a) {
            byte argFlag = in.readByte();
            if (argFlag == 0) continue;
            args[a] = in.readUTF();
        }
        return new Request(ID, args);
    }

    public static void write(Request request, DataOutput out) throws IOException {
        out.writeByte(request.m_ID);
        String[] args = request.m_args;
        int argLength = args.length;
        out.writeInt(argLength);
        for (int a = 0; a < argLength; ++a) {
            String arg = args[a];
            if (arg != null) {
                out.writeByte(1);
                out.writeUTF(arg);
                continue;
            }
            out.writeByte(0);
        }
    }

    protected final String[] getMutableArgs() {
        return this.m_args;
    }
}

