/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.util.Map;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;

public class ImageConverterBitmap2G2D
extends AbstractImageConverter {
    public Image convert(Image image, Map map) {
        this.checkSourceFlavor(image);
        final ImageRendered imageRendered = (ImageRendered)image;
        Graphics2DImagePainter graphics2DImagePainter = new Graphics2DImagePainter(){

            public Dimension getImageSize() {
                return imageRendered.getSize().getDimensionMpt();
            }

            public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
                RenderedImage renderedImage = imageRendered.getRenderedImage();
                double d = rectangle2D.getWidth();
                double d2 = rectangle2D.getHeight();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
                double d3 = d / (double)renderedImage.getWidth();
                double d4 = d2 / (double)renderedImage.getHeight();
                if (d3 != 1.0 || d4 != 1.0) {
                    affineTransform.scale(d3, d4);
                }
                graphics2D.drawRenderedImage(renderedImage, affineTransform);
            }
        };
        ImageGraphics2D imageGraphics2D = new ImageGraphics2D(image.getInfo(), graphics2DImagePainter);
        return imageGraphics2D;
    }

    public ImageFlavor getSourceFlavor() {
        return ImageFlavor.RENDERED_IMAGE;
    }

    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }
}

