/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.ImageSource;
import org.apache.xmlgraphics.image.loader.util.ImageInputStreamAdapter;
import org.xml.sax.InputSource;

public final class ImageUtil {
    private static final byte[] GZIP_MAGIC = new byte[]{31, -117};
    private static final String PAGE_INDICATOR = "page=";

    private ImageUtil() {
    }

    public static InputStream getInputStream(Source source) {
        InputSource inputSource;
        if (source instanceof StreamSource) {
            return ((StreamSource)source).getInputStream();
        }
        if (source instanceof ImageSource) {
            return new ImageInputStreamAdapter(((ImageSource)source).getImageInputStream());
        }
        if (source instanceof SAXSource && (inputSource = ((SAXSource)source).getInputSource()) != null) {
            return inputSource.getByteStream();
        }
        return null;
    }

    public static ImageInputStream getImageInputStream(Source source) {
        if (source instanceof ImageSource) {
            return ((ImageSource)source).getImageInputStream();
        }
        return null;
    }

    public static InputStream needInputStream(Source source) {
        InputStream inputStream = ImageUtil.getInputStream(source);
        if (inputStream != null) {
            return inputStream;
        }
        throw new IllegalArgumentException("Source must be a StreamSource with an InputStream or an ImageSource");
    }

    public static ImageInputStream needImageInputStream(Source source) {
        if (source instanceof ImageSource) {
            ImageSource imageSource = (ImageSource)source;
            if (imageSource.getImageInputStream() == null) {
                throw new IllegalArgumentException("ImageInputStream is null/cleared on ImageSource");
            }
            return imageSource.getImageInputStream();
        }
        throw new IllegalArgumentException("Source must be an ImageSource");
    }

    public static boolean hasInputStream(Source source) {
        InputSource inputSource;
        if (source instanceof StreamSource) {
            InputStream inputStream = ((StreamSource)source).getInputStream();
            return inputStream != null;
        }
        if (source instanceof ImageSource) {
            return ImageUtil.hasImageInputStream(source);
        }
        if (source instanceof SAXSource && (inputSource = ((SAXSource)source).getInputSource()) != null) {
            return inputSource.getByteStream() != null;
        }
        return false;
    }

    public static boolean hasReader(Source source) {
        InputSource inputSource;
        if (source instanceof StreamSource) {
            Reader reader = ((StreamSource)source).getReader();
            return reader != null;
        }
        if (source instanceof SAXSource && (inputSource = ((SAXSource)source).getInputSource()) != null) {
            return inputSource.getCharacterStream() != null;
        }
        return false;
    }

    public static boolean hasImageInputStream(Source source) {
        ImageInputStream imageInputStream;
        return source instanceof ImageSource && (imageInputStream = ((ImageSource)source).getImageInputStream()) != null;
    }

    public static void removeStreams(Source source) {
        InputSource inputSource;
        if (source instanceof ImageSource) {
            ImageSource imageSource = (ImageSource)source;
            imageSource.setImageInputStream(null);
        } else if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            streamSource.setInputStream(null);
            streamSource.setReader(null);
        } else if (source instanceof SAXSource && (inputSource = ((SAXSource)source).getInputSource()) != null) {
            inputSource.setByteStream(null);
            inputSource.setCharacterStream(null);
        }
    }

    public static void closeQuietly(Source source) {
        InputSource inputSource;
        if (source == null) {
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            IOUtils.closeQuietly((InputStream)streamSource.getInputStream());
            streamSource.setInputStream(null);
            IOUtils.closeQuietly((Reader)streamSource.getReader());
            streamSource.setReader(null);
        } else if (source instanceof ImageSource) {
            ImageSource imageSource = (ImageSource)source;
            if (imageSource.getImageInputStream() != null) {
                try {
                    imageSource.getImageInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                imageSource.setImageInputStream(null);
            }
        } else if (source instanceof SAXSource && (inputSource = ((SAXSource)source).getInputSource()) != null) {
            IOUtils.closeQuietly((InputStream)inputSource.getByteStream());
            inputSource.setByteStream(null);
            IOUtils.closeQuietly((Reader)inputSource.getCharacterStream());
            inputSource.setCharacterStream(null);
        }
    }

    public static ImageInputStream ignoreFlushing(final ImageInputStream imageInputStream) {
        return (ImageInputStream)Proxy.newProxyInstance(imageInputStream.getClass().getClassLoader(), new Class[]{ImageInputStream.class}, new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                String string = method.getName();
                if (!string.startsWith("flush")) {
                    try {
                        return method.invoke((Object)imageInputStream, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getCause();
                    }
                }
                return null;
            }
        });
    }

    public static boolean isGZIPCompressed(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark()!");
        }
        byte[] byArray = new byte[2];
        inputStream.mark(2);
        inputStream.read(byArray);
        inputStream.reset();
        return byArray[0] == GZIP_MAGIC[0] && byArray[1] == GZIP_MAGIC[1];
    }

    public static InputStream decorateMarkSupported(InputStream inputStream) {
        if (inputStream.markSupported()) {
            return inputStream;
        }
        return new BufferedInputStream(inputStream);
    }

    public static InputStream autoDecorateInputStream(InputStream inputStream) throws IOException {
        if (ImageUtil.isGZIPCompressed(inputStream = ImageUtil.decorateMarkSupported(inputStream))) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static Map getDefaultHints(ImageSessionContext imageSessionContext) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put(ImageProcessingHints.SOURCE_RESOLUTION, new Float(imageSessionContext.getParentContext().getSourceResolution()));
        hashMap.put(ImageProcessingHints.TARGET_RESOLUTION, new Float(imageSessionContext.getTargetResolution()));
        hashMap.put(ImageProcessingHints.IMAGE_SESSION_CONTEXT, imageSessionContext);
        return hashMap;
    }

    public static Integer getPageIndexFromURI(String string) {
        if (string.indexOf(35) < 0) {
            return null;
        }
        try {
            int n;
            URI uRI = new URI(string);
            String string2 = uRI.getFragment();
            if (string2 != null && (n = string2.indexOf(PAGE_INDICATOR)) >= 0) {
                int n2;
                n += PAGE_INDICATOR.length();
                StringBuffer stringBuffer = new StringBuffer();
                while (n < string2.length() && (n2 = string2.charAt(n)) >= 48 && n2 <= 57) {
                    stringBuffer.append((char)n2);
                    ++n;
                }
                if (stringBuffer.length() > 0) {
                    n2 = Integer.parseInt(stringBuffer.toString()) - 1;
                    n2 = Math.max(0, n2);
                    return new Integer(n2);
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("URI is invalid: " + uRISyntaxException.getLocalizedMessage());
        }
        return null;
    }

    public static int needPageIndexFromURI(String string) {
        Integer n = ImageUtil.getPageIndexFromURI(string);
        if (n != null) {
            return n;
        }
        return 0;
    }
}

