/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.util.SoftReferenceWithKey;

public class SoftMapCache {
    private static Log log = LogFactory.getLog(SoftMapCache.class);
    private Map map;
    private ReferenceQueue refQueue = new ReferenceQueue();

    public SoftMapCache(boolean bl) {
        this.map = new HashMap();
        if (bl) {
            this.map = Collections.synchronizedMap(this.map);
        }
    }

    public Object get(Object object) {
        Reference reference = (Reference)this.map.get(object);
        return this.getReference(object, reference);
    }

    public Object remove(Object object) {
        Reference reference = (Reference)this.map.remove(object);
        return this.getReference(object, reference);
    }

    private Object getReference(Object object, Reference reference) {
        Object var3_3 = null;
        if (reference != null && (var3_3 = reference.get()) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Image has been collected: " + object));
            }
            this.checkReferenceQueue();
        }
        return var3_3;
    }

    public void put(Object object, Object object2) {
        this.map.put(object, this.wrapInReference(object2, object));
    }

    public void clear() {
        this.map.clear();
    }

    public void doHouseKeeping() {
        this.checkReferenceQueue();
    }

    private Reference wrapInReference(Object object, Object object2) {
        return new SoftReferenceWithKey(object, object2, this.refQueue);
    }

    private void checkReferenceQueue() {
        SoftReferenceWithKey softReferenceWithKey;
        while ((softReferenceWithKey = (SoftReferenceWithKey)this.refQueue.poll()) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing ImageInfo from ref queue: " + softReferenceWithKey.getKey()));
            }
            this.map.remove(softReferenceWithKey.getKey());
        }
    }
}

