/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.rendered;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import org.apache.xmlgraphics.image.rendered.BufferedImageCachableRed;
import org.apache.xmlgraphics.image.rendered.CachableRed;

public class RenderedImageCachableRed
implements CachableRed {
    private RenderedImage src;
    private Vector srcs = new Vector(0);

    public static CachableRed wrap(RenderedImage renderedImage) {
        if (renderedImage instanceof CachableRed) {
            return (CachableRed)renderedImage;
        }
        if (renderedImage instanceof BufferedImage) {
            return new BufferedImageCachableRed((BufferedImage)renderedImage);
        }
        return new RenderedImageCachableRed(renderedImage);
    }

    public RenderedImageCachableRed(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new NullPointerException();
        }
        this.src = renderedImage;
    }

    public Vector getSources() {
        return this.srcs;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    public int getMinX() {
        return this.src.getMinX();
    }

    public int getMinY() {
        return this.src.getMinY();
    }

    public int getWidth() {
        return this.src.getWidth();
    }

    public int getHeight() {
        return this.src.getHeight();
    }

    public ColorModel getColorModel() {
        return this.src.getColorModel();
    }

    public SampleModel getSampleModel() {
        return this.src.getSampleModel();
    }

    public int getMinTileX() {
        return this.src.getMinTileX();
    }

    public int getMinTileY() {
        return this.src.getMinTileY();
    }

    public int getNumXTiles() {
        return this.src.getNumXTiles();
    }

    public int getNumYTiles() {
        return this.src.getNumYTiles();
    }

    public int getTileGridXOffset() {
        return this.src.getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        return this.src.getTileGridYOffset();
    }

    public int getTileWidth() {
        return this.src.getTileWidth();
    }

    public int getTileHeight() {
        return this.src.getTileHeight();
    }

    public Object getProperty(String string) {
        return this.src.getProperty(string);
    }

    public String[] getPropertyNames() {
        return this.src.getPropertyNames();
    }

    public Raster getTile(int n, int n2) {
        return this.src.getTile(n, n2);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        return this.src.copyData(writableRaster);
    }

    public Raster getData() {
        return this.src.getData();
    }

    public Raster getData(Rectangle rectangle) {
        return this.src.getData(rectangle);
    }

    public Shape getDependencyRegion(int n, Rectangle rectangle) {
        throw new IndexOutOfBoundsException("Nonexistant source requested.");
    }

    public Shape getDirtyRegion(int n, Rectangle rectangle) {
        throw new IndexOutOfBoundsException("Nonexistant source requested.");
    }
}

