/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

import java.io.Serializable;

public class QName
implements Serializable {
    private static final long serialVersionUID = -5225376740044770690L;
    private String namespaceURI;
    private String localName;
    private String prefix;
    private int hashCode;

    public QName(String string, String string2, String string3) {
        if (string3 == null) {
            throw new NullPointerException("Parameter localName must not be null");
        }
        if (string3.length() == 0) {
            throw new IllegalArgumentException("Parameter localName must not be empty");
        }
        this.namespaceURI = string;
        this.prefix = string2;
        this.localName = string3;
        this.hashCode = this.toHashString().hashCode();
    }

    public QName(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Parameter localName must not be null");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("Parameter localName must not be empty");
        }
        this.namespaceURI = string;
        int n = string2.indexOf(58);
        if (n > 0) {
            this.prefix = string2.substring(0, n);
            this.localName = string2.substring(n + 1);
        } else {
            this.prefix = null;
            this.localName = string2;
        }
        this.hashCode = this.toHashString().hashCode();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getQName() {
        return this.getPrefix() != null ? this.getPrefix() + ':' + this.getLocalName() : this.getLocalName();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            if (this.getNamespaceURI() == null && qName.getNamespaceURI() == null || this.getNamespaceURI().equals(qName.getNamespaceURI())) {
                return this.getLocalName().equals(qName.getLocalName());
            }
        }
        return false;
    }

    public String toString() {
        return this.prefix != null ? this.prefix + ":" + this.localName : this.toHashString();
    }

    private String toHashString() {
        return this.namespaceURI != null ? "{" + this.namespaceURI + "}" + this.localName : this.localName;
    }
}

