/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.uri;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.util.io.Base64DecodeStream;

public class DataURIResolver
implements URIResolver {
    private static final Log LOG = LogFactory.getLog(URIResolver.class);

    public Source resolve(String string, String string2) throws TransformerException {
        if (string.startsWith("data:")) {
            return this.parseDataURI(string);
        }
        return null;
    }

    private Source parseDataURI(String string) {
        int n = string.indexOf(44);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string2.endsWith(";base64")) {
            byte[] byArray = string3.getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Base64DecodeStream base64DecodeStream = new Base64DecodeStream(byteArrayInputStream);
            return new StreamSource(base64DecodeStream);
        }
        String string4 = "UTF-8";
        int n2 = string2.indexOf(";charset=");
        if (n2 > 0) {
            string4 = string2.substring(n2 + 9);
        }
        try {
            String string5 = URLDecoder.decode(string3, string4);
            return new StreamSource(new StringReader(string5));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn((Object)illegalArgumentException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.warn((Object)unsupportedEncodingException.getMessage());
        }
        return null;
    }
}

