/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp.schemas;

import java.util.Date;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.PropertyAccess;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPConstants;
import org.apache.xmlgraphics.xmp.XMPProperty;
import org.apache.xmlgraphics.xmp.XMPSchemaAdapter;
import org.apache.xmlgraphics.xmp.XMPSchemaRegistry;
import org.apache.xmlgraphics.xmp.XMPStructure;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicSchema;

public class XMPBasicAdapter
extends XMPSchemaAdapter {
    private static final String ADVISORY = "Advisory";
    private static final String BASE_URL = "BaseURL";
    private static final String CREATE_DATE = "CreateDate";
    private static final String CREATOR_TOOL = "CreatorTool";
    private static final String IDENTIFIER = "Identifier";
    private static final String LABEL = "Label";
    private static final String METADATA_DATE = "MetadataDate";
    private static final String MODIFY_DATE = "ModifyDate";
    private static final String NICKNAME = "Nickname";
    private static final String RATING = "Rating";
    private static final String THUMBNAILS = "Thumbnails";

    public XMPBasicAdapter(Metadata metadata, String string) {
        super(metadata, XMPSchemaRegistry.getInstance().getSchema(string));
    }

    public void setBaseUrl(String string) {
        this.setValue(BASE_URL, string);
    }

    public String getBaseUrl() {
        return this.getValue(BASE_URL);
    }

    public void setCreateDate(Date date) {
        this.setDateValue(CREATE_DATE, date);
    }

    public Date getCreateDate() {
        return this.getDateValue(CREATE_DATE);
    }

    public void setCreatorTool(String string) {
        this.setValue(CREATOR_TOOL, string);
    }

    public String getCreatorTool() {
        return this.getValue(CREATOR_TOOL);
    }

    public void addIdentifier(String string) {
        this.addStringToBag(IDENTIFIER, string);
    }

    public void setIdentifier(String string, String string2) {
        PropertyAccess propertyAccess = this.findQualifiedStructure(IDENTIFIER, XMPBasicSchema.SCHEME_QUALIFIER, string2);
        if (propertyAccess != null) {
            propertyAccess.setProperty(new XMPProperty(XMPConstants.RDF_VALUE, string));
        } else {
            XMPStructure xMPStructure = new XMPStructure();
            xMPStructure.setProperty(new XMPProperty(XMPConstants.RDF_VALUE, string));
            xMPStructure.setProperty(new XMPProperty(XMPBasicSchema.SCHEME_QUALIFIER, string2));
            this.addObjectToArray(IDENTIFIER, xMPStructure, XMPArrayType.BAG);
        }
    }

    public String[] getIdentifiers() {
        return this.getStringArray(IDENTIFIER);
    }

    public String getIdentifier(String string) {
        Object object = this.findQualifiedValue(IDENTIFIER, XMPBasicSchema.SCHEME_QUALIFIER, string);
        return object != null ? object.toString() : null;
    }

    public void setModifyDate(Date date) {
        this.setDateValue(MODIFY_DATE, date);
    }

    public Date getModifyDate() {
        return this.getDateValue(MODIFY_DATE);
    }

    public void setMetadataDate(Date date) {
        this.setDateValue(METADATA_DATE, date);
    }

    public Date getMetadataDate() {
        return this.getDateValue(METADATA_DATE);
    }
}

