/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumExtractorException;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.s;
import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class ChromiumExtractor {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public static ChromiumExtractor create() {
        if (Environment.isWindows()) {
            return new f(null);
        }
        if (Environment.isMac()) {
            return new a(null);
        }
        if (Environment.isLinux() && Environment.is32Bit()) {
            return new d(null);
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            return new c(null);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    public void extract(String object) {
        object = new File((String)object);
        try {
            AccessController.doPrivileged(new s(this, (File)object));
            return;
        }
        catch (Exception exception) {
            throw new ChromiumExtractorException("Failed to extract chromium binaries into " + ((File)object).getAbsoluteFile(), exception);
        }
    }

    public boolean shouldExtract(String string) {
        return !FileUtil.allFilesExist(new File(string), this.getChromiumFiles());
    }

    protected abstract String getArchiveName();

    protected abstract String[] getChromiumFiles();

    static /* synthetic */ Logger a() {
        return a;
    }

    static /* synthetic */ void b(File file) {
        a.info("Restore permissions for file: " + file.getAbsolutePath());
        if (!file.setExecutable(true)) {
            throw new RuntimeException("Failed to update permissions for file: " + file.getAbsolutePath());
        }
    }

    private static final class c
    extends b {
        private c() {
            super(null);
        }

        protected final String getArchiveName() {
            return "/chromium-linux64.zip";
        }

        /* synthetic */ c(s s2) {
            this();
        }
    }

    private static final class d
    extends b {
        private d() {
            super(null);
        }

        protected final String getArchiveName() {
            return "/chromium-linux32.zip";
        }

        /* synthetic */ d(s s2) {
            this();
        }
    }

    private static abstract class b
    extends ChromiumExtractor
    implements e {
        private b() {
        }

        protected String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("locales");
            arrayList.add("jxbrowser-chromium");
            arrayList.add("libjxbrowser-chromium-lib.so");
            arrayList.add("libjxbrowser-common.so");
            arrayList.add("libffmpegsumo.so");
            arrayList.add("chrome.pak");
            arrayList.add("chrome_100_percent.pak");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public final void a(File file) {
            ChromiumExtractor.b(new File(file, "jxbrowser-chromium"));
        }

        /* synthetic */ b(s s2) {
            this();
        }
    }

    private static final class a
    extends ChromiumExtractor
    implements e {
        private a() {
        }

        protected final String getArchiveName() {
            return "/chromium-mac.zip";
        }

        protected final String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("jxbrowser.app");
            arrayList.add("libjxbrowser-common32.dylib");
            arrayList.add("libjxbrowser-common64.dylib");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public final void a(File file) {
            ChromiumExtractor.b(new File(file, "jxbrowser.app/Contents/MacOS/jxbrowser"));
            ChromiumExtractor.b(new File(file, "jxbrowser.app/Contents/Frameworks/jxbrowser-helper.app/Contents/MacOS/jxbrowser-helper"));
        }

        /* synthetic */ a(s s2) {
            this();
        }
    }

    private static final class f
    extends ChromiumExtractor {
        private f() {
        }

        protected final String getArchiveName() {
            return "/chromium-windows.zip";
        }

        protected final String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("locales");
            arrayList.add("ffmpegsumo.dll");
            arrayList.add("icudt.dll");
            arrayList.add("jxbrowser-chromium.exe");
            arrayList.add("jxbrowser-chromium-lib.dll");
            arrayList.add("jxbrowser-common32.dll");
            arrayList.add("jxbrowser-common64.dll");
            arrayList.add("libEGL.dll");
            arrayList.add("libGLESv2.dll");
            arrayList.add("chrome.pak");
            arrayList.add("chrome_100_percent.pak");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        /* synthetic */ f(s s2) {
            this();
        }
    }

    private static interface e {
        public void a(File var1);
    }
}

