/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.ProductInfo;
import com.teamdev.jxbrowser.chromium.internal.EnvironmentException;
import java.util.logging.Logger;

public final class Environment {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public static boolean isJRE7() {
        return System.getProperty("java.specification.version").startsWith("1.7");
    }

    public static boolean isJRE6() {
        return System.getProperty("java.specification.version").startsWith("1.6");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isWindows7() {
        return System.getProperty("os.name").startsWith("Windows 7");
    }

    public static boolean isWindowsXP() {
        return System.getProperty("os.name").startsWith("Windows XP");
    }

    public static boolean isWindows8() {
        return System.getProperty("os.name").startsWith("Windows 8");
    }

    public static boolean isWindowsServer2003() {
        return System.getProperty("os.name").startsWith("Windows 2003");
    }

    public static boolean isWindowsServer2008() {
        return System.getProperty("os.name").startsWith("Windows Server 2008");
    }

    public static boolean isWindowsServer2012() {
        return System.getProperty("os.name").startsWith("Windows Server 2012");
    }

    public static boolean isWindowsVista() {
        return System.getProperty("os.name").startsWith("Windows Vista");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean is64Bit() {
        return "amd64".equals(System.getProperty("os.arch"));
    }

    public static boolean is32Bit() {
        String string = System.getProperty("os.arch");
        return "x86".equals(string) || "i386".equals(string);
    }

    public static void checkEnvironment() {
        if (!(Environment.isWindows7() || Environment.isWindows8() || Environment.isWindowsXP() || Environment.isWindowsServer2008() || Environment.isWindowsServer2003() || Environment.isWindowsServer2012() || Environment.isWindowsVista() || Environment.isMac() || Environment.isLinux())) {
            throw new EnvironmentException("Unsupported operating system. Supported OS: Windows XP (SP2), 7, 8, Vista, 2003 (SP1), 2008, 2012, Mac OS X & Linux. Current OS: " + System.getProperty("os.name"));
        }
        if (!Environment.isJRE6() && !Environment.isJRE7()) {
            throw new EnvironmentException("Unsupported Java version. Supported versions: JRE 1.6.x-1.7.x. Current version: " + System.getProperty("java.specification.version"));
        }
    }

    public static void traceEnvironment() {
        a.info("OS name: " + System.getProperty("os.name"));
        a.info("JRE version: " + System.getProperty("java.specification.version") + (Environment.is64Bit() ? " 64-bit" : " 32-bit"));
        a.info("JxBrowser build: " + ProductInfo.getBuild());
    }
}

