/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserFunction;
import com.teamdev.jxbrowser.chromium.BrowserView;
import com.teamdev.jxbrowser.chromium.CacheStorage;
import com.teamdev.jxbrowser.chromium.ContextMenuHandler;
import com.teamdev.jxbrowser.chromium.ContextMenuParams;
import com.teamdev.jxbrowser.chromium.CookieStorage;
import com.teamdev.jxbrowser.chromium.DefaultDialogHandler;
import com.teamdev.jxbrowser.chromium.DefaultDownloadHandler;
import com.teamdev.jxbrowser.chromium.DefaultPopupHandler;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DownloadHandler;
import com.teamdev.jxbrowser.chromium.EditorCommand;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.LoadDataParams;
import com.teamdev.jxbrowser.chromium.LoadHTMLParams;
import com.teamdev.jxbrowser.chromium.LoadHandler;
import com.teamdev.jxbrowser.chromium.LoadURLParams;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.MediaType;
import com.teamdev.jxbrowser.chromium.PopupContainer;
import com.teamdev.jxbrowser.chromium.PopupHandler;
import com.teamdev.jxbrowser.chromium.PopupParams;
import com.teamdev.jxbrowser.chromium.SavePageType;
import com.teamdev.jxbrowser.chromium.TerminationStatus;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.events.ConsoleEvent;
import com.teamdev.jxbrowser.chromium.events.ConsoleListener;
import com.teamdev.jxbrowser.chromium.events.DisposeEvent;
import com.teamdev.jxbrowser.chromium.events.DisposeListener;
import com.teamdev.jxbrowser.chromium.events.FailLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FrameLoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.RenderEvent;
import com.teamdev.jxbrowser.chromium.events.RenderListener;
import com.teamdev.jxbrowser.chromium.events.StartLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.StatusEvent;
import com.teamdev.jxbrowser.chromium.events.StatusListener;
import com.teamdev.jxbrowser.chromium.events.TitleEvent;
import com.teamdev.jxbrowser.chromium.events.TitleListener;
import com.teamdev.jxbrowser.chromium.events.ZoomEvent;
import com.teamdev.jxbrowser.chromium.events.ZoomListener;
import com.teamdev.jxbrowser.chromium.internal.Callback;
import com.teamdev.jxbrowser.chromium.internal.ChannelCacheStorage;
import com.teamdev.jxbrowser.chromium.internal.ChannelCookieStorage;
import com.teamdev.jxbrowser.chromium.internal.ChromiumEventQueue;
import com.teamdev.jxbrowser.chromium.internal.DialogHandlerDelegate;
import com.teamdev.jxbrowser.chromium.internal.DownloadHandlerDelegate;
import com.teamdev.jxbrowser.chromium.internal.JSValueParser;
import com.teamdev.jxbrowser.chromium.internal.PopupWidget;
import com.teamdev.jxbrowser.chromium.internal.RenderProcess;
import com.teamdev.jxbrowser.chromium.internal.WebViewManager;
import com.teamdev.jxbrowser.chromium.internal.Widget;
import com.teamdev.jxbrowser.chromium.internal.WidgetView;
import com.teamdev.jxbrowser.chromium.internal.ab;
import com.teamdev.jxbrowser.chromium.internal.ac;
import com.teamdev.jxbrowser.chromium.internal.ad;
import com.teamdev.jxbrowser.chromium.internal.ae;
import com.teamdev.jxbrowser.chromium.internal.af;
import com.teamdev.jxbrowser.chromium.internal.ag;
import com.teamdev.jxbrowser.chromium.internal.ah;
import com.teamdev.jxbrowser.chromium.internal.ai;
import com.teamdev.jxbrowser.chromium.internal.aj;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoBackMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoForwardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DisposeBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ExecuteJavaScriptMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetHTMLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetTitleMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetZoomLevelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoBackMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoForwardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsLoadingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.LoadDataMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.LoadURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnAddNewContentsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeDownloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCacheClearMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnConsoleMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFailLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFailProvisionalLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFinishLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidStartProvisionalLoadForFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDocumentAvailableInMainFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDocumentLoadedInFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewCreatedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewGoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunFileChooserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunJavaScriptDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShouldCreateWebContentsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowContextMenuMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowPopupWidgetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnStatusChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTitleChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTooltipChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnWindowCloseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnZoomChangedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PageZoom;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReloadIgnoringCacheMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SaveWebPageMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetZoomLevelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetZoomMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.StopMessage;
import com.teamdev.jxbrowser.chromium.internal.m;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebView
implements Browser {
    private static final Logger a;
    private final WidgetView b;
    private final CookieStorage c;
    private final BrowserContext d;
    private final ChromiumEventQueue e;
    private final ChannelCacheStorage f;
    private final List<LoadListener> g;
    private final List<ZoomListener> h;
    private final List<TitleListener> i;
    private final List<RenderListener> j;
    private final List<StatusListener> k;
    private final List<ConsoleListener> l;
    private final List<DisposeListener> m;
    private final DialogHandlerDelegate n;
    private final DownloadHandlerDelegate o;
    private final Map<String, BrowserFunction> p;
    private LoadHandler q;
    private PopupHandler r;
    private PopupContainer s;
    private ContextMenuHandler t;

    public WebView(WidgetView widgetView, BrowserContext browserContext) {
        this.b = widgetView;
        this.d = browserContext;
        this.p = new HashMap<String, BrowserFunction>();
        this.c = new ChannelCookieStorage(widgetView.getWidget().getChannel());
        this.f = new ChannelCacheStorage(widgetView.getWidget().getChannel());
        this.e = new ChromiumEventQueue();
        this.i = new ArrayList<TitleListener>();
        this.g = new ArrayList<LoadListener>();
        this.j = new ArrayList<RenderListener>();
        this.h = new ArrayList<ZoomListener>();
        this.m = new ArrayList<DisposeListener>();
        this.l = new ArrayList<ConsoleListener>();
        this.k = new ArrayList<StatusListener>();
        this.n = new DialogHandlerDelegate();
        this.o = new DownloadHandlerDelegate();
        this.b.getWidget().getChannel().addChannelListener(new ai(this));
    }

    public Channel getChannel() {
        return this.b.getWidget().getChannel();
    }

    public void initializeDefaultHandlers() {
        this.setDialogHandler(new DefaultDialogHandler());
        this.setDownloadHandler(new DefaultDownloadHandler());
        this.setPopupHandler(new DefaultPopupHandler());
    }

    @Override
    public void addTitleListener(TitleListener titleListener) {
        if (!this.i.contains(titleListener)) {
            this.i.add(titleListener);
        }
    }

    @Override
    public void removeTitleListener(TitleListener titleListener) {
        this.i.remove(titleListener);
    }

    @Override
    public List<TitleListener> getTitleListeners() {
        return new ArrayList<TitleListener>(this.i);
    }

    @Override
    public void addStatusListener(StatusListener statusListener) {
        if (!this.k.contains(statusListener)) {
            this.k.add(statusListener);
        }
    }

    @Override
    public void removeStatusListener(StatusListener statusListener) {
        this.k.remove(statusListener);
    }

    @Override
    public List<StatusListener> getStatusListeners() {
        return new ArrayList<StatusListener>(this.k);
    }

    @Override
    public void addZoomListener(ZoomListener zoomListener) {
        if (!this.h.contains(zoomListener)) {
            this.h.add(zoomListener);
        }
    }

    @Override
    public void removeZoomListener(ZoomListener zoomListener) {
        this.h.remove(zoomListener);
    }

    @Override
    public List<ZoomListener> getZoomListeners() {
        return new ArrayList<ZoomListener>(this.h);
    }

    @Override
    public void addLoadListener(LoadListener loadListener) {
        if (!this.g.contains(loadListener)) {
            this.g.add(loadListener);
        }
    }

    @Override
    public void removeLoadListener(LoadListener loadListener) {
        this.g.remove(loadListener);
    }

    @Override
    public List<LoadListener> getLoadListeners() {
        return new ArrayList<LoadListener>(this.g);
    }

    @Override
    public void addRenderListener(RenderListener renderListener) {
        if (!this.j.contains(renderListener)) {
            this.j.add(renderListener);
        }
    }

    @Override
    public void removeRenderListener(RenderListener renderListener) {
        this.j.remove(renderListener);
    }

    @Override
    public List<RenderListener> getRenderListeners() {
        return new ArrayList<RenderListener>(this.j);
    }

    @Override
    public void addConsoleListener(ConsoleListener consoleListener) {
        if (!this.l.contains(consoleListener)) {
            this.l.add(consoleListener);
        }
    }

    @Override
    public void removeConsoleListener(ConsoleListener consoleListener) {
        this.l.remove(consoleListener);
    }

    @Override
    public List<ConsoleListener> getConsoleListeners() {
        return new ArrayList<ConsoleListener>(this.l);
    }

    @Override
    public void setPopupHandler(PopupHandler popupHandler) {
        this.r = popupHandler;
    }

    @Override
    public PopupHandler getPopupHandler() {
        return this.r;
    }

    @Override
    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        this.t = contextMenuHandler;
    }

    @Override
    public ContextMenuHandler getContextMenuHandler() {
        return this.t;
    }

    @Override
    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.o.setDownloadHandler(downloadHandler);
    }

    @Override
    public DownloadHandler getDownloadHandler() {
        return this.o.getDownloadHandler();
    }

    @Override
    public void setDialogHandler(DialogHandler dialogHandler) {
        this.n.setDialogHandler(dialogHandler);
    }

    @Override
    public DialogHandler getDialogHandler() {
        return this.n.getDialogHandler();
    }

    @Override
    public CookieStorage getCookieStorage() {
        return this.c;
    }

    @Override
    public CacheStorage getCacheStorage() {
        return this.f;
    }

    @Override
    public boolean isCommandEnabled(EditorCommand editorCommand) {
        if (editorCommand == null) {
            throw new IllegalArgumentException("The command parameter cannot be null.");
        }
        RenderProcess renderProcess = WebViewManager.INSTANCE.getRenderProcess((WebView)((Object)renderProcess));
        return renderProcess.isCommandEnabled(editorCommand.getCommandText());
    }

    @Override
    public boolean executeCommand(EditorCommand editorCommand) {
        return this.executeCommand(-2, editorCommand);
    }

    @Override
    public boolean executeCommand(int n2, EditorCommand editorCommand) {
        return this.executeCommand(-2, editorCommand, null);
    }

    @Override
    public boolean executeCommand(EditorCommand editorCommand, String string) {
        return this.executeCommand(-2, editorCommand, string);
    }

    @Override
    public boolean executeCommand(int n2, EditorCommand editorCommand, String string) {
        if (editorCommand == null) {
            throw new IllegalArgumentException("The command parameter cannot be null.");
        }
        RenderProcess renderProcess = WebViewManager.INSTANCE.getRenderProcess((WebView)((Object)renderProcess));
        return renderProcess.executeCommand(n2, editorCommand.getCommandText(), string);
    }

    @Override
    public void setLoadHandler(LoadHandler loadHandler) {
        this.q = loadHandler;
    }

    @Override
    public LoadHandler getLoadHandler() {
        return this.q;
    }

    @Override
    public void saveWebPage(String string, String string2, SavePageType savePageType) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The filePath parameter cannot be empty or null.");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("The dirPath parameter cannot be empty or null.");
        }
        if (savePageType == null) {
            throw new IllegalArgumentException("The saveType parameter cannot be null.");
        }
        boolean bl = ((SaveWebPageMessage)(this = ((WebView)this).b(new SaveWebPageMessage(MessageUIDGenerator.generate(), string, string2, savePageType.getValue())))).getResult();
        if (!bl) {
            a.log(Level.SEVERE, "Initialization of the saving process failed.");
        }
    }

    @Override
    public BrowserView getView() {
        return this.b;
    }

    @Override
    public BrowserContext getContext() {
        return this.d;
    }

    @Override
    public DOMDocument getDocument() {
        return this.getDocument(-1);
    }

    @Override
    public DOMDocument getDocument(int n2) {
        if ((this = WebViewManager.INSTANCE.getRenderProcess((WebView)this)) != null) {
            return ((RenderProcess)this).getDocument(n2);
        }
        return null;
    }

    @Override
    public DOMNodeAtPoint getNodeAtPoint(int n2, int n3) {
        if ((this = WebViewManager.INSTANCE.getRenderProcess((WebView)this)) != null) {
            return ((RenderProcess)this).getNodeAtPoint(n2, n3);
        }
        return null;
    }

    @Override
    public DOMNodeAtPoint getNodeAtPoint(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("The point parameter cannot be null.");
        }
        return this.getNodeAtPoint(point.x, point.y);
    }

    @Override
    public void dispose() {
        Object object = this.b.getWidget();
        Channel channel = ((Widget)object).getChannel();
        if (!this.isDisposed()) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            af af2 = new af(this, channel, countDownLatch);
            object = ((Widget)object).getIPC();
            ((IPC)object).addIPCListener(af2);
            try {
                channel.send(new DisposeBrowserMessage(MessageUIDGenerator.generate()));
                LatchUtil.await(countDownLatch, new IPCException("Failed to execute WebView dispose post message."));
            }
            finally {
                ((IPC)object).removeIPCListener(af2);
            }
            this.b.dispose();
            this.e.onDisposed(this.getDisposeListeners(), new DisposeEvent(this));
            this.e.dispose();
            WebViewManager.INSTANCE.removeWebView(this);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.b.getWidget().getChannel().isClosed();
    }

    @Override
    public void addDisposeListener(DisposeListener disposeListener) {
        if (!this.m.contains(disposeListener)) {
            this.m.add(disposeListener);
        }
    }

    @Override
    public void removeDisposeListener(DisposeListener disposeListener) {
        this.m.remove(disposeListener);
    }

    @Override
    public List<DisposeListener> getDisposeListeners() {
        return new ArrayList<DisposeListener>(this.m);
    }

    @Override
    public void loadURL(String string) {
        this.loadURL(-1, string);
    }

    @Override
    public void loadURL(int n2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The url parameter cannot be null.");
        }
        this.a(new LoadURLMessage(MessageUIDGenerator.generate(), string, n2));
    }

    @Override
    public void loadURL(LoadURLParams loadURLParams) {
        if (loadURLParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        String string = loadURLParams.getPostData();
        if (string == null) {
            this.loadURL(loadURLParams.getURL());
            return;
        }
        String string2 = "Content-Type: application/x-www-form-urlencoded\n";
        this.a(new LoadURLMessage(MessageUIDGenerator.generate(), loadURLParams.getURL(), -1L, string2, string.getBytes(Charset.forName("UTF-8"))));
    }

    @Override
    public void loadHTML(String string) {
        this.loadHTML(-1, string);
    }

    @Override
    public void loadHTML(int n2, String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The html parameter cannot be null or empty.");
        }
        this.loadHTML(n2, new LoadHTMLParams(string, "UTF-8", null));
    }

    @Override
    public void loadHTML(LoadHTMLParams loadHTMLParams) {
        this.loadHTML(-1, loadHTMLParams);
    }

    @Override
    public void loadHTML(int n2, LoadHTMLParams loadHTMLParams) {
        if (loadHTMLParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.loadData(n2, new LoadDataParams(loadHTMLParams.getHTML(), "text/html", loadHTMLParams.getTextEncoding(), loadHTMLParams.getBaseURL()));
    }

    @Override
    public void loadData(LoadDataParams loadDataParams) {
        this.loadData(-1, loadDataParams);
    }

    @Override
    public void loadData(int n2, LoadDataParams loadDataParams) {
        if (loadDataParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.a(new LoadDataMessage(MessageUIDGenerator.generate(), loadDataParams.getData(), loadDataParams.getMimeType(), loadDataParams.getTextEncoding(), loadDataParams.getBaseURL(), n2));
    }

    @Override
    public String getHTML() {
        return this.getHTML(-1);
    }

    @Override
    public String getHTML(int n2) {
        GetHTMLMessage getHTMLMessage = ((WebView)((Object)getHTMLMessage)).b(new GetHTMLMessage(MessageUIDGenerator.generate(), n2, null));
        return getHTMLMessage.getHTML();
    }

    @Override
    public String getURL() {
        GetURLMessage getURLMessage = ((WebView)((Object)getURLMessage)).b(new GetURLMessage(MessageUIDGenerator.generate()));
        return getURLMessage.getURL();
    }

    @Override
    public void executeJavaScript(String string) {
        this.executeJavaScript(-1L, string);
    }

    @Override
    public JSValue executeJavaScriptAndReturnValue(String string) {
        return this.executeJavaScriptAndReturnValue(-1L, string);
    }

    @Override
    public void executeJavaScript(long l2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The javaScript parameter cannot be null.");
        }
        this.a(new ExecuteJavaScriptMessage(MessageUIDGenerator.generate(), l2, string));
    }

    @Override
    public JSValue executeJavaScriptAndReturnValue(long l2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The javaScript parameter cannot be null.");
        }
        ExecuteJavaScriptMessage executeJavaScriptMessage = ((WebView)((Object)executeJavaScriptMessage)).b(new ExecuteJavaScriptMessage(MessageUIDGenerator.generate(), l2, string, true));
        return JSValueParser.create(executeJavaScriptMessage);
    }

    @Override
    public void registerFunction(String string, BrowserFunction browserFunction) {
        this.p.put(string, browserFunction);
    }

    @Override
    public void unregisterFunction(String string) {
        this.p.remove(string);
    }

    public List<String> getBrowserFunctionNames() {
        return new ArrayList<String>(this.p.keySet());
    }

    public BrowserFunction getBrowserFunction(String string) {
        return this.p.get(string);
    }

    @Override
    public String getTitle() {
        GetTitleMessage getTitleMessage = ((WebView)((Object)getTitleMessage)).b(new GetTitleMessage(MessageUIDGenerator.generate()));
        return getTitleMessage.getTitle();
    }

    @Override
    public void setZoomLevel(double d2) {
        this.a(new SetZoomLevelMessage(MessageUIDGenerator.generate(), d2));
    }

    @Override
    public double getZoomLevel() {
        GetZoomLevelMessage getZoomLevelMessage = ((WebView)((Object)getZoomLevelMessage)).b(new GetZoomLevelMessage(MessageUIDGenerator.generate()));
        return getZoomLevelMessage.getZoomLevel();
    }

    @Override
    public void zoomIn() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_IN.getValue()));
    }

    @Override
    public void zoomOut() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_OUT.getValue()));
    }

    @Override
    public void zoomReset() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_RESET.getValue()));
    }

    @Override
    public boolean isLoading() {
        IsLoadingMessage isLoadingMessage = ((WebView)((Object)isLoadingMessage)).b(new IsLoadingMessage(MessageUIDGenerator.generate()));
        return isLoadingMessage.isLoading();
    }

    @Override
    public void stop() {
        this.a(new StopMessage(MessageUIDGenerator.generate()));
    }

    @Override
    public void goBack() {
        this.a(new GoBackMessage(MessageUIDGenerator.generate()));
    }

    @Override
    public boolean canGoBack() {
        CanGoBackMessage canGoBackMessage = ((WebView)((Object)canGoBackMessage)).b(new CanGoBackMessage(MessageUIDGenerator.generate()));
        return canGoBackMessage.canGoBack();
    }

    @Override
    public void goForward() {
        this.a(new GoForwardMessage(MessageUIDGenerator.generate()));
    }

    @Override
    public boolean canGoForward() {
        CanGoForwardMessage canGoForwardMessage = ((WebView)((Object)canGoForwardMessage)).b(new CanGoForwardMessage(MessageUIDGenerator.generate()));
        return canGoForwardMessage.canGoForward();
    }

    @Override
    public void reload() {
        this.reload(false);
    }

    @Override
    public void reloadIgnoringCache() {
        this.reloadIgnoringCache(false);
    }

    @Override
    public void reload(boolean bl) {
        this.a(new ReloadMessage(MessageUIDGenerator.generate(), bl));
    }

    @Override
    public void reloadIgnoringCache(boolean bl) {
        this.a(new ReloadIgnoringCacheMessage(MessageUIDGenerator.generate(), bl));
    }

    private void a(Message message) {
        Object object = ((WebView)object).b.getWidget();
        object = ((Widget)object).getChannel();
        object.send(message);
    }

    private <T extends Message> T b(T t2) {
        Object object = ((WebView)object).b.getWidget();
        object = ((Widget)object).getChannel();
        return object.post(t2);
    }

    static /* synthetic */ void a(WebView webView, OnShowPopupWidgetMessage onShowPopupWidgetMessage) {
        int n2 = onShowPopupWidgetMessage.getChannelId();
        Rectangle rectangle = onShowPopupWidgetMessage.getPopupBounds();
        PopupWidget popupWidget = new PopupWidget(webView.b, n2, rectangle);
        webView.b.addMouseWheelListener(new ac(webView, popupWidget));
        try {
            popupWidget.show();
            return;
        }
        finally {
            webView.a(onShowPopupWidgetMessage);
        }
    }

    static /* synthetic */ void a(WebView webView, OnRenderViewCreatedMessage onRenderViewCreatedMessage) {
        webView.e.onRenderCreated(webView.getRenderListeners(), new RenderEvent(webView));
    }

    static /* synthetic */ void a(WebView webView, OnRenderViewGoneMessage object) {
        object = new RenderEvent(webView, ((OnRenderViewGoneMessage)object).getErrorCode(), TerminationStatus.valueOf(((OnRenderViewGoneMessage)object).getTerminationStatus()));
        webView.e.onRenderGone(webView.getRenderListeners(), (RenderEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidStartProvisionalLoadForFrameMessage object) {
        object = new StartLoadingEvent(webView, ((OnDidStartProvisionalLoadForFrameMessage)object).getFrameId(), ((OnDidStartProvisionalLoadForFrameMessage)object).getParentFrameId(), ((OnDidStartProvisionalLoadForFrameMessage)object).isMainFrame(), ((OnDidStartProvisionalLoadForFrameMessage)object).getValidatedURL(), ((OnDidStartProvisionalLoadForFrameMessage)object).isErrorPage());
        webView.e.onStartLoadingFrame(webView.getLoadListeners(), (StartLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidFinishLoadMessage object) {
        object = new FinishLoadingEvent(webView, ((OnDidFinishLoadMessage)object).getFrameId(), ((OnDidFinishLoadMessage)object).isMainFrame(), ((OnDidFinishLoadMessage)object).getValidatedURL());
        webView.e.onFinishLoadingFrame(webView.getLoadListeners(), (FinishLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidFailProvisionalLoadMessage object) {
        object = new FailLoadingEvent(webView, ((OnDidFailProvisionalLoadMessage)object).getFrameId(), ((OnDidFailProvisionalLoadMessage)object).isMainFrame(), ((OnDidFailProvisionalLoadMessage)object).getValidatedURL(), ((OnDidFailProvisionalLoadMessage)object).getErrorCode(), ((OnDidFailProvisionalLoadMessage)object).getErrorDescription());
        webView.e.onFailLoadingFrame(webView.getLoadListeners(), (FailLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidFailLoadMessage object) {
        object = new FailLoadingEvent(webView, ((OnDidFailLoadMessage)object).getFrameId(), ((OnDidFailLoadMessage)object).isMainFrame(), ((OnDidFailLoadMessage)object).getValidatedURL(), ((OnDidFailLoadMessage)object).getErrorCode(), ((OnDidFailLoadMessage)object).getErrorDescription());
        webView.e.onFailLoadingFrame(webView.getLoadListeners(), (FailLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDocumentAvailableInMainFrameMessage onDocumentAvailableInMainFrameMessage) {
        webView.e.onDocumentLoadedInMainFrame(webView.getLoadListeners(), new LoadEvent(webView));
    }

    static /* synthetic */ void a(WebView webView, OnDocumentLoadedInFrameMessage onDocumentLoadedInFrameMessage) {
        webView.e.onDocumentLoadedInFrame(webView.getLoadListeners(), new FrameLoadEvent(webView, onDocumentLoadedInFrameMessage.getFrameId()));
    }

    static /* synthetic */ void a(WebView webView, OnTitleChangeMessage onTitleChangeMessage) {
        webView.e.onTitleChange(webView.getTitleListeners(), new TitleEvent(webView, onTitleChangeMessage.getTitle()));
    }

    static /* synthetic */ void a(WebView webView, OnTooltipChangeMessage object) {
        object = ((OnTooltipChangeMessage)object).getTooltipText();
        SwingUtilities.invokeLater(new ab(webView, (String)object));
    }

    static /* synthetic */ void a(WebView webView, OnShouldCreateWebContentsMessage onShouldCreateWebContentsMessage) {
        Object object = onShouldCreateWebContentsMessage.getFrameName();
        String string = onShouldCreateWebContentsMessage.getTargetURL();
        if (webView.r != null) {
            object = new PopupParams(webView, (String)object, string);
            webView.s = webView.r.handlePopup((PopupParams)object);
            onShouldCreateWebContentsMessage.setShouldCreate(webView.s != null);
        }
        webView.a(onShouldCreateWebContentsMessage);
    }

    static /* synthetic */ void a(WebView webView, OnAddNewContentsMessage onAddNewContentsMessage) {
        try {
            Object object;
            int n2 = onAddNewContentsMessage.getChannelId();
            Object object2 = webView.b.getWidget().getIPC();
            if (!((IPC)object2).hasChannel(n2, ChannelType.Browser)) {
                ((IPC)object2).waitChannel(n2, ChannelType.Browser);
            }
            if ((object = ((IPC)object2).getChannel(n2, ChannelType.Browser)) == null) {
                return;
            }
            object = WebViewManager.INSTANCE.create((Channel)object, webView.getContext());
            object2 = onAddNewContentsMessage.getInitialBounds();
            if (webView.s != null) {
                webView.s.insertBrowser((Browser)object, (Rectangle)object2);
                webView.s = null;
            }
            return;
        }
        finally {
            webView.a(onAddNewContentsMessage);
        }
    }

    static /* synthetic */ void a(WebView webView, OnShowContextMenuMessage object) {
        if (webView.t != null) {
            MediaType mediaType = MediaType.valueOf(((OnShowContextMenuMessage)object).getMediaType());
            object = new ContextMenuParams(webView, mediaType, ((OnShowContextMenuMessage)object).getX(), ((OnShowContextMenuMessage)object).getY(), ((OnShowContextMenuMessage)object).getLinkURL(), ((OnShowContextMenuMessage)object).getLinkText(), ((OnShowContextMenuMessage)object).getSrcURL(), ((OnShowContextMenuMessage)object).isImageBlocked(), ((OnShowContextMenuMessage)object).getPageURL(), ((OnShowContextMenuMessage)object).getFrameURL(), ((OnShowContextMenuMessage)object).getFrameId(), ((OnShowContextMenuMessage)object).getSelectionText(), ((OnShowContextMenuMessage)object).getMisspelledWord(), ((OnShowContextMenuMessage)object).getFrameCharset());
            webView.e.invokeLater(new ae(webView, (ContextMenuParams)object));
        }
    }

    static /* synthetic */ void a(WebView webView, OnZoomChangedMessage onZoomChangedMessage) {
        webView.e.onZoomChanged(webView.getZoomListeners(), new ZoomEvent(webView, onZoomChangedMessage.getZoomLevel(), onZoomChangedMessage.isRemember(), onZoomChangedMessage.getURL()));
    }

    static /* synthetic */ void a(WebView webView, OnBeforeDownloadMessage onBeforeDownloadMessage) {
        onBeforeDownloadMessage = webView.o.handle(webView, onBeforeDownloadMessage);
        webView.a(onBeforeDownloadMessage);
    }

    static /* synthetic */ void a(WebView webView, OnRunJavaScriptDialogMessage onRunJavaScriptDialogMessage) {
        webView.n.handle(webView, webView.e, onRunJavaScriptDialogMessage, (Callback<Message>)new ad(webView));
    }

    static /* synthetic */ void a(WebView webView, OnRunAuthDialogMessage onRunAuthDialogMessage) {
        webView.n.handle(webView, webView.e, onRunAuthDialogMessage, (Callback<Message>)new ah(webView));
    }

    static /* synthetic */ void a(WebView webView, OnWindowCloseMessage onWindowCloseMessage) {
        webView.e.invokeLater(new ag(webView));
    }

    static /* synthetic */ void a(WebView webView, OnRunFileChooserMessage onRunFileChooserMessage) {
        webView.n.handle(webView, webView.e, onRunFileChooserMessage, (Callback<Message>)new aj(webView));
    }

    static /* synthetic */ void a(WebView webView, OnConsoleMessage onConsoleMessage) {
        webView.e.onConsoleMessage(webView.getConsoleListeners(), new ConsoleEvent(webView, ConsoleEvent.Level.valueOf(onConsoleMessage.getLevel()), onConsoleMessage.getLineNumber(), onConsoleMessage.getMessage(), onConsoleMessage.getSourceId()));
    }

    static /* synthetic */ void a(WebView webView, OnStatusChangeMessage onStatusChangeMessage) {
        webView.e.onStatusChangeMessage(webView.getStatusListeners(), new StatusEvent(webView, onStatusChangeMessage.getURL()));
    }

    static /* synthetic */ void a(WebView webView, OnCacheClearMessage onCacheClearMessage) {
        webView.f.handleMessage(onCacheClearMessage, webView.e);
    }

    static /* synthetic */ void a(WebView webView, Message message) {
        webView.a(message);
    }

    static /* synthetic */ ContextMenuHandler a(WebView webView) {
        return webView.t;
    }

    static /* synthetic */ WidgetView b(WebView webView) {
        return webView.b;
    }

    static {
        com.teamdev.jxbrowser.chromium.internal.m.a().b();
        a = LoggerProvider.getBrowserLogger();
    }
}

