/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcessLogger;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChromiumProcessListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromiumProcess {
    private static final Logger a = LoggerProvider.getChromiumProcessLogger();
    private Process b;
    private final int c;
    private final File d;
    private final List<ChromiumProcessListener> e;

    public ChromiumProcess(int n2, String string) {
        String string2;
        this.c = n2;
        if (Environment.isWindows()) {
            string2 = "jxbrowser-chromium.exe";
        } else if (Environment.isMac()) {
            string2 = "jxbrowser.app/Contents/MacOS/jxbrowser";
        } else if (Environment.isLinux()) {
            string2 = "jxbrowser-chromium";
        } else {
            throw new RuntimeException("Unsupported operating system.");
        }
        this.d = new File(string, string2);
        if (!this.d.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + this.d);
        }
        if (!this.d.isFile()) {
            throw new IllegalArgumentException("File isn't a normal file: " + this.d);
        }
        this.e = new ArrayList<ChromiumProcessListener>();
    }

    public void addChromiumProcessListener(ChromiumProcessListener chromiumProcessListener) {
        if (!this.e.contains(chromiumProcessListener)) {
            this.e.add(chromiumProcessListener);
        }
    }

    public void removeChromiumProcessListener(ChromiumProcessListener chromiumProcessListener) {
        this.e.remove(chromiumProcessListener);
    }

    public List<ChromiumProcessListener> getChromiumProcessListeners() {
        return new ArrayList<ChromiumProcessListener>(this.e);
    }

    public int start() {
        a.info("Start Chromium process...");
        String object5 = ((ChromiumProcess)this).d.getParentFile().getAbsolutePath();
        Object object = this;
        Object object2 = ((ChromiumProcess)object).d.getAbsolutePath();
        Object object3 = new LinkedHashSet<String>();
        object3.add(object2);
        object3.add(String.valueOf(((ChromiumProcess)object).c));
        object = BrowserPreferences.getUserAgent();
        if (object != null && !((String)object).isEmpty()) {
            object3.add("--user-agent=" + object);
        }
        object = BrowserPreferences.getChromiumSwitches();
        object3.addAll(object);
        object = new ArrayList<String>((Collection<String>)object3);
        object2 = new ProcessBuilder((List<String>)object);
        ((ProcessBuilder)object2).directory(new File(object5));
        ((ProcessBuilder)object2).redirectErrorStream(true);
        try {
            StringBuilder interruptedException = new StringBuilder();
            object = object.iterator();
            while (object.hasNext()) {
                object3 = (String)object.next();
                interruptedException.append((String)object3);
                interruptedException.append(' ');
            }
            a.info("Command line: " + interruptedException);
            ((ChromiumProcess)this).b = ((ProcessBuilder)object2).start();
            object = new ChromiumProcessLogger();
            ((ChromiumProcessLogger)object).startLogging(((ChromiumProcess)this).b);
            int n2 = ((ChromiumProcess)this).b.waitFor();
            ((ChromiumProcess)this).b = null;
            a.info("Chromium process exit code " + n2);
            for (ChromiumProcessListener exception : ((ChromiumProcess)this).getChromiumProcessListeners()) {
                exception.onExit(n2);
            }
            return n2;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean isStarted() {
        return this.b != null;
    }
}

