/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.ServerException;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketInfo;
import com.teamdev.jxbrowser.chromium.internal.ipc.d;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketChannelWriter
implements Runnable {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private SocketInfo b;
    private final ChannelStream c;
    private final BlockingQueue<Message> d;

    public SocketChannelWriter(ChannelStream channelStream) {
        this.c = channelStream;
        this.d = new LinkedBlockingQueue<Message>();
        this.c.addChannelStreamListener(new d(this));
    }

    public void setSocketInfo(SocketInfo socketInfo) {
        this.b = socketInfo;
    }

    public void write(Message message) {
        if (this.c.isClosed()) {
            throw new IllegalStateException("Channel is already closed.");
        }
        this.d.add(message);
    }

    public void run() {
        if (this.c.isClosed()) {
            return;
        }
        OutputStream outputStream = this.c.getOutputStream();
        while (!this.c.isClosed()) {
            Message message = null;
            try {
                message = this.d.take();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (message == null || message instanceof a) continue;
            a.info(message.toString() + ", " + this.b);
            try {
                byte[] byArray = new byte[message.getSize()];
                message.serialize(byArray);
                outputStream.write(byArray);
                outputStream.flush();
            }
            catch (SocketException socketException) {
                a.info("Stopping channel writer because '" + socketException.getMessage() + '\'');
                break;
            }
            catch (IOException iOException) {
                if (this.c.isClosed()) continue;
                throw new ServerException("Failed to write bytes to socket stream.", iOException);
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "Unexpected error in channel writer.", exception);
            }
        }
        this.d.clear();
        this.c.close();
    }

    static /* synthetic */ BlockingQueue a(SocketChannelWriter socketChannelWriter) {
        return socketChannelWriter.d;
    }

    private static final class a
    implements Message {
        private a() {
        }

        public final int getUID() {
            throw new UnsupportedOperationException();
        }

        public final MessageType getType() {
            throw new UnsupportedOperationException();
        }

        public final int getSize() {
            throw new UnsupportedOperationException();
        }

        public final void serialize(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        public final void deserialize(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ a(d d2) {
            this();
        }
    }
}

