/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import java.util.Arrays;
import net.jini.core.lookup.ServiceID;

public class MulticastRequest {
    protected String host;
    protected int port;
    protected String[] groups;
    protected ServiceID[] serviceIDs;

    public MulticastRequest(String string, int n, String[] stringArray, ServiceID[] serviceIDArray) {
        stringArray = stringArray != null ? (String[])stringArray.clone() : new String[]{};
        ServiceID[] serviceIDArray2 = serviceIDArray = serviceIDArray != null ? (ServiceID[])serviceIDArray.clone() : new ServiceID[]{};
        if (string == null || Arrays.asList(stringArray).contains(null) || Arrays.asList(serviceIDArray).contains(null)) {
            throw new NullPointerException();
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port out of range: " + n);
        }
        this.host = string;
        this.port = n;
        this.groups = stringArray;
        this.serviceIDs = serviceIDArray;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return (String[])this.groups.clone();
    }

    public ServiceID[] getServiceIDs() {
        return (ServiceID[])this.serviceIDs.clone();
    }

    public String toString() {
        return "MulticastRequest[" + this.host + ":" + this.port + ", " + Arrays.asList(this.groups) + ", " + Arrays.asList(this.serviceIDs) + "]";
    }
}

