/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.plaintext;

import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementDecoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestEncoder;
import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.BaseProvider;
import com.sun.jini.discovery.internal.Plaintext;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

public class Client
extends BaseProvider
implements MulticastRequestEncoder,
MulticastAnnouncementDecoder,
UnicastDiscoveryClient {
    public Client() {
        super("net.jini.discovery.plaintext");
    }

    public void encodeMulticastRequest(MulticastRequest multicastRequest, DatagramBufferFactory datagramBufferFactory, InvocationConstraints invocationConstraints) throws IOException {
        Plaintext.checkConstraints(invocationConstraints);
        Plaintext.encodeMulticastRequest(multicastRequest, datagramBufferFactory);
    }

    public MulticastAnnouncement decodeMulticastAnnouncement(ByteBuffer byteBuffer, InvocationConstraints invocationConstraints) throws IOException {
        Plaintext.checkConstraints(invocationConstraints);
        return Plaintext.decodeMulticastAnnouncement(byteBuffer);
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        Plaintext.checkConstraints(invocationConstraints);
    }

    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints invocationConstraints, ClassLoader classLoader, ClassLoader classLoader2, Collection collection, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException, ClassNotFoundException {
        Plaintext.checkConstraints(invocationConstraints);
        return Plaintext.readUnicastResponse(new BufferedInputStream(socket.getInputStream()), classLoader, false, null, collection);
    }
}

