/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.TimedMap;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.security.AccessController;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import net.jini.io.context.AcknowledgmentSource;

public class HttpServerManager {
    private static final Executor userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(true));
    private final AckListenerMap ackListeners;
    private final Object cookieLock = new Object();
    private long nextCookie = new Random().nextLong();

    public HttpServerManager(long l) {
        this.ackListeners = new AckListenerMap(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String newCookie() {
        Object object = this.cookieLock;
        synchronized (object) {
            return Long.toString(Math.abs(this.nextCookie++), 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAckListener(String string, AcknowledgmentSource.Listener listener) {
        if (string == null || listener == null) {
            throw new NullPointerException();
        }
        AckListenerMap ackListenerMap = this.ackListeners;
        synchronized (ackListenerMap) {
            LinkedList<AcknowledgmentSource.Listener> linkedList = (LinkedList<AcknowledgmentSource.Listener>)this.ackListeners.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<AcknowledgmentSource.Listener>();
                this.ackListeners.put(string, linkedList);
            }
            linkedList.add(listener);
        }
    }

    void notifyAckListeners(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        final LinkedList linkedList = (LinkedList)this.ackListeners.remove(string);
        if (linkedList != null) {
            userThreadPool.execute(new Runnable(){

                public void run() {
                    HttpServerManager.doAckNotifications(linkedList, true);
                }
            }, "Ack notifier");
        }
    }

    private static void doAckNotifications(LinkedList linkedList, boolean bl) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            AcknowledgmentSource.Listener listener = (AcknowledgmentSource.Listener)iterator.next();
            try {
                listener.acknowledgmentReceived(bl);
            }
            catch (Throwable throwable) {}
        }
    }

    private static class AckListenerMap
    extends TimedMap {
        AckListenerMap(long l) {
            super(userThreadPool, l);
        }

        void evicted(Object object, Object object2) {
            HttpServerManager.doAckNotifications((LinkedList)object2, false);
        }
    }
}

