/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class HttpSettings {
    private static final Object lastNonProxyLock = new Object();
    private static String lastNonProxyHosts = null;
    private static SoftReference lastNonProxyPatterns = null;
    private final Properties props;

    public static HttpSettings getHttpSettings() {
        return new HttpSettings(System.getProperties());
    }

    private HttpSettings(Properties properties) {
        this.props = properties;
    }

    public String getHttpProxyHost(String string) {
        String string2 = this.props.getProperty("http.proxyHost");
        return string2 != null || (string2 = this.props.getProperty("proxyHost")) != null ? string2 : string;
    }

    public int getHttpProxyPort(int n) {
        String string = this.props.getProperty("http.proxyPort");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.props.getProperty("proxyPort")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public String getHttpsProxyHost(String string) {
        return this.props.getProperty("https.proxyHost", string);
    }

    public int getHttpsProxyPort(int n) {
        String string = this.props.getProperty("https.proxyPort");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public long getResponseAckTimeout(long l) {
        String string = this.props.getProperty("com.sun.jini.jeri.http.responseAckTimeout");
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public long getConnectionTimeout(long l) {
        String string = this.props.getProperty("com.sun.jini.jeri.http.idleConnectionTimeout");
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public long getServerConnectionTimeout(long l) {
        String string = this.props.getProperty("com.sun.jini.jeri.http.idleServerConnectionTimeout");
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nonProxied(String string, boolean bl) {
        String string2 = this.props.getProperty("http.nonProxyHosts");
        if (string2 == null) {
            return bl;
        }
        Object object = lastNonProxyLock;
        synchronized (object) {
            Pattern[] patternArray;
            if (!string2.equalsIgnoreCase(lastNonProxyHosts) || (patternArray = (Pattern[])lastNonProxyPatterns.get()) == null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        arrayList.add(Pattern.compile(HttpSettings.convertToRegex(stringTokenizer.nextToken()), 2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                patternArray = arrayList.toArray(new Pattern[arrayList.size()]);
                lastNonProxyPatterns = new SoftReference<Pattern[]>(patternArray);
                lastNonProxyHosts = string2;
            }
            for (int i = 0; i < patternArray.length; ++i) {
                if (!patternArray[i].matcher(string).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static String convertToRegex(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c == '.') {
                stringBuffer.append("\\.");
                continue;
            }
            if (c == '*') {
                stringBuffer.append(".*");
                continue;
            }
            throw new IllegalArgumentException("illegal char: " + c);
        }
        return stringBuffer.toString();
    }
}

