/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.ConnectionIO;
import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.jeri.internal.runtime.SelectionManager;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SocketChannelConnectionIO
extends ConnectionIO {
    private static final int RECEIVE_BUFFER_SIZE = 4096;
    private static final int IOV_MAX = 16;
    private static final Executor systemThreadPool;
    private static final Logger logger;
    private static final SelectionManager selectionManager;
    private final SocketChannel channel;
    private final SelectionManager.Key key;
    private final LinkedList sendQueue = new LinkedList();
    private final LinkedList notifyQueue = new LinkedList();
    private final ByteBuffer inputBuffer = ByteBuffer.allocateDirect(4096);
    private final ByteBuffer[] bufferPair = new ByteBuffer[2];
    private final ByteBuffer[] preallocBufferArray = new ByteBuffer[16];
    static final /* synthetic */ boolean $assertionsDisabled;

    SocketChannelConnectionIO(Mux mux, SocketChannel socketChannel) throws IOException {
        super(mux);
        socketChannel.configureBlocking(false);
        this.channel = socketChannel;
        this.key = selectionManager.register(socketChannel, new Handler());
    }

    void start() throws IOException {
        this.key.renewInterestMask(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncSend(ByteBuffer byteBuffer) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            try {
                if (this.sendQueue.isEmpty()) {
                    this.channel.write(byteBuffer);
                }
                if (byteBuffer.hasRemaining()) {
                    this.sendQueue.addLast(byteBuffer);
                    this.key.renewInterestMask(4);
                }
            }
            catch (IOException iOException) {
                this.mux.setDown("I/O error writing to mux connection: " + iOException.toString(), iOException);
                try {
                    this.channel.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncSend(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (this.mux.muxDown) {
                return;
            }
            try {
                block13: {
                    try {
                        if (this.sendQueue.isEmpty()) {
                            this.bufferPair[0] = byteBuffer;
                            this.bufferPair[1] = byteBuffer2;
                            this.channel.write(this.bufferPair);
                        }
                        if (!byteBuffer.hasRemaining()) {
                            if (byteBuffer2.hasRemaining()) {
                                this.sendQueue.addLast(byteBuffer2);
                                this.key.renewInterestMask(4);
                            }
                            break block13;
                        }
                        this.sendQueue.addLast(byteBuffer);
                        this.sendQueue.addLast(byteBuffer2);
                        this.key.renewInterestMask(4);
                    }
                    catch (IOException iOException) {
                        this.mux.setDown("I/O error writing to mux connection: " + iOException.toString(), iOException);
                        try {
                            this.channel.close();
                        }
                        catch (IOException iOException2) {
                        }
                        Object var7_5 = null;
                        this.bufferPair[0] = null;
                        this.bufferPair[1] = null;
                    }
                }
                Object var7_4 = null;
                this.bufferPair[0] = null;
                this.bufferPair[1] = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.bufferPair[0] = null;
                this.bufferPair[1] = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IOFuture futureSend(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        Object object = this.mux.muxLock;
        synchronized (object) {
            IOFuture iOFuture = new IOFuture();
            if (this.mux.muxDown) {
                IOException iOException = new IOException(this.mux.muxDownMessage);
                iOException.initCause(this.mux.muxDownCause);
                iOFuture.done(iOException);
                return iOFuture;
            }
            try {
                block14: {
                    try {
                        if (this.sendQueue.isEmpty()) {
                            this.bufferPair[0] = byteBuffer;
                            this.bufferPair[1] = byteBuffer2;
                            this.channel.write(this.bufferPair);
                        }
                        if (!byteBuffer.hasRemaining()) {
                            if (byteBuffer2.hasRemaining()) {
                                this.sendQueue.addLast(byteBuffer2);
                                this.key.renewInterestMask(4);
                                this.notifyQueue.addLast(byteBuffer2);
                                this.notifyQueue.addLast(iOFuture);
                            } else {
                                iOFuture.done();
                            }
                            break block14;
                        }
                        this.sendQueue.addLast(byteBuffer);
                        this.sendQueue.addLast(byteBuffer2);
                        this.key.renewInterestMask(4);
                        this.notifyQueue.addLast(byteBuffer2);
                        this.notifyQueue.addLast(iOFuture);
                    }
                    catch (IOException iOException) {
                        this.mux.setDown("I/O error writing to mux connection: " + iOException.toString(), iOException);
                        iOFuture.done(iOException);
                        try {
                            this.channel.close();
                        }
                        catch (IOException iOException2) {
                        }
                        Object var8_8 = null;
                        this.bufferPair[0] = byteBuffer;
                        this.bufferPair[1] = byteBuffer2;
                    }
                }
                Object var8_7 = null;
                this.bufferPair[0] = byteBuffer;
                this.bufferPair[1] = byteBuffer2;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.bufferPair[0] = byteBuffer;
                this.bufferPair[1] = byteBuffer2;
                throw throwable;
            }
            return iOFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWriteReady() {
        try {
            Object object = this.mux.muxLock;
            synchronized (object) {
                block10: while (!this.sendQueue.isEmpty()) {
                    ByteBuffer[] byteBufferArray = this.preallocBufferArray;
                    int n = this.sendQueue.size();
                    if (n <= byteBufferArray.length) {
                        byteBufferArray = this.sendQueue.toArray(byteBufferArray);
                    } else {
                        Iterator iterator = this.sendQueue.iterator();
                        n = 0;
                        while (iterator.hasNext() && n < byteBufferArray.length) {
                            byteBufferArray[n++] = (ByteBuffer)iterator.next();
                        }
                    }
                    this.channel.write(byteBufferArray, 0, n);
                    for (int i = 0; i < n; ++i) {
                        ByteBuffer byteBuffer = byteBufferArray[i];
                        if (!$assertionsDisabled && byteBuffer != this.sendQueue.getFirst()) {
                            throw new AssertionError();
                        }
                        if (!byteBuffer.hasRemaining()) {
                            this.sendQueue.removeFirst();
                            if (this.notifyQueue.isEmpty() || byteBuffer != this.notifyQueue.getFirst()) continue;
                            this.notifyQueue.removeFirst();
                            IOFuture iOFuture = (IOFuture)this.notifyQueue.removeFirst();
                            iOFuture.done();
                            continue;
                        }
                        this.key.renewInterestMask(4);
                        break block10;
                    }
                }
            }
        }
        catch (IOException iOException) {
            logger.log(Levels.HANDLED, "mux writer thread dying, I/O error", iOException);
            this.mux.setDown("I/O error writing to mux connection: " + iOException.toString(), iOException);
            this.drainNotifyQueue();
            try {
                this.channel.close();
            }
            catch (IOException iOException2) {}
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "mux writer thread dying, unexpected exception", throwable);
            this.mux.setDown("unexpected exception in mux writer thread: " + throwable.toString(), throwable);
            this.drainNotifyQueue();
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainNotifyQueue() {
        Object object = this.mux.muxLock;
        synchronized (object) {
            if (!$assertionsDisabled && !this.mux.muxDown) {
                throw new AssertionError();
            }
            while (!this.notifyQueue.isEmpty()) {
                this.notifyQueue.removeFirst();
                IOFuture iOFuture = (IOFuture)this.notifyQueue.removeFirst();
                IOException iOException = new IOException(this.mux.muxDownMessage);
                iOException.initCause(this.mux.muxDownCause);
                iOFuture.done(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReadReady() {
        try {
            int n = this.channel.read(this.inputBuffer);
            if (n == -1) {
                throw new EOFException();
            }
            if (n > 0) {
                this.mux.processIncomingData(this.inputBuffer);
            }
            if (!$assertionsDisabled && !this.inputBuffer.hasRemaining()) {
                throw new AssertionError();
            }
            this.key.renewInterestMask(1);
        }
        catch (ProtocolException protocolException) {
            IOFuture iOFuture = null;
            Object object = this.mux.muxLock;
            synchronized (object) {
                if (!this.mux.muxDown) {
                    logger.log(Levels.HANDLED, "mux reader thread dying, protocol error", protocolException);
                    iOFuture = this.mux.futureSendError(protocolException.getMessage());
                    this.mux.setDown("protocol violation detected: " + protocolException.getMessage(), null);
                } else {
                    logger.log(Level.FINEST, "mux reader thread dying: " + protocolException.getMessage());
                }
            }
            if (iOFuture != null) {
                try {
                    iOFuture.waitUntilDone();
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                this.channel.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            logger.log(Levels.HANDLED, "mux reader thread dying, I/O error", iOException);
            this.mux.setDown("I/O error reading from mux connection: " + iOException.toString(), iOException);
            try {
                this.channel.close();
            }
            catch (IOException iOException2) {}
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "mux reader thread dying, unexpected exception", throwable);
            this.mux.setDown("unexpected exception in mux reader thread: " + throwable.toString(), throwable);
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        $assertionsDisabled = !SocketChannelConnectionIO.class.desiredAssertionStatus();
        systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
        logger = Logger.getLogger("net.jini.jeri.connection.mux");
        try {
            selectionManager = new SelectionManager();
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class.forName("sun.nio.ch.IOVecWrapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private class Handler
    implements SelectionManager.SelectionHandler {
        private Handler() {
        }

        public void handleSelection(int n, SelectionManager.Key key) {
            if ((n & 4) != 0) {
                SocketChannelConnectionIO.this.handleWriteReady();
            }
            if ((n & 1) != 0) {
                SocketChannelConnectionIO.this.handleReadReady();
            }
        }
    }
}

