/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import java.io.IOException;
import java.io.Reader;

final class UnicodeEscapesDecodingReader
extends Reader {
    private static final int NO_CHAR = Integer.MIN_VALUE;
    private Reader reader;
    private int peekc = Integer.MIN_VALUE;
    private final char[] code = new char[4];

    UnicodeEscapesDecodingReader(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        this.reader = reader;
    }

    public synchronized int read() throws IOException {
        if (this.reader == null) {
            throw new IOException("stream is closed");
        }
        return this.readInternal();
    }

    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        if (this.reader == null) {
            throw new IOException("stream is closed");
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInternal();
            if (n3 < 0) {
                return i == 0 ? -1 : i;
            }
            cArray[n + i] = (char)n3;
        }
        return n2;
    }

    private int readInternal() throws IOException {
        int n;
        if (this.peekc == Integer.MIN_VALUE) {
            n = this.reader.read();
        } else {
            n = this.peekc;
            this.peekc = Integer.MIN_VALUE;
            if (n == 92) {
                return n;
            }
        }
        if (n != 92) {
            return n;
        }
        n = this.reader.read();
        if (n != 117) {
            this.peekc = n;
            return 92;
        }
        while ((n = this.reader.read()) == 117) {
        }
        int n2 = 0;
        if (n >= 0) {
            int n3;
            this.code[n2++] = (char)n;
            while (n2 < 4 && (n3 = this.reader.read(this.code, n2, 4 - n2)) >= 0) {
                n2 += n3;
            }
        }
        String string = new String(this.code, 0, n2);
        if (n2 == 4) {
            try {
                int n4 = Integer.parseInt(string, 16);
                if (n4 >= 0) {
                    return (char)n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("illegal Unicode escape: \\u" + string);
    }

    public synchronized void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }
}

