/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import [Ljava.net.NetworkInterface;;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.TaskManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.config.NoSuchEntryException;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.Constants;
import net.jini.discovery.DiscoveryChangeListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.DiscoveryPermission;
import net.jini.io.UnsupportedConstraintException;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

public class LookupDiscovery
implements DiscoveryManagement,
DiscoveryGroupManagement {
    private static final String COMPONENT_NAME = "net.jini.discovery.LookupDiscovery";
    private static final Logger logger = Logger.getLogger("net.jini.discovery.LookupDiscovery");
    public static final String[] ALL_GROUPS = DiscoveryGroupManagement.ALL_GROUPS;
    public static final String[] NO_GROUPS = DiscoveryGroupManagement.NO_GROUPS;
    private static final int MAX_N_TASKS = 15;
    private static final int DEFAULT_MAX_PACKET_SIZE = 512;
    private static final int DEFAULT_MULTICAST_TTL = 15;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private boolean terminated = false;
    private ArrayList listeners = new ArrayList(1);
    private Set groups = null;
    private Map registrars = new HashMap(11);
    private Set pendingDiscoveries = new HashSet(11);
    private Notifier notifierThread;
    private LinkedList pendingNotifies = new LinkedList();
    private TaskManager taskManager;
    private AnnouncementListener announceeThread;
    private Collection requestors = new LinkedList();
    private ResponseListener respondeeThread = null;
    private final SecurityContext securityContext = Security.getContext();
    private HashMap regTimes = new HashMap(11);
    private AnnouncementTimerThread announcementTimerThread;
    private ProxyPreparer registrarPreparer;
    private Discovery protocol2 = Discovery.getProtocol2(null);
    private int multicastRequestMax = 7;
    private long multicastRequestInterval = 5000L;
    private long finalMulticastRequestInterval = 120000L;
    private String multicastRequestHost;
    private DiscoveryConstraints multicastRequestConstraints;
    private NetworkInterface[] nics;
    private int nicRetryInterval = 300000;
    private long multicastAnnouncementInterval = 120000L;
    private DiscoveryConstraints multicastAnnouncementConstraints;
    private DiscoveryConstraints unicastDiscoveryConstraints;
    private static final int DISCOVERED = 0;
    private static final int DISCARDED = 1;
    private static final int CHANGED = 2;
    private static final int NICS_USE_ALL = 0;
    private static final int NICS_USE_SYS = 1;
    private static final int NICS_USE_LIST = 2;
    private static final int NICS_USE_NONE = 3;
    private int nicsToUse = 0;

    public LookupDiscovery(String[] stringArray) throws IOException {
        try {
            this.beginDiscovery(stringArray, EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public LookupDiscovery(String[] stringArray, Configuration configuration) throws IOException, ConfigurationException {
        this.beginDiscovery(stringArray, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            throw new NullPointerException("can't add null listener");
        }
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.listeners.indexOf(discoveryListener) >= 0) {
                return;
            }
            this.listeners.add(discoveryListener);
            if (this.registrars.isEmpty()) {
                return;
            }
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.registrars.size());
            Iterator iterator = this.registrars.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                UnicastResponse unicastResponse = (UnicastResponse)iterator.next();
                hashMap.put(unicastResponse.getRegistrar(), unicastResponse.getGroups());
                ++n;
            }
            ArrayList<DiscoveryListener> arrayList = new ArrayList<DiscoveryListener>(1);
            arrayList.add(discoveryListener);
            this.addNotify(arrayList, hashMap, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            this.listeners.remove(discoveryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getRegistrars() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.registrars.isEmpty()) {
                return new ServiceRegistrar[0];
            }
            Iterator iterator = this.registrars.values().iterator();
            ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.registrars.size()];
            int n = 0;
            while (iterator.hasNext()) {
                serviceRegistrarArray[n] = ((UnicastResponse)iterator.next()).getRegistrar();
                ++n;
            }
            return serviceRegistrarArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(ServiceRegistrar serviceRegistrar) {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (serviceRegistrar == null) {
                return;
            }
            this.sendDiscarded(serviceRegistrar, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
        }
        this.nukeThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroups() {
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                return ALL_GROUPS;
            }
            if (this.groups.isEmpty()) {
                return NO_GROUPS;
            }
            return LookupDiscovery.collectionToStrings(this.groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroups(String[] stringArray) throws IOException {
        this.testArrayForNullElement(stringArray);
        LookupDiscovery.checkGroups(stringArray);
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                throw new UnsupportedOperationException("can't add to \"any groups\"");
            }
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.groups.add(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
            if (!arrayList.isEmpty()) {
                this.requestGroups(arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroups(String[] stringArray) throws IOException {
        this.testArrayForNullElement(stringArray);
        LookupDiscovery.checkGroups(stringArray);
        boolean bl = false;
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>(stringArray.length * 2);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (stringArray == null) {
                if (this.groups != null) {
                    this.groups = null;
                    this.requestGroups(null);
                }
                return;
            }
            if (this.groups == null) {
                this.groups = new HashSet(11);
                bl = true;
            }
            HashSet hashSet2 = new HashSet(hashSet);
            hashSet2.removeAll(this.groups);
            HashSet hashSet3 = new HashSet(this.groups);
            hashSet3.removeAll(hashSet);
            this.groups.addAll(hashSet2);
            if (!hashSet3.isEmpty()) {
                bl |= this.removeGroupsInt(LookupDiscovery.collectionToStrings(hashSet3));
            }
            if (!hashSet2.isEmpty()) {
                this.requestGroups(hashSet2);
            }
        }
        if (bl) {
            this.maybeDiscardRegistrars();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroups(String[] stringArray) {
        boolean bl;
        this.testArrayForNullElement(stringArray);
        Map map = this.registrars;
        synchronized (map) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.groups == null) {
                throw new UnsupportedOperationException("can't remove from \"any groups\"");
            }
            bl = this.removeGroupsInt(stringArray);
        }
        if (bl) {
            this.maybeDiscardRegistrars();
        }
    }

    private void sendPacketByNIC(MulticastSocket multicastSocket, DatagramPacket[] datagramPacketArray) throws InterruptedIOException {
        switch (this.nicsToUse) {
            case 0: {
                for (int i = 0; i < this.nics.length; ++i) {
                    LogRecord logRecord;
                    try {
                        multicastSocket.setNetworkInterface(this.nics[i]);
                        LookupDiscovery.sendPacket(multicastSocket, datagramPacketArray);
                        continue;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        throw interruptedIOException;
                    }
                    catch (IOException iOException) {
                        if (!logger.isLoggable(Levels.HANDLED)) continue;
                        logRecord = new LogRecord(Levels.HANDLED, "network interface is bad or not configured for multicast: {0}");
                        logRecord.setParameters(new Object[]{this.nics[i]});
                        logRecord.setThrown(iOException);
                        logger.log(logRecord);
                        continue;
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(Levels.HANDLED)) continue;
                        logRecord = new LogRecord(Levels.HANDLED, "exception while sending packet through network interface: {0}");
                        logRecord.setParameters(new Object[]{this.nics[i]});
                        logRecord.setThrown(exception);
                        logger.log(logRecord);
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.nics.length; ++i) {
                    LogRecord logRecord;
                    try {
                        multicastSocket.setNetworkInterface(this.nics[i]);
                        LookupDiscovery.sendPacket(multicastSocket, datagramPacketArray);
                        continue;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        throw interruptedIOException;
                    }
                    catch (IOException iOException) {
                        if (!logger.isLoggable(Level.SEVERE)) continue;
                        logRecord = new LogRecord(Level.SEVERE, "network interface is bad or not configured for multicast: {0}");
                        logRecord.setParameters(new Object[]{this.nics[i]});
                        logRecord.setThrown(iOException);
                        logger.log(logRecord);
                        continue;
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(Level.SEVERE)) continue;
                        logRecord = new LogRecord(Level.SEVERE, "exception while sending packet through network interface: {0}");
                        logRecord.setParameters(new Object[]{this.nics[i]});
                        logRecord.setThrown(exception);
                        logger.log(logRecord);
                    }
                }
                break;
            }
            case 1: {
                try {
                    LookupDiscovery.sendPacket(multicastSocket, datagramPacketArray);
                    break;
                }
                catch (InterruptedIOException interruptedIOException) {
                    throw interruptedIOException;
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.SEVERE)) break;
                    logger.log(Level.SEVERE, "system default network interface is bad or not configured for multicast", iOException);
                    break;
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(Level.SEVERE)) break;
                    logger.log(Level.SEVERE, "exception while sending packet through system default network interface", exception);
                    break;
                }
            }
            case 3: {
                break;
            }
            default: {
                throw new AssertionError((Object)("nicsToUse flag out of range (0-3): " + this.nicsToUse));
            }
        }
    }

    private static void sendPacket(MulticastSocket multicastSocket, DatagramPacket[] datagramPacketArray) throws IOException {
        for (int i = 0; i < datagramPacketArray.length; ++i) {
            multicastSocket.send(datagramPacketArray[i]);
        }
    }

    private static String getLocalHost() throws UnknownHostException {
        try {
            return ((InetAddress)Security.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost();
                }
            })).getHostAddress();
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (UnknownHostException)privilegedActionException.getCause();
        }
    }

    private static void checkGroups(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                securityManager.checkPermission(new DiscoveryPermission(stringArray[i]));
            }
        } else {
            securityManager.checkPermission(new DiscoveryPermission("*"));
        }
    }

    private static final String[] collectionToStrings(Collection collection) {
        return collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    private static boolean groupSetsEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray[i].equals(stringArray2[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean registrarsEqual(UnicastResponse unicastResponse, UnicastResponse unicastResponse2) {
        return unicastResponse != null && unicastResponse2 != null && unicastResponse2.getRegistrar().equals(unicastResponse.getRegistrar());
    }

    private boolean removeGroupsInt(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            bl |= this.groups.remove(stringArray[i]);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceID[] getServiceIDs() {
        Map map = this.registrars;
        synchronized (map) {
            return this.registrars.keySet().toArray(new ServiceID[this.registrars.size()]);
        }
    }

    private boolean groupsOverlap(String[] stringArray) {
        if (this.groups == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.groups.contains(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void requestGroups(final Collection collection) throws IOException {
        try {
            Security.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    Requestor requestor;
                    Collection collection2 = LookupDiscovery.this.requestors;
                    synchronized (collection2) {
                        if (LookupDiscovery.this.respondeeThread == null) {
                            LookupDiscovery.this.respondeeThread = new ResponseListener();
                            LookupDiscovery.this.respondeeThread.start();
                        }
                        requestor = new Requestor(LookupDiscovery.collectionToStrings(collection), LookupDiscovery.this.respondeeThread.getPort());
                        LookupDiscovery.this.requestors.add(requestor);
                    }
                    requestor.start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddNewRegistrar(UnicastResponse unicastResponse) {
        Object object = this.registrars;
        synchronized (object) {
            if (!this.groupsOverlap(unicastResponse.getGroups())) {
                return;
            }
        }
        try {
            object = unicastResponse.getRegistrar();
            ServiceRegistrar serviceRegistrar = (ServiceRegistrar)AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction((ServiceRegistrar)object){
                private final /* synthetic */ ServiceRegistrar val$srcReg;
                {
                    this.val$srcReg = serviceRegistrar;
                }

                public Object run() throws RemoteException {
                    Object object = LookupDiscovery.this.registrarPreparer.prepareProxy(this.val$srcReg);
                    logger.log(Level.FINEST, "LookupDiscovery - prepared lookup service proxy: {0}", object);
                    return object;
                }
            }), this.securityContext.getAccessControlContext());
            if (serviceRegistrar != object) {
                unicastResponse = new UnicastResponse(unicastResponse.getHost(), unicastResponse.getPort(), unicastResponse.getGroups(), serviceRegistrar);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception instanceof PrivilegedActionException ? ((PrivilegedActionException)exception).getException() : exception;
            logger.log(Level.INFO, "exception while preparing lookup service proxy", exception2);
            return;
        }
        object = this.registrars;
        synchronized (object) {
            if (this.groupsOverlap(unicastResponse.getGroups()) && !LookupDiscovery.registrarsEqual(unicastResponse, this.registrars.put(unicastResponse.getRegistrar().getServiceID(), unicastResponse))) {
                this.regTimes.put(unicastResponse.getRegistrar().getServiceID(), new Long(System.currentTimeMillis()));
                if (!this.listeners.isEmpty()) {
                    this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(unicastResponse.getRegistrar(), unicastResponse.getGroups()), 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeDiscardRegistrars() {
        Map map = this.registrars;
        synchronized (map) {
            HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(this.registrars.size());
            Iterator iterator = this.registrars.values().iterator();
            while (iterator.hasNext()) {
                UnicastResponse unicastResponse = (UnicastResponse)iterator.next();
                if (this.groupsOverlap(unicastResponse.getGroups())) continue;
                hashMap.put(unicastResponse.getRegistrar(), unicastResponse.getGroups());
                this.regTimes.remove(unicastResponse.getRegistrar().getServiceID());
                iterator.remove();
            }
            if (!hashMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), hashMap, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotify(ArrayList arrayList, Map map, int n) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(arrayList, map, n));
            if (this.notifierThread == null) {
                Security.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        LookupDiscovery.this.notifierThread = new Notifier();
                        LookupDiscovery.this.notifierThread.start();
                        return null;
                    }
                });
            }
        }
    }

    private void nukeThreads() {
        Security.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                if (LookupDiscovery.this.announcementTimerThread != null) {
                    LookupDiscovery.this.announcementTimerThread.interrupt();
                }
                Collection collection = LookupDiscovery.this.requestors;
                synchronized (collection) {
                    Iterator iterator = LookupDiscovery.this.requestors.iterator();
                    while (iterator.hasNext()) {
                        Thread thread = (Thread)iterator.next();
                        thread.interrupt();
                    }
                    if (LookupDiscovery.this.respondeeThread != null) {
                        LookupDiscovery.this.respondeeThread.interrupt();
                    }
                }
                if (LookupDiscovery.this.announceeThread != null) {
                    LookupDiscovery.this.announceeThread.interrupt();
                }
                collection = LookupDiscovery.this.pendingDiscoveries;
                synchronized (collection) {
                    LookupDiscovery.this.terminateTaskMgr();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateTaskMgr() {
        Object object = this.taskManager;
        synchronized (object) {
            ArrayList arrayList = this.taskManager.getPending();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.taskManager.remove((TaskManager.Task)arrayList.get(i));
            }
            Set set = this.pendingDiscoveries;
            synchronized (set) {
                Iterator iterator = this.pendingDiscoveries.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    iterator.remove();
                    if (!(e instanceof Socket)) continue;
                    try {
                        ((Socket)e).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.taskManager.terminate();
        }
        object = this.pendingNotifies;
        synchronized (object) {
            this.pendingNotifies.clear();
        }
    }

    private void maybeSendEvent(UnicastResponse unicastResponse, String[] stringArray) {
        ServiceRegistrar serviceRegistrar = unicastResponse.getRegistrar();
        String[] stringArray2 = unicastResponse.getGroups();
        boolean bl = true;
        if (stringArray == null) {
            stringArray = this.getActualGroups(serviceRegistrar);
            if (stringArray == null) {
                return;
            }
            bl = false;
        }
        if (LookupDiscovery.groupSetsEqual(stringArray2, stringArray)) {
            return;
        }
        String[] stringArray3 = stringArray;
        if (bl && stringArray.length > 0 && (stringArray3 = this.getActualGroups(serviceRegistrar)) == null) {
            return;
        }
        this.notifyOnGroupChange(serviceRegistrar, stringArray2, stringArray3);
    }

    private void notifyOnGroupChange(ServiceRegistrar serviceRegistrar, String[] stringArray, String[] stringArray2) {
        boolean bl = LookupDiscovery.groupSetsEqual(stringArray, stringArray2);
        boolean bl2 = this.groupsOverlap(stringArray2);
        if (!bl && bl2) {
            this.sendChanged(serviceRegistrar, stringArray2);
        } else if (!bl2) {
            this.sendDiscarded(serviceRegistrar, stringArray2);
        }
    }

    private void sendDiscarded(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        ServiceID serviceID = serviceRegistrar.getServiceID();
        if (stringArray == null) {
            UnicastResponse unicastResponse = (UnicastResponse)this.registrars.get(serviceID);
            if (unicastResponse == null) {
                return;
            }
            stringArray = unicastResponse.getGroups();
        }
        if (this.registrars.remove(serviceID) != null) {
            this.regTimes.remove(serviceID);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(serviceRegistrar, stringArray), 1);
            }
        }
    }

    private void sendChanged(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        UnicastResponse unicastResponse = (UnicastResponse)this.registrars.get(serviceRegistrar.getServiceID());
        this.registrars.put(serviceRegistrar.getServiceID(), new UnicastResponse(unicastResponse.getHost(), unicastResponse.getPort(), stringArray, unicastResponse.getRegistrar()));
        if (!this.listeners.isEmpty()) {
            this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(serviceRegistrar, stringArray), 2);
        }
    }

    private Map deepCopy(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.clone();
        Set set = hashMap2.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return hashMap2;
    }

    private String[] getActualGroups(final ServiceRegistrar serviceRegistrar) {
        try {
            return (String[])AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return serviceRegistrar.getGroups();
                }
            }), this.securityContext.getAccessControlContext());
        }
        catch (Throwable throwable) {
            this.discard(serviceRegistrar);
            return null;
        }
    }

    private Map mapRegToGroups(ServiceRegistrar serviceRegistrar, String[] stringArray) {
        HashMap<ServiceRegistrar, String[]> hashMap = new HashMap<ServiceRegistrar, String[]>(1);
        hashMap.put(serviceRegistrar, stringArray);
        return hashMap;
    }

    private void testArrayForNullElement(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            throw new NullPointerException("null element in group array");
        }
    }

    private void beginDiscovery(String[] stringArray, Configuration configuration) throws IOException, ConfigurationException {
        this.testArrayForNullElement(stringArray);
        LookupDiscovery.checkGroups(stringArray);
        if (stringArray != null) {
            this.groups = new HashSet(stringArray.length * 2);
            for (int i = 0; i < stringArray.length; ++i) {
                this.groups.add(stringArray[i]);
            }
        }
        this.init(configuration);
        if (this.nicsToUse == 3) {
            return;
        }
        try {
            Security.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    LookupDiscovery.this.announceeThread = new AnnouncementListener();
                    LookupDiscovery.this.announcementTimerThread = new AnnouncementTimerThread();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        if (this.groups == null || !this.groups.isEmpty()) {
            this.requestGroups(this.groups);
        }
        this.announceeThread.start();
        this.announcementTimerThread.start();
    }

    private void init(Configuration configuration) throws IOException, ConfigurationException {
        block11: {
            if (configuration == null) {
                throw new NullPointerException("config is null");
            }
            this.registrarPreparer = (ProxyPreparer)configuration.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            MethodConstraints methodConstraints = (MethodConstraints)configuration.getEntry(COMPONENT_NAME, "discoveryConstraints", MethodConstraints.class, null);
            if (methodConstraints == null) {
                methodConstraints = new BasicMethodConstraints(InvocationConstraints.EMPTY);
            }
            this.multicastRequestConstraints = DiscoveryConstraints.process(methodConstraints.getConstraints(DiscoveryConstraints.multicastRequestMethod));
            this.multicastAnnouncementConstraints = DiscoveryConstraints.process(methodConstraints.getConstraints(DiscoveryConstraints.multicastAnnouncementMethod));
            this.unicastDiscoveryConstraints = DiscoveryConstraints.process(methodConstraints.getConstraints(DiscoveryConstraints.unicastDiscoveryMethod));
            this.taskManager = new TaskManager(15, 15000L, 1.0f);
            try {
                this.taskManager = (TaskManager)configuration.getEntry(COMPONENT_NAME, "taskManager", TaskManager.class, this.taskManager);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            this.multicastRequestMax = (Integer)configuration.getEntry(COMPONENT_NAME, "multicastRequestMax", Integer.TYPE, new Integer(this.multicastRequestMax));
            this.multicastRequestInterval = (Long)configuration.getEntry(COMPONENT_NAME, "multicastRequestInterval", Long.TYPE, new Long(this.multicastRequestInterval));
            this.finalMulticastRequestInterval = (Long)configuration.getEntry(COMPONENT_NAME, "finalMulticastRequestInterval", Long.TYPE, new Long(this.finalMulticastRequestInterval));
            this.multicastRequestHost = (String)configuration.getEntry(COMPONENT_NAME, "multicastRequestHost", String.class, LookupDiscovery.getLocalHost());
            try {
                this.nics = (NetworkInterface[])configuration.getEntry(COMPONENT_NAME, "multicastInterfaces", NetworkInterface;.class);
                if (this.nics == null) {
                    this.nicsToUse = 1;
                    logger.config("LookupDiscovery - using system default network interface for multicast");
                } else if (this.nics.length == 0) {
                    this.nicsToUse = 3;
                    logger.config("LookupDiscovery - MULTICAST DISABLED");
                } else {
                    this.nicsToUse = 2;
                    if (logger.isLoggable(Level.CONFIG)) {
                        logger.log(Level.CONFIG, "LookupDiscovery - multicast network interface(s): {0}", Arrays.asList(this.nics));
                    }
                }
            }
            catch (NoSuchEntryException noSuchEntryException) {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                ArrayList<NetworkInterface> arrayList = enumeration != null ? Collections.list(enumeration) : Collections.EMPTY_LIST;
                this.nics = arrayList.toArray(new NetworkInterface[arrayList.size()]);
                this.nicsToUse = 0;
                if (!logger.isLoggable(Level.CONFIG)) break block11;
                logger.log(Level.CONFIG, "LookupDiscovery - multicast network interface(s): {0}", arrayList);
            }
        }
        this.nicRetryInterval = (Integer)configuration.getEntry(COMPONENT_NAME, "multicastInterfaceRetryInterval", Integer.TYPE, new Integer(this.nicRetryInterval));
        this.multicastAnnouncementInterval = (Long)configuration.getEntry(COMPONENT_NAME, "multicastAnnouncementInterval", Long.TYPE, new Long(this.multicastAnnouncementInterval));
    }

    private MulticastAnnouncement decodeMulticastAnnouncement(final DatagramPacket datagramPacket) throws IOException {
        int n;
        try {
            n = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength()).getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new DiscoveryProtocolException(null, bufferUnderflowException);
        }
        this.multicastAnnouncementConstraints.checkProtocolVersion(n);
        final Discovery discovery = this.getDiscovery(n);
        try {
            return (MulticastAnnouncement)AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return discovery.decodeMulticastAnnouncement(datagramPacket, LookupDiscovery.this.multicastAnnouncementConstraints.getUnfulfilledConstraints());
                }
            }), this.securityContext.getAccessControlContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private DatagramPacket[] encodeMulticastRequest(final MulticastRequest multicastRequest) throws IOException {
        final Discovery discovery = this.getDiscovery(this.multicastRequestConstraints.chooseProtocolVersion());
        final ArrayList arrayList = new ArrayList();
        AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedAction(){

            public Object run() {
                EncodeIterator encodeIterator = discovery.encodeMulticastRequest(multicastRequest, LookupDiscovery.this.multicastRequestConstraints.getMulticastMaxPacketSize(512), LookupDiscovery.this.multicastRequestConstraints.getUnfulfilledConstraints());
                while (encodeIterator.hasNext()) {
                    try {
                        arrayList.addAll(Arrays.asList(encodeIterator.next()));
                    }
                    catch (Exception exception) {
                        logger.log(exception instanceof UnsupportedConstraintException ? Levels.HANDLED : Level.INFO, "exception encoding multicast request", exception);
                    }
                }
                return null;
            }
        }), this.securityContext.getAccessControlContext());
        if (arrayList.isEmpty()) {
            throw new DiscoveryProtocolException("no encoded requests");
        }
        return arrayList.toArray(new DatagramPacket[arrayList.size()]);
    }

    private UnicastResponse doUnicastDiscovery(final Socket socket) throws IOException, ClassNotFoundException {
        final Discovery discovery = this.getDiscovery(this.unicastDiscoveryConstraints.chooseProtocolVersion());
        try {
            return (UnicastResponse)AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return discovery.doUnicastDiscovery(socket, LookupDiscovery.this.unicastDiscoveryConstraints.getUnfulfilledConstraints(), null, null, null);
                }
            }), this.securityContext.getAccessControlContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
    }

    private Discovery getDiscovery(int n) throws DiscoveryProtocolException {
        switch (n) {
            case 1: {
                return Discovery.getProtocol1();
            }
            case 2: {
                return this.protocol2;
            }
        }
        throw new DiscoveryProtocolException("unsupported protocol version: " + n);
    }

    private class UnicastDiscoveryTask
    implements TaskManager.Task {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.finest("LookupDiscovery - UnicastDiscoveryTask started");
            while (true) {
                Object var1_1 = null;
                try {
                    UnicastResponse unicastResponse;
                    Object object;
                    UnicastResponse unicastResponse2;
                    Object object2;
                    block28: {
                        IOException iOException2;
                        Object object3 = LookupDiscovery.this.pendingDiscoveries;
                        synchronized (object3) {
                            object2 = LookupDiscovery.this.pendingDiscoveries.iterator();
                            if (!object2.hasNext()) {
                                return;
                            }
                            var1_1 = object2.next();
                            object2.remove();
                        }
                        object3 = null;
                        object2 = null;
                        unicastResponse2 = null;
                        if (var1_1 instanceof Socket) {
                            object3 = var1_1;
                        } else if (var1_1 instanceof LookupLocator) {
                            object = var1_1;
                            object3 = new Socket(((LookupLocator)object).getHost(), ((LookupLocator)object).getPort());
                        } else if (var1_1 instanceof CheckGroupsMarker) {
                            object2 = ((CheckGroupsMarker)var1_1).announcement;
                        } else if (var1_1 instanceof CheckReachabilityMarker) {
                            unicastResponse2 = ((CheckReachabilityMarker)var1_1).response;
                        }
                        if (object3 == null) break block28;
                        try {
                            ((Socket)object3).setSoTimeout(LookupDiscovery.this.unicastDiscoveryConstraints.getUnicastSocketTimeout(60000));
                            object = LookupDiscovery.this.doUnicastDiscovery((Socket)object3);
                            unicastResponse = null;
                        }
                        catch (Throwable throwable) {
                            unicastResponse = null;
                            try {
                                ((Socket)object3).close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            ((Socket)object3).close();
                        }
                        catch (IOException iOException2) {}
                        LookupDiscovery.this.maybeAddNewRegistrar((UnicastResponse)object);
                        continue;
                    }
                    if (object2 != null) {
                        object = ((MulticastAnnouncement)object2).getServiceID();
                        Map map = LookupDiscovery.this.registrars;
                        synchronized (map) {
                            unicastResponse = (UnicastResponse)LookupDiscovery.this.registrars.get(object);
                            if (unicastResponse != null) {
                                LookupDiscovery.this.maybeSendEvent(unicastResponse, ((MulticastAnnouncement)object2).getGroups());
                            }
                            continue;
                        }
                    }
                    if (unicastResponse2 == null) continue;
                    object = LookupDiscovery.this.registrars;
                    synchronized (object) {
                        LookupDiscovery.this.maybeSendEvent(unicastResponse2, null);
                        continue;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    logger.log(Levels.HANDLED, "exception occurred during unicast discovery", interruptedIOException);
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "exception occurred during unicast discovery", throwable);
                    continue;
                }
                break;
            }
            logger.finest("LookupDiscovery - UnicastDiscoveryTask completed");
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private class DecodeAnnouncementTask
    implements TaskManager.Task {
        private final DatagramPacket datagram;

        public DecodeAnnouncementTask(DatagramPacket datagramPacket) {
            this.datagram = datagramPacket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            MulticastAnnouncement multicastAnnouncement;
            try {
                multicastAnnouncement = LookupDiscovery.this.decodeMulticastAnnouncement(this.datagram);
            }
            catch (Exception exception) {
                if (!(exception instanceof InterruptedIOException)) {
                    logger.log(Levels.HANDLED, "exception decoding multicast announcement", exception);
                }
                return;
            }
            Object object2 = null;
            ServiceID serviceID = multicastAnnouncement.getServiceID();
            Map map = LookupDiscovery.this.registrars;
            synchronized (map) {
                object = (UnicastResponse)LookupDiscovery.this.registrars.get(serviceID);
                if (object != null) {
                    LookupDiscovery.this.regTimes.put(serviceID, new Long(System.currentTimeMillis()));
                    object2 = new CheckGroupsMarker(multicastAnnouncement);
                } else if (LookupDiscovery.this.groupsOverlap(multicastAnnouncement.getGroups())) {
                    object2 = new LookupLocator(multicastAnnouncement.getHost(), multicastAnnouncement.getPort());
                }
            }
            if (object2 != null) {
                boolean bl;
                object = LookupDiscovery.this.pendingDiscoveries;
                synchronized (object) {
                    bl = LookupDiscovery.this.pendingDiscoveries.add(object2);
                }
                if (bl) {
                    new UnicastDiscoveryTask().run();
                }
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private static class CheckReachabilityMarker {
        final UnicastResponse response;

        CheckReachabilityMarker(UnicastResponse unicastResponse) {
            this.response = unicastResponse;
        }

        public int hashCode() {
            return this.response.getRegistrar().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof CheckReachabilityMarker && this.response.getRegistrar().equals(((CheckReachabilityMarker)object).response.getRegistrar());
        }
    }

    private static class CheckGroupsMarker {
        final MulticastAnnouncement announcement;

        CheckGroupsMarker(MulticastAnnouncement multicastAnnouncement) {
            this.announcement = multicastAnnouncement;
        }

        public int hashCode() {
            return this.announcement.getServiceID().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof CheckGroupsMarker && this.announcement.getServiceID().equals(((CheckGroupsMarker)object).announcement.getServiceID());
        }
    }

    private class AnnouncementTimerThread
    extends Thread {
        private static final long N_INTERVALS = 3L;

        public AnnouncementTimerThread() {
            super("multicast announcement timer");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void run() {
            long l = 3L * LookupDiscovery.this.multicastAnnouncementInterval;
            try {
                while (!this.isInterrupted()) {
                    this.wait(LookupDiscovery.this.multicastAnnouncementInterval);
                    long l2 = System.currentTimeMillis();
                    Map map = LookupDiscovery.this.registrars;
                    synchronized (map) {
                        HashMap hashMap = (HashMap)LookupDiscovery.this.regTimes.clone();
                        Set set = hashMap.entrySet();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            ServiceID serviceID = (ServiceID)entry.getKey();
                            long l3 = (Long)entry.getValue();
                            long l4 = l2 - l3;
                            if (l4 <= l) continue;
                            UnicastResponse unicastResponse = (UnicastResponse)LookupDiscovery.this.registrars.get(serviceID);
                            Set set2 = LookupDiscovery.this.pendingDiscoveries;
                            synchronized (set2) {
                                if (LookupDiscovery.this.pendingDiscoveries.add(new CheckReachabilityMarker(unicastResponse))) {
                                    LookupDiscovery.this.taskManager.add(new UnicastDiscoveryTask());
                                }
                            }
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class Requestor
    extends Thread {
        private MulticastSocket sock;
        private int responsePort;
        private String[] groups;

        public Requestor(String[] stringArray, int n) throws IOException {
            super("multicast discovery request");
            this.setDaemon(true);
            this.sock = new MulticastSocket(4160);
            this.sock.setTimeToLive(LookupDiscovery.this.multicastRequestConstraints.getMulticastTimeToLive(15));
            this.responsePort = n;
            this.groups = stringArray == null ? new String[]{} : stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            logger.finest("LookupDiscovery - Requestor thread started");
            try {
                try {
                    int n = LookupDiscovery.this.multicastRequestMax;
                    while (--n >= 0 && !this.isInterrupted()) {
                        DatagramPacket[] datagramPacketArray = LookupDiscovery.this.encodeMulticastRequest(new MulticastRequest(LookupDiscovery.this.multicastRequestHost, this.responsePort, this.groups, LookupDiscovery.this.getServiceIDs()));
                        LookupDiscovery.this.sendPacketByNIC(this.sock, datagramPacketArray);
                        Thread.sleep(n > 0 ? LookupDiscovery.this.multicastRequestInterval : LookupDiscovery.this.finalMulticastRequestInterval);
                    }
                    Object var4_6 = null;
                }
                catch (InterruptedException interruptedException) {
                    Object var4_7 = null;
                    Collection collection2 = LookupDiscovery.this.requestors;
                    synchronized (collection2) {
                        LookupDiscovery.this.requestors.remove(Thread.currentThread());
                        if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                            LookupDiscovery.this.respondeeThread.interrupt();
                            LookupDiscovery.this.respondeeThread = null;
                        }
                    }
                    this.sock.close();
                    logger.finest("LookupDiscovery - Requestor thread completed");
                    return;
                }
                catch (InterruptedIOException interruptedIOException) {
                    Object var4_8 = null;
                    Collection collection3 = LookupDiscovery.this.requestors;
                    synchronized (collection3) {
                        LookupDiscovery.this.requestors.remove(Thread.currentThread());
                        if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                            LookupDiscovery.this.respondeeThread.interrupt();
                            LookupDiscovery.this.respondeeThread = null;
                        }
                    }
                    this.sock.close();
                    logger.finest("LookupDiscovery - Requestor thread completed");
                    return;
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, "exception while marshalling outgoing multicast request", exception);
                    Object var4_9 = null;
                    Collection collection4 = LookupDiscovery.this.requestors;
                    synchronized (collection4) {
                        LookupDiscovery.this.requestors.remove(Thread.currentThread());
                        if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                            LookupDiscovery.this.respondeeThread.interrupt();
                            LookupDiscovery.this.respondeeThread = null;
                        }
                    }
                    this.sock.close();
                    logger.finest("LookupDiscovery - Requestor thread completed");
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                Collection collection = LookupDiscovery.this.requestors;
                synchronized (collection) {
                    LookupDiscovery.this.requestors.remove(Thread.currentThread());
                    if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                        LookupDiscovery.this.respondeeThread.interrupt();
                        LookupDiscovery.this.respondeeThread = null;
                    }
                }
                this.sock.close();
                logger.finest("LookupDiscovery - Requestor thread completed");
                throw throwable;
            }
            Collection collection = LookupDiscovery.this.requestors;
            synchronized (collection) {
                LookupDiscovery.this.requestors.remove(Thread.currentThread());
                if (LookupDiscovery.this.respondeeThread != null && LookupDiscovery.this.requestors.isEmpty()) {
                    LookupDiscovery.this.respondeeThread.interrupt();
                    LookupDiscovery.this.respondeeThread = null;
                }
            }
            this.sock.close();
            logger.finest("LookupDiscovery - Requestor thread completed");
        }
    }

    private class ResponseListener
    extends Thread {
        public ServerSocket serv;
        private boolean interrupted;

        public ResponseListener() throws IOException {
            super("multicast discovery response listener");
            this.interrupted = false;
            this.setDaemon(true);
            this.serv = new ServerSocket(0);
        }

        public void interrupt() {
            this.interrupted = true;
            try {
                new Socket(InetAddress.getLocalHost(), this.getPort()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.finest("LookupDiscovery - ResponseListener thread started");
            while (!this.isInterrupted()) {
                try {
                    Socket socket = this.serv.accept();
                    if (this.isInterrupted()) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    Set set = LookupDiscovery.this.pendingDiscoveries;
                    synchronized (set) {
                        LookupDiscovery.this.pendingDiscoveries.add(socket);
                        LookupDiscovery.this.taskManager.add(new UnicastDiscoveryTask());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, "exception while listening for muliicast response", exception);
                }
            }
            try {
                this.serv.close();
            }
            catch (IOException iOException) {
                logger.log(Levels.HANDLED, "IOException while attempting a socket close", iOException);
            }
            logger.finest("LookupDiscovery - ResponseListener thread completed");
        }

        public int getPort() {
            return this.serv.getLocalPort();
        }
    }

    private class AnnouncementListener
    extends Thread {
        private MulticastSocket sock;
        private ArrayList retryNics;
        private boolean interrupted;

        public AnnouncementListener() throws IOException {
            super("multicast discovery announcement listener");
            this.retryNics = null;
            this.interrupted = false;
            this.setDaemon(true);
            this.sock = new MulticastSocket(4160);
            switch (LookupDiscovery.this.nicsToUse) {
                case 0: {
                    for (int i = 0; i < LookupDiscovery.this.nics.length; ++i) {
                        try {
                            this.sock.setNetworkInterface(LookupDiscovery.this.nics[i]);
                            this.sock.joinGroup(Constants.getAnnouncementAddress());
                            continue;
                        }
                        catch (IOException iOException) {
                            if (this.retryNics == null) {
                                this.retryNics = new ArrayList(LookupDiscovery.this.nics.length);
                            }
                            this.retryNics.add(LookupDiscovery.this.nics[i]);
                            if (!logger.isLoggable(Levels.HANDLED)) continue;
                            LogRecord logRecord = new LogRecord(Levels.HANDLED, "network interface is bad or not configured for multicast: {0}");
                            logRecord.setParameters(new Object[]{LookupDiscovery.this.nics[i]});
                            logRecord.setThrown(iOException);
                            logger.log(logRecord);
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < LookupDiscovery.this.nics.length; ++i) {
                        try {
                            this.sock.setNetworkInterface(LookupDiscovery.this.nics[i]);
                            this.sock.joinGroup(Constants.getAnnouncementAddress());
                            continue;
                        }
                        catch (IOException iOException) {
                            if (this.retryNics == null) {
                                this.retryNics = new ArrayList(LookupDiscovery.this.nics.length);
                            }
                            this.retryNics.add(LookupDiscovery.this.nics[i]);
                            if (!logger.isLoggable(Level.SEVERE)) continue;
                            LogRecord logRecord = new LogRecord(Level.SEVERE, "network interface is bad or not configured for multicast: {0}");
                            logRecord.setParameters(new Object[]{LookupDiscovery.this.nics[i]});
                            logRecord.setThrown(iOException);
                            logger.log(logRecord);
                        }
                    }
                    break;
                }
                case 1: {
                    try {
                        this.sock.joinGroup(Constants.getAnnouncementAddress());
                    }
                    catch (IOException iOException) {
                        this.retryNics = new ArrayList(0);
                        if (!logger.isLoggable(Level.SEVERE)) break;
                        logger.log(Level.SEVERE, "system default network interface is bad or not configured for multicast", iOException);
                    }
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("nicsToUse flag out of range (0-3): " + LookupDiscovery.this.nicsToUse));
                }
            }
        }

        public void interrupt() {
            this.interrupted = true;
            this.sock.close();
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        private void retryBadNics() {
            if (this.retryNics == null) {
                return;
            }
            if (!this.retryNics.isEmpty()) {
                String string = "network interface has recovered from previous failure: {0}";
                ArrayList arrayList = (ArrayList)this.retryNics.clone();
                this.retryNics.clear();
                for (int i = 0; i < arrayList.size(); ++i) {
                    NetworkInterface networkInterface = (NetworkInterface)arrayList.get(i);
                    try {
                        this.sock.setNetworkInterface(networkInterface);
                        this.sock.joinGroup(Constants.getAnnouncementAddress());
                        if (LookupDiscovery.this.nicsToUse == 2) {
                            logger.log(Level.INFO, string, networkInterface);
                            continue;
                        }
                        logger.log(Level.FINE, string, networkInterface);
                        continue;
                    }
                    catch (IOException iOException) {
                        this.retryNics.add(networkInterface);
                    }
                }
                if (this.retryNics.isEmpty()) {
                    this.retryNics = null;
                }
            } else {
                try {
                    this.sock.joinGroup(Constants.getAnnouncementAddress());
                    this.retryNics = null;
                    logger.log(Level.INFO, "system default network interface has recovered from previous failure");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void run() {
            logger.finest("LookupDiscovery - AnnouncementListener thread started");
            byte[] byArray = new byte[LookupDiscovery.this.multicastAnnouncementConstraints.getMulticastMaxPacketSize(512)];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            long l = System.currentTimeMillis() + (long)LookupDiscovery.this.nicRetryInterval;
            while (!this.isInterrupted()) {
                try {
                    int n = 0;
                    if (this.retryNics != null && (n = (int)(l - System.currentTimeMillis())) <= 0) {
                        this.retryBadNics();
                        if (this.retryNics != null) {
                            n = LookupDiscovery.this.nicRetryInterval;
                            l = System.currentTimeMillis() + (long)n;
                        } else {
                            n = 0;
                        }
                    }
                    this.sock.setSoTimeout(n);
                    datagramPacket.setLength(byArray.length);
                    try {
                        this.sock.receive(datagramPacket);
                    }
                    catch (NullPointerException nullPointerException) {
                        break;
                    }
                    LookupDiscovery.this.taskManager.add(new DecodeAnnouncementTask(datagramPacket));
                    byArray = new byte[byArray.length];
                    datagramPacket = new DatagramPacket(byArray, byArray.length);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    if (this.isInterrupted()) break;
                    logger.log(Level.INFO, "exception while listening for multicast announcements", exception);
                }
            }
            this.sock.close();
            this.sock = null;
            logger.finest("LookupDiscovery - AnnouncementListener thread completed");
        }
    }

    private class Notifier
    extends Thread {
        public Notifier() {
            super("event listener notification");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.finest("LookupDiscovery - Notifier thread started");
            while (true) {
                NotifyTask notifyTask;
                LinkedList linkedList = LookupDiscovery.this.pendingNotifies;
                synchronized (linkedList) {
                    if (LookupDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupDiscovery.this.notifierThread = null;
                        return;
                    }
                    notifyTask = (NotifyTask)LookupDiscovery.this.pendingNotifies.removeFirst();
                }
                AccessController.doPrivileged(LookupDiscovery.this.securityContext.wrap(new PrivilegedAction(){

                    public Object run() {
                        boolean bl = true;
                        Iterator iterator = notifyTask.listeners.iterator();
                        while (iterator.hasNext()) {
                            DiscoveryListener discoveryListener = (DiscoveryListener)iterator.next();
                            if (notifyTask.eventType == 2 && !(discoveryListener instanceof DiscoveryChangeListener)) continue;
                            DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)LookupDiscovery.this, LookupDiscovery.this.deepCopy((HashMap)notifyTask.groupsMap));
                            if (bl && logger.isLoggable(Level.FINEST)) {
                                String string = (new String[]{"discovered", "discarded", "changed"})[notifyTask.eventType];
                                ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
                                logger.finest(string + " event  -- " + serviceRegistrarArray.length + " lookup(s)");
                                Map map = discoveryEvent.getGroups();
                                for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                                    LookupLocator lookupLocator = null;
                                    try {
                                        lookupLocator = serviceRegistrarArray[i].getLocator();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    String[] stringArray = (String[])map.get(serviceRegistrarArray[i]);
                                    logger.finest("    " + string + " locator  = " + lookupLocator);
                                    if (stringArray.length == 0) {
                                        logger.finest("    " + string + " group    " + "= NO_GROUPS");
                                        continue;
                                    }
                                    for (int j = 0; j < stringArray.length; ++j) {
                                        logger.finest("    " + string + " group[" + j + "] = " + stringArray[j]);
                                    }
                                }
                            }
                            switch (notifyTask.eventType) {
                                case 0: {
                                    discoveryListener.discovered(discoveryEvent);
                                    break;
                                }
                                case 1: {
                                    discoveryListener.discarded(discoveryEvent);
                                    break;
                                }
                                case 2: {
                                    ((DiscoveryChangeListener)discoveryListener).changed(discoveryEvent);
                                }
                            }
                            bl = false;
                        }
                        return null;
                    }
                }), LookupDiscovery.this.securityContext.getAccessControlContext());
            }
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final int eventType;

        public NotifyTask(ArrayList arrayList, Map map, int n) {
            this.listeners = arrayList;
            this.groupsMap = map;
            this.eventType = n;
        }
    }
}

