/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Vector;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.Constants;

public class OutgoingMulticastAnnouncement {
    protected static final int minMaxPacketSize = 512;
    protected static final int maxPacketSize = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                return Integer.getInteger("net.jini.discovery.mtu", 512);
            }
            catch (SecurityException securityException) {
                return new Integer(512);
            }
        }
    });
    protected static final int protocolVersion = 1;

    public static DatagramPacket[] marshal(ServiceID serviceID, LookupLocator lookupLocator, String[] stringArray) throws IOException {
        Object object;
        OutputStream outputStream;
        OutputStream outputStream2;
        Iterator iterator;
        if (maxPacketSize < 512) {
            throw new RuntimeException("value of net.jini.discovery.mtu property is less than 512");
        }
        Object object2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object2);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeUTF(lookupLocator.getHost());
        dataOutputStream.writeInt(lookupLocator.getPort());
        serviceID.writeBytes(dataOutputStream);
        byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
        if (byArray.length > maxPacketSize) {
            throw new IllegalArgumentException("host name marshals too large");
        }
        object2 = new byte[stringArray.length][];
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            iterator = new ByteArrayOutputStream();
            outputStream2 = new DataOutputStream((OutputStream)((Object)iterator));
            ((DataOutputStream)outputStream2).writeUTF(stringArray[i]);
            ((DataOutputStream)outputStream2).flush();
            object2[i] = ((ByteArrayOutputStream)((Object)iterator)).toByteArray();
            if (byArray.length + 4 + 4 + ((Object)object2[i]).length > maxPacketSize) {
                throw new IllegalArgumentException("group name marshals too large (" + ((Object)object2[i]).length + " bytes)");
            }
            if (((Object)object2[i]).length <= n) continue;
            n = ((Object)object2[i]).length;
        }
        Vector<DatagramPacket> vector = new Vector<DatagramPacket>();
        iterator = Constants.getAnnouncementAddress();
        if (stringArray.length == 0) {
            outputStream2 = new ByteArrayOutputStream(maxPacketSize);
            outputStream = new DataOutputStream(outputStream2);
            ((FilterOutputStream)outputStream).write(byArray);
            ((DataOutputStream)outputStream).writeInt(0);
            object = ((ByteArrayOutputStream)outputStream2).toByteArray();
            vector.add(new DatagramPacket((byte[])object, ((Object)object).length, (InetAddress)((Object)iterator), 4160));
        } else {
            int n2 = 0;
            while (n2 < ((Object)object2).length) {
                int n3;
                outputStream = new ByteArrayOutputStream(maxPacketSize);
                object = new DataOutputStream(outputStream);
                ((FilterOutputStream)object).write(byArray);
                ((DataOutputStream)object).flush();
                int n4 = ((ByteArrayOutputStream)outputStream).size() + 4;
                for (n3 = n2; n3 < ((Object)object2).length && n4 + ((Object)object2[n3]).length <= maxPacketSize; ++n3) {
                    n4 += ((Object)object2[n3]).length;
                }
                ((DataOutputStream)object).writeInt(n3 - n2);
                while (n2 < n3) {
                    ((FilterOutputStream)object).write((byte[])object2[n2++]);
                }
                ((DataOutputStream)object).flush();
                byte[] byArray2 = ((ByteArrayOutputStream)outputStream).toByteArray();
                vector.add(new DatagramPacket(byArray2, byArray2.length, (InetAddress)((Object)iterator), 4160));
            }
        }
        iterator = vector.iterator();
        DatagramPacket[] datagramPacketArray = new DatagramPacket[vector.size()];
        int n5 = 0;
        while (iterator.hasNext()) {
            datagramPacketArray[n5] = (DatagramPacket)iterator.next();
            ++n5;
        }
        return datagramPacketArray;
    }
}

