/*
 * Decompiled with CFR 0.152.
 */
package net.jini.url.httpmd;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.jini.url.httpmd.DelegatingHttpURLConnection;
import net.jini.url.httpmd.HttpmdUtil;
import net.jini.url.httpmd.MdInputStream;

class HttpmdURLConnection
extends DelegatingHttpURLConnection {
    private final String algorithm;
    private final byte[] expectedDigest;
    private final URL content;

    HttpmdURLConnection(URL uRL) throws IOException, MalformedURLException {
        super(uRL);
        int n;
        String string = uRL.getPath() == null ? "" : uRL.getPath();
        int n2 = string.lastIndexOf(59);
        if (n2 < 0) {
            throw new MalformedURLException("Message digest parameter is missing");
        }
        int n3 = string.indexOf(61, n2);
        if (n3 < 0) {
            throw new MalformedURLException("Message digest parameter is missing a '='");
        }
        this.algorithm = string.substring(n2 + 1, n3);
        try {
            MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            MalformedURLException malformedURLException = new MalformedURLException("Message digest parameter algorithm is not found: " + this.algorithm);
            malformedURLException.initCause(noSuchAlgorithmException);
            throw malformedURLException;
        }
        String string2 = string.substring(n3 + 1);
        int n4 = string2.indexOf(44);
        if (n4 >= 0) {
            n = string2.length();
            while (--n > n4) {
                char c = string2.charAt(n);
                if (HttpmdUtil.commentChar(c)) continue;
                throw new MalformedURLException("Comment contains illegal character: '" + c + "'");
            }
            string2 = string2.substring(0, n4);
        }
        if ((n = string2.length()) == 0) {
            throw new MalformedURLException("Message digest parameter digest is empty");
        }
        try {
            this.expectedDigest = HttpmdUtil.stringDigest(string2);
        }
        catch (NumberFormatException numberFormatException) {
            MalformedURLException malformedURLException = new MalformedURLException("Message digest parameter has invalid format for digest: " + string2);
            malformedURLException.initCause(numberFormatException);
            throw malformedURLException;
        }
        try {
            this.content = new URL("http", uRL.getHost(), uRL.getPort(), string.substring(0, n2) + (uRL.getQuery() == null ? "" : uRL.getQuery()) + (uRL.getRef() == null ? "" : uRL.getRef()));
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException malformedURLException2 = new MalformedURLException("Problem with content location");
            malformedURLException2.initCause(malformedURLException);
            throw malformedURLException2;
        }
        this.delegateConnection = (HttpURLConnection)this.content.openConnection();
    }

    public URL getURL() {
        return this.url;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return new MdInputStream(this.url, this.delegateConnection.getInputStream(), MessageDigest.getInstance(this.algorithm), this.expectedDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException("Message digest algorithm not found: " + this.algorithm);
            iOException.initCause(noSuchAlgorithmException);
            throw iOException;
        }
    }
}

