/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import com.mathworks.jmi.types.MLArrayRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.Writable;

public class WritableMLArrayRef
implements Writable,
Serializable {
    private MLArrayRef mlRef = null;

    public static boolean IsNumericType(MLArrayRef ref) {
        return ref.isChar() || ref.isDouble() || ref.isSingle() || ref.isUint16() || ref.isInt16() || ref.isUint8() || ref.isInt8() || ref.isUint32() || ref.isInt32() || ref.isUint64() || ref.isInt64();
    }

    public static boolean IsWritable(MLArrayRef ref) {
        return ref.isCell() || ref.isStruct() || WritableMLArrayRef.IsNumericType(ref);
    }

    public WritableMLArrayRef() {
        this.setMLRef(null);
    }

    public WritableMLArrayRef(MLArrayRef mlRef) {
        this.setMLRef(mlRef);
    }

    public static byte[] toByteArrayFromCell(MLArrayRef mlCellRef) {
        assert (mlCellRef.isCell() && mlCellRef.getNDimensions() == 2 && mlCellRef.getM() == 1 && mlCellRef.getN() == 1);
        return WritableMLArrayRef.toByteArray(mlCellRef.cellAt(0));
    }

    public MLArrayRef getMLRef() {
        return this.mlRef;
    }

    private void setMLRef(MLArrayRef mlRef) {
        this.mlRef = mlRef;
    }

    public void readFields(DataInput input) throws IOException {
        int numSerializedBytes = input.readInt();
        byte[] serializedBytes = new byte[numSerializedBytes];
        input.readFully(serializedBytes, 0, numSerializedBytes);
        this.setMLRef(WritableMLArrayRef.convertToMLArrayRef(serializedBytes));
    }

    public void write(DataOutput output) throws IOException {
        if (!WritableMLArrayRef.IsWritable(this.getMLRef())) {
            throw new IOException("We have chosen to not allow serializing this type.");
        }
        byte[] serializedBytes = WritableMLArrayRef.convertToByteArray(this.getMLRef());
        output.writeInt(serializedBytes.length);
        output.write(serializedBytes);
    }

    public static byte[] toByteArray(MLArrayRef ref) {
        return WritableMLArrayRef.convertToByteArray(ref);
    }

    public static MLArrayRef fromByteArray(byte[] arr) {
        return WritableMLArrayRef.convertToMLArrayRef(arr);
    }

    private static native byte[] convertToByteArray(MLArrayRef var0);

    private static native MLArrayRef convertToMLArrayRef(byte[] var0);

    static {
        String baseLibName = "mwhadoopserializer";
        String libName = "";
        String os_ = System.getProperty("os.name").toLowerCase();
        if (os_.indexOf("win") > -1) {
            libName = "lib" + baseLibName;
        } else if (os_.indexOf("nux") > -1) {
            libName = baseLibName;
        } else if (os_.indexOf("mac") > -1) {
            libName = baseLibName;
        }
        System.loadLibrary(libName);
    }
}

