/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.IAppConstants;
import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.jcd.cls.AbstractClassDefVisitor;
import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.ElementFactory;
import com.vladium.jcd.cls.Field_info;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.IFieldCollection;
import com.vladium.jcd.cls.IInterfaceCollection;
import com.vladium.jcd.cls.IMethodCollection;
import com.vladium.jcd.cls.Method_info;
import com.vladium.jcd.cls.attribute.AttributeElementFactory;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.BridgeAttribute_info;
import com.vladium.jcd.cls.attribute.CodeAttribute_info;
import com.vladium.jcd.cls.attribute.ConstantValueAttribute_info;
import com.vladium.jcd.cls.attribute.Exception_info;
import com.vladium.jcd.cls.attribute.ExceptionsAttribute_info;
import com.vladium.jcd.cls.attribute.GenericAttribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.IExceptionHandlerTable;
import com.vladium.jcd.cls.attribute.InnerClassesAttribute_info;
import com.vladium.jcd.cls.attribute.LineNumberTableAttribute_info;
import com.vladium.jcd.cls.attribute.LineNumber_info;
import com.vladium.jcd.cls.attribute.LocalVariableTableAttribute_info;
import com.vladium.jcd.cls.attribute.LocalVariableTypeTableAttribute_info;
import com.vladium.jcd.cls.attribute.LocalVariableType_info;
import com.vladium.jcd.cls.attribute.LocalVariable_info;
import com.vladium.jcd.cls.attribute.SourceFileAttribute_info;
import com.vladium.jcd.cls.attribute.StackMapTableAttribute_info;
import com.vladium.jcd.cls.attribute.SyntheticAttribute_info;
import com.vladium.jcd.cls.attribute.stackmap.AppendFrame;
import com.vladium.jcd.cls.attribute.stackmap.ChopFrame;
import com.vladium.jcd.cls.attribute.stackmap.FullFrame;
import com.vladium.jcd.cls.attribute.stackmap.ObjectVariable_info;
import com.vladium.jcd.cls.attribute.stackmap.SameLocalFrame;
import com.vladium.jcd.cls.attribute.stackmap.StackMapFrameFactory;
import com.vladium.jcd.cls.attribute.stackmap.StackMapFrame_info;
import com.vladium.jcd.cls.attribute.stackmap.UninitializedVariable_info;
import com.vladium.jcd.cls.attribute.stackmap.VerificationTypeFactory;
import com.vladium.jcd.cls.attribute.stackmap.VerificationType_info;
import com.vladium.jcd.cls.constant.CONSTANT_Class_info;
import com.vladium.jcd.cls.constant.CONSTANT_Long_info;
import com.vladium.jcd.cls.constant.CONSTANT_Methodref_info;
import com.vladium.jcd.cls.constant.CONSTANT_String_info;
import com.vladium.jcd.compiler.CodeGen;
import com.vladium.jcd.lib.Types;
import com.vladium.jcd.opcodes.IOpcodes;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.CollectionUtils;
import com.vladium.util.IConstants;
import com.vladium.util.IntIntMap;
import com.vladium.util.IntObjectMap;
import com.vladium.util.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class InstrVisitor
extends AbstractClassDefVisitor
implements IClassDefVisitor,
IAttributeVisitor,
IOpcodes,
IConstants {
    private final boolean m_excludeEmptyClasses;
    private final boolean m_excludeSyntheticMethods;
    private final boolean m_excludeBridgeMethods;
    private final boolean m_doSUIDCompensation;
    private final boolean m_jdk7Support;
    private final boolean m_excludeSyntheticClasses;
    private final boolean m_excludeEnumClasses;
    private final Logger m_log;
    private boolean m_warningIssued;
    private boolean m_instrument;
    private boolean m_metadata;
    private boolean m_ignoreAlreadyInstrumented;
    ClassDef m_cls;
    private String m_classPackageName;
    private String m_className;
    private String m_classSrcFileName;
    private int[][][] m_classBlockMetadata;
    private MethodDescriptor[] m_classMethodDescriptors;
    private int m_syntheticStringIndex;
    int m_coverageFieldrefIndex;
    private int m_registerMethodrefIndex;
    int m_preclinitMethodrefIndex;
    int m_classNameConstantIndex;
    private int m_stampIndex;
    private int m_clinitID;
    private int m_clinitStatus;
    int m_classInstrMethodCount;
    int[] m_classBlockCounts;
    private long m_classSignature;
    private int instument_one_dimensional_array_index;
    private int instument_two_dimensional_array_index;
    int m_methodID;
    private String m_methodName;
    private int m_methodFirstLine;
    private int m_methodNewLocalSize;
    private int m_methodOriginalCodeSize;
    private int m_methodNewCodeSize;
    private int[] m_methodBlockOffsets;
    private int[] m_methodBlockSizes;
    private int[] m_methodJumpAdjOffsets;
    private int[] m_methodJumpAdjValues;
    private int[] m_methodInstrumentTargets;
    private int[] m_methodOriginalTargets;
    private static final long NBEAST = 16661L;
    private static final int INSTRUMENT_HEAD_TARGET_OFFSET = 11;
    private static final String ONE_DIMENSIONAL_DESCRIPTOR = "[Z";
    private static final String TWO_DIMENSIONAL_DESCRIPTOR = "[[Z";
    private static final String COVERAGE_FIELD_NAME = "$VRc";
    private static final String SUID_FIELD_NAME = "serialVersionUID";
    private static final String PRECLINIT_METHOD_NAME = "$VRi";
    private static final String JAVA_IO_SERIALIZABLE_NAME = "java/io/Serializable";
    private static final String JAVA_IO_EXTERNALIZABLE_NAME = "java/io/Externalizable";
    private static final int EMIT_CTX_MIN_INIT_CAPACITY = 64;
    private static final int PRECLINIT_INIT_CAPACITY = 128;
    private static final boolean MARK_ADDED_ELEMENTS_SYNTHETIC = true;
    private static final LineNumberComparator LINE_NUMBER_COMPARATOR = new LineNumberComparator();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public InstrVisitor(CoverageOptions options) {
        this.m_excludeEmptyClasses = options.excludeEmptyClasses();
        this.m_excludeSyntheticMethods = options.excludeSyntheticMethods();
        this.m_excludeBridgeMethods = options.excludeBridgeMethods();
        this.m_doSUIDCompensation = options.doSUIDCompensation();
        this.m_jdk7Support = options.jdk7Support();
        this.m_excludeSyntheticClasses = options.excludeSyntheticClasses();
        this.m_excludeEnumClasses = options.excludeEnumClasses();
        this.m_log = Logger.getLogger();
    }

    public void process(ClassDef cls, boolean ignoreAlreadyInstrumented, boolean instrument, boolean metadata, InstrResult out) {
        out.m_instrumented = false;
        out.m_descriptor = null;
        if (!instrument && !metadata) {
            return;
        }
        if (cls.isInterface()) {
            return;
        }
        this.reset();
        this.m_cls = cls;
        this.m_instrument = instrument;
        this.m_metadata = metadata;
        this.m_ignoreAlreadyInstrumented = ignoreAlreadyInstrumented;
        this.visit((ClassDef)null, null);
        if (this.m_metadata) {
            this.setClassName(cls.getName());
            out.m_descriptor = new ClassDescriptor(this.m_classPackageName, this.m_className, this.m_classSignature, this.m_classSrcFileName, this.m_classMethodDescriptors);
        }
        out.m_instrumented = this.m_instrument;
    }

    public final Object visit(ClassDef ignore, Object ctx) {
        int[] existing;
        ClassDef cls = this.m_cls;
        String clsVMName = cls.getName();
        String clsName = Types.vmNameToJavaName(clsVMName);
        boolean trace1 = this.m_log.atTRACE1();
        if (trace1) {
            this.m_log.trace1("visit", "class: [" + clsVMName + "]");
        }
        if (this.m_excludeSyntheticClasses && cls.isSynthetic()) {
            this.m_instrument = false;
            this.m_metadata = false;
            if (trace1) {
                this.m_log.trace1("visit", "skipping synthetic class");
            }
            return null;
        }
        if (this.m_excludeEnumClasses && cls.isEnum()) {
            this.m_instrument = false;
            this.m_metadata = false;
            if (trace1) {
                this.m_log.trace1("visit", "skipping enum class");
            }
            return null;
        }
        IMethodCollection methods = cls.getMethods();
        if (this.m_excludeEmptyClasses && methods.size() == 0) {
            this.m_instrument = false;
            this.m_metadata = false;
            if (trace1) {
                this.m_log.trace1("visit", "skipping empty class");
            }
            return null;
        }
        if (!this.m_warningIssued && clsName.startsWith(IAppConstants.APP_PACKAGE)) {
            this.m_warningIssued = true;
            this.m_log.warning("EMMA classes appear to be included on the instrumentation");
            this.m_log.warning("path: this is not a correct way to use EMMA");
        }
        if ((existing = cls.getFields(COVERAGE_FIELD_NAME)).length > 0) {
            this.m_instrument = false;
            this.m_metadata = false;
            if (this.m_ignoreAlreadyInstrumented) {
                if (trace1) {
                    this.m_log.trace1("visit", "skipping instrumented class");
                }
                return ctx;
            }
            throw new IllegalStateException("class [" + clsName + "] appears to be instrumented already");
        }
        IConstantCollection constants = cls.getConstants();
        SyntheticAttribute_info syntheticMarker = null;
        this.m_syntheticStringIndex = cls.addCONSTANT_Utf8("Synthetic", true);
        String fieldDescriptor = TWO_DIMENSIONAL_DESCRIPTOR;
        int fieldModifiers = 26;
        IAttributeCollection fieldAttributes = ElementFactory.newAttributeCollection(1);
        syntheticMarker = new SyntheticAttribute_info(this.m_syntheticStringIndex);
        fieldAttributes.add(syntheticMarker);
        int coverageFieldOffset = cls.addField(COVERAGE_FIELD_NAME, TWO_DIMENSIONAL_DESCRIPTOR, 26, fieldAttributes);
        this.m_coverageFieldrefIndex = cls.addFieldref(coverageFieldOffset);
        String classJVMName = "com/vladium/emma/rt/RT";
        int class_index = cls.addClassref("com/vladium/emma/rt/RT", true);
        String methodDescriptor = "([[ZLjava/lang/String;J)V";
        int nametype_index = cls.addNameType("r", "([[ZLjava/lang/String;J)V");
        this.m_registerMethodrefIndex = constants.add(new CONSTANT_Methodref_info(class_index, nametype_index));
        String methodDescriptor2 = "()[[Z";
        int nametype_index2 = cls.addNameType(PRECLINIT_METHOD_NAME, "()[[Z");
        this.m_preclinitMethodrefIndex = constants.add(new CONSTANT_Methodref_info(cls.getThisClassIndex(), nametype_index2));
        this.m_classNameConstantIndex = constants.add(new CONSTANT_String_info(cls.getThisClass().m_name_index));
        this.visit(methods, null);
        if (this.m_doSUIDCompensation) {
            boolean compensate = (this.m_clinitStatus & 8) != 0;
            int existingSUIDFieldCount = 0;
            if (compensate) {
                int[] existing2 = cls.getFields(SUID_FIELD_NAME);
                existingSUIDFieldCount = existing2.length;
                if (existingSUIDFieldCount > 0) {
                    IFieldCollection fields = cls.getFields();
                    for (int f = 0; f < existingSUIDFieldCount; ++f) {
                        Field_info field = fields.get(existing2[f]);
                        if ((field.getAccessFlags() & 0x18) != 24) continue;
                        compensate = false;
                        break;
                    }
                }
                if (compensate && cls.getThisClassIndex() == 0) {
                    boolean serializable = false;
                    IInterfaceCollection interfaces = cls.getInterfaces();
                    int iLimit = interfaces.size();
                    for (int i = 0; i < iLimit; ++i) {
                        CONSTANT_Class_info ifc = (CONSTANT_Class_info)constants.get(interfaces.get(i));
                        String ifcName = ifc.getName(cls);
                        if (!JAVA_IO_SERIALIZABLE_NAME.equals(ifcName) && !JAVA_IO_EXTERNALIZABLE_NAME.equals(ifcName)) continue;
                        serializable = true;
                        break;
                    }
                    if (!serializable) {
                        compensate = false;
                    }
                }
            }
            if (compensate) {
                if (existingSUIDFieldCount > 0) {
                    this.m_log.warning("class [" + clsName + "] declares a 'serialVersionUID'");
                    this.m_log.warning("field that is not static and final: this is likely an implementation mistake");
                    this.m_log.warning("and can interfere with EMMA's SUID compensation");
                }
                String fieldDescriptor2 = "J";
                int fieldModifiers2 = 26;
                IAttributeCollection fieldAttributes2 = ElementFactory.newAttributeCollection(2);
                int nameIndex = cls.addCONSTANT_Utf8("ConstantValue", true);
                int valueIndex = constants.add(new CONSTANT_Long_info(cls.computeSUID(true)));
                ConstantValueAttribute_info initializer = new ConstantValueAttribute_info(nameIndex, valueIndex);
                fieldAttributes2.add(initializer);
                if (syntheticMarker == null) {
                    syntheticMarker = new SyntheticAttribute_info(this.m_syntheticStringIndex);
                }
                fieldAttributes2.add(syntheticMarker);
                cls.addField(SUID_FIELD_NAME, "J", 26, fieldAttributes2);
            }
        }
        this.visit(cls.getAttributes(), null);
        return null;
    }

    public final Object visit(IMethodCollection methods, Object ctx) {
        int name_index;
        Method_info clinit2;
        ClassDef cls = this.m_cls;
        boolean trace2 = this.m_log.atTRACE2();
        int originalMethodCount = methods.size();
        boolean constructMetadata = this.m_metadata;
        this.m_classBlockCounts = new int[originalMethodCount + 1];
        if (constructMetadata) {
            this.m_classBlockMetadata = new int[originalMethodCount + 1][][];
            this.m_classMethodDescriptors = new MethodDescriptor[originalMethodCount];
        }
        this.instument_one_dimensional_array_index = this.m_cls.addClassref(ONE_DIMENSIONAL_DESCRIPTOR, true);
        this.instument_two_dimensional_array_index = this.m_cls.addClassref(TWO_DIMENSIONAL_DESCRIPTOR, true);
        for (int m = 0; m < originalMethodCount; ++m) {
            Method_info method = methods.get(m);
            this.m_methodName = method.getName(cls);
            if (trace2) {
                this.m_log.trace2("visit", (method.isSynthetic() ? "synthetic " : "") + "method #" + m + ": [" + this.m_methodName + "]");
            }
            boolean isClinit = "<clinit>".equals(this.m_methodName);
            boolean excluded = false;
            if (!isClinit) {
                if (this.m_excludeSyntheticMethods && method.isSynthetic()) {
                    excluded = true;
                    if (trace2) {
                        this.m_log.trace2("visit", "skipped synthetic method");
                    }
                } else if (this.m_excludeBridgeMethods && method.isBridge()) {
                    excluded = true;
                    if (trace2) {
                        this.m_log.trace2("visit", "skipped bridge method");
                    }
                }
            }
            if (excluded) {
                if (!constructMetadata) continue;
                this.m_classMethodDescriptors[m] = new MethodDescriptor(this.m_methodName, method.getDescriptor(cls), 4, this.m_methodBlockSizes, null, 0);
                continue;
            }
            if ((method.getAccessFlags() & 0x500) != 0) {
                if (constructMetadata) {
                    this.m_classMethodDescriptors[m] = new MethodDescriptor(this.m_methodName, method.getDescriptor(cls), 2, this.m_methodBlockSizes, null, 0);
                }
                if (!trace2) continue;
                this.m_log.trace2("visit", "skipped " + (method.isAbstract() ? "abstract" : "native") + " method");
                continue;
            }
            this.m_methodFirstLine = 0;
            this.m_methodID = m;
            if (isClinit) {
                this.m_clinitID = m;
                if (!trace2) continue;
                this.m_log.trace2("visit", "<clinit> method delayed");
                continue;
            }
            IAttributeCollection attributes = method.getAttributes();
            int attributeCount = attributes.size();
            for (int a = 0; a < attributeCount; ++a) {
                Attribute_info attribute = attributes.get(a);
                attribute.accept(this, ctx);
            }
            if (!constructMetadata) continue;
            int[][] methodBlockMetadata = this.m_classBlockMetadata[this.m_methodID];
            int status = methodBlockMetadata == null ? 1 : 0;
            this.m_classMethodDescriptors[m] = new MethodDescriptor(this.m_methodName, method.getDescriptor(cls), status, this.m_methodBlockSizes, methodBlockMetadata, this.m_methodFirstLine);
        }
        boolean instrumentClinit = false;
        if (this.m_clinitID >= 0) {
            clinit2 = methods.get(this.m_clinitID);
            this.m_classInstrMethodCount = originalMethodCount;
        } else {
            this.m_clinitStatus = 8;
            int attribute_name_index = cls.addCONSTANT_Utf8("Code", true);
            name_index = cls.addCONSTANT_Utf8("<clinit>", true);
            int descriptor_index = cls.addCONSTANT_Utf8("()V", true);
            IAttributeCollection attributes = ElementFactory.newAttributeCollection(2);
            CodeAttribute_info code = new CodeAttribute_info(attribute_name_index, 0, 0, new byte[]{-79}, AttributeElementFactory.newExceptionHandlerTable(0), ElementFactory.newAttributeCollection(0));
            attributes.add(code);
            attributes.add(new SyntheticAttribute_info(this.m_syntheticStringIndex));
            clinit2 = new Method_info(10, name_index, descriptor_index, attributes);
            this.m_clinitID = cls.addMethod(clinit2);
            if (trace2) {
                this.m_log.trace2("visit", "added synthetic <clinit> method");
            }
            this.m_classInstrMethodCount = originalMethodCount + 1;
        }
        this.m_methodFirstLine = 0;
        this.m_methodID = this.m_clinitID;
        if (trace2) {
            this.m_log.trace2("visit", (clinit2.isSynthetic() ? "synthetic " : "") + "method #" + this.m_methodID + ": [<clinit>]");
        }
        IAttributeCollection attributes = clinit2.getAttributes();
        int attributeCount = attributes.size();
        for (int a = 0; a < attributeCount; ++a) {
            Attribute_info attribute = attributes.get(a);
            attribute.accept(this, ctx);
        }
        int attribute_name_index = cls.addCONSTANT_Utf8("Code", true);
        name_index = cls.addCONSTANT_Utf8(PRECLINIT_METHOD_NAME, false);
        int descriptor_index = cls.addCONSTANT_Utf8("()[[Z", false);
        IAttributeCollection attributes2 = ElementFactory.newAttributeCollection(2);
        ByteArrayOStream buf = new ByteArrayOStream(128);
        int[] blockCounts = this.m_classBlockCounts;
        int instrMethodCount = this.m_classInstrMethodCount;
        CodeGen.push_int_value(buf, cls, instrMethodCount);
        buf.write4(197, this.instument_two_dimensional_array_index >>> 8, this.instument_two_dimensional_array_index, 1);
        buf.write4(89, 179, this.m_coverageFieldrefIndex >>> 8, this.m_coverageFieldrefIndex);
        for (int m = 0; m < instrMethodCount; ++m) {
            int blockCount = blockCounts[m];
            if (blockCount <= 0) continue;
            buf.write(89);
            CodeGen.push_int_value(buf, cls, m);
            CodeGen.push_int_value(buf, cls, blockCount);
            buf.write3(188, 4, 83);
        }
        buf.write(89);
        CodeGen.push_constant_index(buf, this.m_classNameConstantIndex);
        buf.write3(20, this.m_stampIndex >>> 8, this.m_stampIndex);
        buf.write3(184, this.m_registerMethodrefIndex >>> 8, this.m_registerMethodrefIndex);
        buf.write(176);
        CodeAttribute_info code = new CodeAttribute_info(attribute_name_index, 5, 0, EMPTY_BYTE_ARRAY, AttributeElementFactory.newExceptionHandlerTable(0), ElementFactory.newAttributeCollection(0));
        code.setCode(buf.getByteArray(), buf.size());
        attributes2.add(code);
        attributes2.add(new SyntheticAttribute_info(this.m_syntheticStringIndex));
        Method_info preclinit = new Method_info(10, name_index, descriptor_index, attributes2);
        cls.addMethod(preclinit);
        if (trace2) {
            this.m_log.trace2("visit", "added synthetic pre-<clinit> method");
        }
        if (constructMetadata) {
            int[][] methodBlockMetadata = this.m_classBlockMetadata[this.m_methodID];
            this.m_clinitStatus |= methodBlockMetadata == null ? 1 : 0;
            if ((this.m_clinitStatus & 8) == 0) {
                this.m_classMethodDescriptors[this.m_methodID] = new MethodDescriptor("<clinit>", clinit2.getDescriptor(cls), this.m_clinitStatus, this.m_methodBlockSizes, methodBlockMetadata, this.m_methodFirstLine);
            }
        }
        return null;
    }

    public final Object visit(IAttributeCollection attributes, Object ctx) {
        int aCount = attributes.size();
        for (int a = 0; a < aCount; ++a) {
            attributes.get(a).accept(this, ctx);
        }
        return null;
    }

    public final Object visit(CodeAttribute_info attribute, Object ctx) {
        int newcodeCapacity;
        Block block;
        boolean trace2 = this.m_log.atTRACE2();
        boolean trace3 = this.m_log.atTRACE3();
        Method_info m = this.m_cls.getMethods().get(this.m_methodID);
        boolean isClinit = "<clinit>".equals(m.getName(this.m_cls));
        if (!isClinit && !attribute.getAttributes().hasStackMapTableAttribute() && this.supportJdk7()) {
            int attribute_name_index = this.m_cls.addCONSTANT_Utf8("StackMapTable", true);
            StackMapTableAttribute_info stackMapTable = new StackMapTableAttribute_info(attribute_name_index);
            attribute.getAttributes().add(stackMapTable);
        }
        byte[] code = attribute.getCode();
        int codeSize = this.m_methodOriginalCodeSize = attribute.getCodeSize();
        if (trace2) {
            this.m_log.trace2("visit", "code attribute for method #" + this.m_methodID + ": size = " + codeSize);
        }
        IntSet leaders = new IntSet();
        IntSet originalTargets = new IntSet();
        IntSet instrumentTargets = new IntSet();
        IntIntMap instructionMap = new IntIntMap();
        leaders.add(0);
        IExceptionHandlerTable exceptions = attribute.getExceptionTable();
        int exceptionCount = exceptions.size();
        for (int e = 0; e < exceptionCount; ++e) {
            Exception_info exception = exceptions.get(e);
            leaders.add(exception.m_handler_pc);
            originalTargets.add(exception.m_handler_pc);
        }
        IntObjectMap branches = new IntObjectMap();
        boolean branch = false;
        boolean wide = false;
        int instructionCount = 0;
        instructionMap.put(0, 0);
        int ip = 0;
        while (ip < codeSize) {
            int opcode = 0xFF & code[ip];
            int size = 0;
            if (branch) {
                leaders.add(ip);
                branch = false;
            }
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    int scan = ip + 1;
                    int ov = code[scan] << 8 | 0xFF & code[++scan];
                    int target = ip + ov;
                    leaders.add(target);
                    originalTargets.add(target);
                    branches.put(ip, new IFJUMP2(opcode, target));
                    branch = true;
                    break;
                }
                case 167: 
                case 168: {
                    int scan = ip + 1;
                    int ov = code[scan] << 8 | 0xFF & code[++scan];
                    int target = ip + ov;
                    leaders.add(target);
                    originalTargets.add(target);
                    branches.put(ip, new JUMP2(opcode, target));
                    branch = true;
                    break;
                }
                case 171: {
                    int iv;
                    int scan = ip + 4 - (ip & 3);
                    int ov = code[scan] << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                    leaders.add(ip + ov);
                    originalTargets.add(ip + ov);
                    int npairs = (0xFF & code[++scan]) << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                    int[] keys = new int[npairs];
                    int[] targets = new int[npairs + 1];
                    targets[0] = ip + ov;
                    for (int p = 0; p < npairs; ++p) {
                        keys[p] = iv = code[++scan] << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                        ov = code[++scan] << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                        targets[p + 1] = ip + ov;
                        leaders.add(ip + ov);
                        originalTargets.add(ip + ov);
                    }
                    branches.put(ip, new LOOKUPSWITCH(keys, targets));
                    branch = true;
                    size = ip - scan - 1;
                    break;
                }
                case 170: {
                    int scan = ip + 4 - (ip & 3);
                    int ov = code[scan] << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                    leaders.add(ip + ov);
                    originalTargets.add(ip + ov);
                    int low = code[++scan] << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                    int high = code[++scan] << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                    int[] targets = new int[high - low + 2];
                    targets[0] = ip + ov;
                    for (int index = low; index <= high; ++index) {
                        ov = code[++scan] << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                        targets[index - low + 1] = ip + ov;
                        leaders.add(ip + ov);
                        originalTargets.add(ip + ov);
                    }
                    branches.put(ip, new TABLESWITCH(low, high, targets));
                    branch = true;
                    size = ip - scan - 1;
                    break;
                }
                case 200: 
                case 201: {
                    int scan = ip + 1;
                    int ov = code[scan] << 24 | (0xFF & code[++scan]) << 16 | (0xFF & code[++scan]) << 8 | 0xFF & code[++scan];
                    int target = ip + ov;
                    leaders.add(target);
                    originalTargets.add(target);
                    branches.put(ip, new JUMP4(opcode, target));
                    branch = true;
                    break;
                }
                case 169: {
                    int scan = ip + 1;
                    int iv = wide ? (0xFF & code[scan]) << 8 | 0xFF & code[++scan] : 0xFF & code[scan];
                    branches.put(ip, new RET(opcode, iv));
                    branch = true;
                    break;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    branches.put(ip, new TERMINATE(opcode));
                    branch = true;
                }
            }
            size = size == 0 ? (wide ? IOpcodes.WIDE_SIZE : IOpcodes.NARROW_SIZE)[opcode] : -size;
            wide = opcode == 196;
            instructionMap.put(ip += size, ++instructionCount);
        }
        int blockCount = leaders.size();
        if (trace2) {
            this.m_log.trace2("visit", "method contains " + blockCount + " basic blocks");
        }
        BlockList blocks = new BlockList(blockCount);
        int[] _leaders = new int[blockCount + 1];
        leaders.values(_leaders, 0);
        _leaders[blockCount] = codeSize;
        Arrays.sort(_leaders);
        int targetSize = originalTargets.size();
        this.m_methodOriginalTargets = new int[targetSize];
        originalTargets.values(this.m_methodOriginalTargets, 0);
        Arrays.sort(this.m_methodOriginalTargets);
        int[] _branch_locations = branches.keys();
        Arrays.sort(_branch_locations);
        IntIntMap leaderToBlockID = new IntIntMap(_leaders.length);
        if (this.m_metadata) {
            this.m_methodBlockSizes = new int[blockCount];
            this.m_methodBlockOffsets = _leaders;
        }
        this.consumeSignatureData(this.m_methodID, _leaders);
        int[] intHolder = new int[1];
        int instr_count = 0;
        int br = 0;
        for (int bl = 0; bl < blockCount; ++bl) {
            int next_branch_location;
            int leader;
            block = new Block();
            blocks.m_blocks.add(block);
            block.m_first = leader = _leaders[bl];
            leaderToBlockID.put(leader, bl);
            int next_leader = _leaders[bl + 1];
            boolean branchDelimited = false;
            int prev_instr_count = instr_count;
            if (_branch_locations.length > br && (next_branch_location = _branch_locations[br]) < next_leader) {
                branchDelimited = true;
                block.m_length = next_branch_location - leader;
                instructionMap.get(next_branch_location, intHolder);
                instr_count = intHolder[0] + 1;
                block.m_branch = (Branch)branches.get(next_branch_location);
                block.m_branch.m_parentBlockID = bl;
                ++br;
            }
            if (!branchDelimited) {
                block.m_length = next_leader - leader;
                instructionMap.get(next_leader, intHolder);
                instr_count = intHolder[0];
            }
            block.m_instrCount = instr_count - prev_instr_count;
            if (!this.m_metadata) continue;
            this.m_methodBlockSizes[bl] = block.m_instrCount;
        }
        Block[] _blocks = blocks.m_blocks.toArray(new Block[blockCount]);
        for (int l = 0; l < blockCount; ++l) {
            int[] targets;
            block = _blocks[l];
            if (block.m_branch != null && (targets = block.m_branch.m_targets) != null) {
                int targetCount = targets.length;
                for (int t = 0; t < targetCount; ++t) {
                    leaderToBlockID.get(targets[t], intHolder);
                    targets[t] = intHolder[0];
                }
            }
            if (Arrays.binarySearch(this.m_methodOriginalTargets, block.m_first) < 0) continue;
            block.isTarget = true;
        }
        this.m_classBlockCounts[this.m_methodID] = blockCount;
        if (trace2) {
            this.m_log.trace2("visit", "instrumenting... ");
        }
        int localVarIndex = attribute.m_max_locals++;
        this.m_methodNewLocalSize = attribute.m_max_locals;
        if (this.m_methodID == this.m_clinitID) {
            this.m_stampIndex = this.m_cls.getConstants().add(new CONSTANT_Long_info(this.m_classSignature));
            blocks.m_header = new clinitHeader(this, localVarIndex);
        } else {
            blocks.m_header = new methodHeader(this, localVarIndex);
        }
        int headerMaxStack = blocks.m_header.maxstack();
        int methodMaxStack = 0;
        for (int l = 0; l < blockCount; ++l) {
            Block block2 = _blocks[l];
            BlockSegment insertion = new BlockSegment(this, localVarIndex, l);
            block2.m_insertion = insertion;
            int insertionMaxStack = ((CodeSegment)insertion).maxstack();
            if (insertionMaxStack <= methodMaxStack) continue;
            methodMaxStack = insertionMaxStack;
        }
        int oldMaxStack = attribute.m_max_stack;
        attribute.m_max_stack += methodMaxStack;
        if (headerMaxStack > attribute.m_max_stack) {
            attribute.m_max_stack = headerMaxStack;
        }
        if (trace3) {
            this.m_log.trace3("visit", "increasing maxstack by " + (attribute.m_max_stack - oldMaxStack));
        }
        if (trace2) {
            this.m_log.trace2("visit", "assembling... ");
        }
        if ((newcodeCapacity = codeSize << 1) < 64) {
            newcodeCapacity = 64;
        }
        ByteArrayOStream newcode = new ByteArrayOStream(newcodeCapacity);
        EmitCtx emitctx = new EmitCtx(blocks, newcode);
        int[] jumpAdjOffsets = new int[blockCount];
        int[] jumpAdjMap = new int[jumpAdjOffsets.length];
        blocks.m_header.emit(emitctx);
        jumpAdjMap[0] = emitctx.m_out.size();
        for (int l = 0; l < blockCount; ++l) {
            Block block3 = _blocks[l];
            if (l + 1 < blockCount) {
                jumpAdjOffsets[l + 1] = _blocks[l].m_first + _blocks[l].m_length;
            }
            block3.emit(emitctx, code);
            if (l + 1 >= blockCount) continue;
            jumpAdjMap[l + 1] = emitctx.m_out.size() - _blocks[l + 1].m_first;
        }
        this.m_methodJumpAdjOffsets = jumpAdjOffsets;
        this.m_methodJumpAdjValues = jumpAdjMap;
        if (trace3) {
            StringBuffer s = new StringBuffer("jump adjustment map:" + IConstants.EOL);
            for (int a = 0; a < jumpAdjOffsets.length; ++a) {
                s.append("    " + jumpAdjOffsets[a] + ": +" + jumpAdjMap[a]);
                if (a >= jumpAdjOffsets.length - 1) continue;
                s.append(IConstants.EOL);
            }
            this.m_log.trace3("visit", s.toString());
        }
        byte[] _newcode = newcode.getByteArray();
        int _newcodeSize = this.m_methodNewCodeSize = newcode.size();
        if (trace3) {
            this.m_log.trace3("visit", "backpatching " + emitctx.m_backpatchQueue.size() + " ip(s)");
        }
        Iterator i = emitctx.m_backpatchQueue.iterator();
        while (i.hasNext()) {
            int[] patchData = (int[])i.next();
            int ip2 = patchData[1];
            int jump = _blocks[patchData[3]].m_first - patchData[2];
            switch (patchData[0]) {
                case 4: {
                    _newcode[ip2++] = (byte)(jump >>> 24);
                    _newcode[ip2++] = (byte)(jump >>> 16);
                }
                case 2: {
                    _newcode[ip2++] = (byte)(jump >>> 8);
                    _newcode[ip2] = (byte)jump;
                }
            }
        }
        for (int l = 0; l < blockCount; ++l) {
            Block block4 = _blocks[l];
            if (!block4.isTarget) continue;
            instrumentTargets.add(block4.m_first);
        }
        this.m_methodInstrumentTargets = new int[instrumentTargets.size()];
        instrumentTargets.values(this.m_methodInstrumentTargets, 0);
        Arrays.sort(this.m_methodInstrumentTargets);
        attribute.setCode(_newcode, _newcodeSize);
        if (trace2) {
            this.m_log.trace2("visit", "method assembled into " + _newcodeSize + " code bytes");
        }
        IExceptionHandlerTable exceptionTable = attribute.getExceptionTable();
        for (int e = 0; e < exceptionTable.size(); ++e) {
            Exception_info exception = exceptionTable.get(e);
            int adjSegment = InstrVisitor.lowbound(jumpAdjOffsets, exception.m_start_pc);
            exception.m_start_pc += jumpAdjMap[adjSegment];
            adjSegment = InstrVisitor.lowbound(jumpAdjOffsets, exception.m_end_pc);
            exception.m_end_pc += jumpAdjMap[adjSegment];
            adjSegment = InstrVisitor.lowbound(jumpAdjOffsets, exception.m_handler_pc);
            exception.m_handler_pc += jumpAdjMap[adjSegment];
        }
        IAttributeCollection attributes = attribute.getAttributes();
        int attributeCount = attributes.size();
        for (int a = 0; a < attributeCount; ++a) {
            Attribute_info nested = attributes.get(a);
            nested.accept(this, ctx);
        }
        return null;
    }

    public final Object visit(StackMapTableAttribute_info attribute, Object ctx) {
        if (this.supportJdk7()) {
            ObjectVariable_info one_dimensional = new ObjectVariable_info(this.instument_one_dimensional_array_index);
            ObjectVariable_info two_dimensional = new ObjectVariable_info(this.instument_two_dimensional_array_index);
            boolean isClinit = "<clinit>".equals(this.m_methodName);
            LinkedList initialLocals = this.initMethodLocals();
            this.adjustFristVeificaionType(attribute.getFrames(), initialLocals);
            this.adjustFollowUpFrame(attribute.getFrames(), initialLocals);
            this.adjustFollowUpFullFrame(attribute.getFrames(), one_dimensional, this.m_methodNewLocalSize);
            this.adjustNonTargetFrame(attribute.getFrames());
            this.adjustStackMapTableOffsetDelta(attribute.getFrames(), two_dimensional, isClinit);
            this.adjustUninitializedVariableInfo(attribute.getFrames());
        }
        return null;
    }

    private boolean supportJdk7() {
        return this.m_jdk7Support && this.m_cls.isJDK7();
    }

    private void adjustFristVeificaionType(LinkedList m_frames, List initialLocals) {
        if (!CollectionUtils.isEmpty(m_frames)) {
            StackMapFrame_info firstFrame = (StackMapFrame_info)m_frames.removeFirst();
            m_frames.addFirst(StackMapFrameFactory.convertFirstVerificationType(firstFrame, initialLocals));
        }
    }

    private void adjustUninitializedVariableInfo(LinkedList m_frames) {
        for (int i = 0; i < m_frames.size(); ++i) {
            StackMapFrame_info frame = (StackMapFrame_info)m_frames.get(i);
            this.adjustUninitializedVariableInfoOffset(frame.getLocal());
            this.adjustUninitializedVariableInfoOffset(frame.getStack());
        }
    }

    private void adjustUninitializedVariableInfoOffset(List vTypes) {
        if (!CollectionUtils.isEmpty(vTypes)) {
            Iterator iterator = vTypes.iterator();
            while (iterator.hasNext()) {
                VerificationType_info vType_info = VerificationTypeFactory.downcastVerificationType((VerificationType_info)iterator.next());
                if (vType_info == null || !(vType_info instanceof UninitializedVariable_info)) continue;
                int oldOffset = ((UninitializedVariable_info)vType_info).getOffset();
                int newOffset = oldOffset + this.m_methodJumpAdjValues[InstrVisitor.lowbound(this.m_methodJumpAdjOffsets, oldOffset)];
                ((UninitializedVariable_info)vType_info).setOffset(newOffset);
            }
        }
    }

    private void adjustFollowUpFullFrame(LinkedList m_frames, ObjectVariable_info blockCheckLocal, int methodNewLocalSize) {
        if (!CollectionUtils.isEmpty(m_frames)) {
            for (int i = 0; i < m_frames.size(); ++i) {
                StackMapFrame_info frame = (StackMapFrame_info)m_frames.get(i);
                if (!(frame instanceof FullFrame)) continue;
                int size = frame.getLocal().size();
                int twoWordTypeSize = StackMapFrame_info.compute2WordTypeSize(frame.getLocal());
                for (int j = size; j < methodNewLocalSize - twoWordTypeSize - 1; ++j) {
                    frame.addLocal(new VerificationType_info(0));
                }
                frame.addLocal(blockCheckLocal);
            }
        }
    }

    private void adjustFollowUpFrame(LinkedList m_frames, List initialLocals) {
        if (!CollectionUtils.isEmpty(m_frames)) {
            LinkedList baseLocals = new LinkedList(initialLocals);
            for (int i = 0; i < m_frames.size(); ++i) {
                StackMapFrame_info frame = (StackMapFrame_info)m_frames.get(i);
                int offsetDelta = frame.getOffsetDelta();
                if (frame instanceof FullFrame) {
                    baseLocals.clear();
                    baseLocals.addAll(frame.getLocal());
                    continue;
                }
                if (frame instanceof AppendFrame) {
                    baseLocals.addAll(frame.getLocal());
                    m_frames.set(i, new FullFrame(offsetDelta, baseLocals, frame.getStack()));
                    continue;
                }
                if (frame instanceof ChopFrame) {
                    int absentLastCount = 251 - frame.getFrameType();
                    if (!CollectionUtils.isEmpty(baseLocals)) {
                        for (int j = 0; j < absentLastCount; ++j) {
                            baseLocals.removeLast();
                        }
                    }
                    m_frames.set(i, new FullFrame(offsetDelta, baseLocals, frame.getStack()));
                    continue;
                }
                m_frames.set(i, new FullFrame(offsetDelta, baseLocals, frame.getStack()));
            }
        }
    }

    private void adjustNonTargetFrame(LinkedList m_frames) {
        LinkedList temp = new LinkedList(m_frames);
        int oldInstructionSetFrameTarget = -1;
        int frame_count = temp.size();
        for (int i = 0; i < frame_count; ++i) {
            StackMapFrame_info frame = StackMapFrameFactory.downcastStackMapFrame((StackMapFrame_info)temp.get(i));
            if (Arrays.binarySearch(this.m_methodOriginalTargets, oldInstructionSetFrameTarget = oldInstructionSetFrameTarget == -1 ? frame.getOffsetDelta() : oldInstructionSetFrameTarget + frame.getOffsetDelta() + 1) >= 0) continue;
            m_frames.remove(i);
        }
    }

    private void adjustStackMapTableOffsetDelta(LinkedList m_frames, ObjectVariable_info two_dimensional, boolean isClinit) {
        int frame_count = m_frames.size();
        int prevNewInstructionOffset = -1;
        int currentNewInstructionOffset = -1;
        for (int i = 0; i < frame_count; ++i) {
            StackMapFrame_info frame = StackMapFrameFactory.downcastStackMapFrame((StackMapFrame_info)m_frames.get(i));
            if (!isClinit && prevNewInstructionOffset == -1) {
                prevNewInstructionOffset = 11;
            }
            currentNewInstructionOffset = this.m_methodInstrumentTargets[i];
            frame.setOffsetDelta(currentNewInstructionOffset - prevNewInstructionOffset - 1);
            m_frames.set(i, frame.changeFrameTypeByOffsetDelta());
            prevNewInstructionOffset = currentNewInstructionOffset;
        }
        if (!isClinit) {
            SameLocalFrame sameLocalFrame = new SameLocalFrame(11, two_dimensional);
            m_frames.addFirst(sameLocalFrame);
        }
    }

    private LinkedList initMethodLocals() {
        LinkedList<ObjectVariable_info> firstFrameLocals = new LinkedList<ObjectVariable_info>();
        Method_info methodInfo = this.m_cls.getMethods().get(this.m_methodID);
        String methodDescriptor = methodInfo.getDescriptor(this.m_cls);
        String className = this.m_cls.getName();
        if (!methodInfo.isStatic()) {
            firstFrameLocals.addLast(new ObjectVariable_info(this.m_cls.getConstants().findCONSTANT_Class(className)));
        }
        VerificationType_info.parseMethodDescriptor(firstFrameLocals, methodDescriptor, this.m_cls);
        return firstFrameLocals;
    }

    public final Object visit(LocalVariableTypeTableAttribute_info attribute, Object ctx) {
        if (this.supportJdk7()) {
            int localCount = attribute.size();
            for (int l = 0; l < localCount; ++l) {
                LocalVariableType_info local = attribute.get(l);
                local.m_length = this.computeLength(local.m_start_pc, local.m_length);
                local.m_start_pc = this.computeStartPC(local.m_start_pc);
            }
        }
        return null;
    }

    public final Object visit(LocalVariableTableAttribute_info attribute, Object ctx) {
        if (this.supportJdk7()) {
            int localCount = attribute.size();
            for (int l = 0; l < localCount; ++l) {
                LocalVariable_info local = attribute.get(l);
                local.m_length = this.computeLength(local.m_start_pc, local.m_length);
                local.m_start_pc = this.computeStartPC(local.m_start_pc);
            }
        }
        return null;
    }

    private int computeLength(int start_pc, int length) {
        int t_length = length;
        if (t_length + start_pc >= this.m_methodOriginalCodeSize) {
            t_length = this.m_methodNewCodeSize - this.computeStartPC(start_pc);
        } else {
            int endAdjSegment = InstrVisitor.lowbound(this.m_methodJumpAdjOffsets, start_pc + t_length);
            t_length = start_pc + t_length + this.m_methodJumpAdjValues[endAdjSegment] - this.computeStartPC(start_pc);
        }
        return t_length;
    }

    private int computeStartPC(int start_pc) {
        int result = start_pc;
        if (result != 0) {
            result += this.m_methodJumpAdjValues[InstrVisitor.lowbound(this.m_methodJumpAdjOffsets, result)];
        }
        return result;
    }

    public final Object visit(LineNumberTableAttribute_info attribute, Object ctx) {
        boolean trace2 = this.m_log.atTRACE2();
        boolean trace3 = this.m_log.atTRACE3();
        if (trace2) {
            this.m_log.trace2("visit", "attribute: [" + attribute.getName(this.m_cls) + "]");
        }
        int lineCount = attribute.size();
        if (this.m_metadata) {
            if (trace2) {
                this.m_log.trace2("visit", "processing line number table for metadata...");
            }
            int blockCount = this.m_classBlockCounts[this.m_methodID];
            int[][] blockLineMap = new int[blockCount][];
            if (lineCount == 0) {
                for (int bl = 0; bl < blockCount; ++bl) {
                    blockLineMap[bl] = IConstants.EMPTY_INT_ARRAY;
                }
            } else {
                LineNumber_info line;
                LineNumber_info[] sortedLines = new LineNumber_info[attribute.size()];
                for (int l = 0; l < lineCount; ++l) {
                    sortedLines[l] = line = attribute.get(l);
                }
                Arrays.sort(sortedLines, LINE_NUMBER_COMPARATOR);
                int[] methodBlockOffsets = this.m_methodBlockOffsets;
                line = sortedLines[0];
                LineNumber_info prev_line = null;
                this.m_methodFirstLine = line.m_line_number;
                int l = 0;
                for (int bl = 0; bl < blockCount; ++bl) {
                    IntSet blockLines = new IntSet();
                    if (prev_line != null && line.m_start_pc > methodBlockOffsets[bl]) {
                        blockLines.add(prev_line.m_line_number);
                    }
                    while (line.m_start_pc < methodBlockOffsets[bl + 1]) {
                        blockLines.add(line.m_line_number);
                        if (l == lineCount - 1) break;
                        prev_line = line;
                        line = sortedLines[++l];
                    }
                    blockLineMap[bl] = blockLines.values();
                }
            }
            this.m_classBlockMetadata[this.m_methodID] = blockLineMap;
            if (trace3) {
                StringBuffer s = new StringBuffer("block-line map for method #" + this.m_methodID + ":");
                for (int bl = 0; bl < blockCount; ++bl) {
                    s.append(IConstants.EOL);
                    s.append("    block " + bl + ": ");
                    int[] lines = blockLineMap[bl];
                    for (int l = 0; l < lines.length; ++l) {
                        if (l != 0) {
                            s.append(", ");
                        }
                        s.append(lines[l]);
                    }
                }
                this.m_log.trace3("visit", s.toString());
            }
        }
        for (int l = 0; l < lineCount; ++l) {
            LineNumber_info line = attribute.get(l);
            int adjSegment = InstrVisitor.lowbound(this.m_methodJumpAdjOffsets, line.m_start_pc);
            line.m_start_pc += this.m_methodJumpAdjValues[adjSegment];
        }
        return null;
    }

    public final Object visit(ExceptionsAttribute_info attribute, Object ctx) {
        return null;
    }

    public final Object visit(ConstantValueAttribute_info attribute, Object ctx) {
        return null;
    }

    public final Object visit(SourceFileAttribute_info attribute, Object ctx) {
        String value = attribute.getSourceFile((ClassDef)this.m_cls).m_value;
        if (value != null && value.length() > 0) {
            int lastSlash = value.lastIndexOf(92);
            if (lastSlash >= 0) {
                value = value.substring(lastSlash + 1);
            } else {
                lastSlash = value.lastIndexOf(47);
                if (lastSlash >= 0) {
                    value = value.substring(lastSlash + 1);
                }
            }
            this.m_classSrcFileName = value;
        }
        return null;
    }

    public final Object visit(SyntheticAttribute_info attribute, Object ctx) {
        return null;
    }

    public final Object visit(BridgeAttribute_info attribute, Object ctx) {
        return null;
    }

    public final Object visit(InnerClassesAttribute_info attribute, Object ctx) {
        return null;
    }

    public final Object visit(GenericAttribute_info attribute, Object ctx) {
        return null;
    }

    private void setClassName(String fullName) {
        int lastSlash = fullName.lastIndexOf(47);
        if (lastSlash < 0) {
            this.m_classPackageName = "";
            this.m_className = fullName;
        } else {
            this.m_classPackageName = fullName.substring(0, lastSlash);
            this.m_className = fullName.substring(lastSlash + 1);
        }
    }

    private void consumeSignatureData(int methodID, int[] basicBlockOffsets) {
        int temp1 = basicBlockOffsets.length;
        long temp2 = 16661L * this.m_classSignature + (long)((methodID + 1) * temp1);
        for (int i = 1; i < temp1; ++i) {
            temp2 = 16661L * temp2 + (long)basicBlockOffsets[i];
        }
        this.m_classSignature = temp2;
    }

    private static int lowbound(int[] values, int x) {
        int low = 0;
        int high = values.length - 1;
        while (low <= high) {
            int m = low + high >> 1;
            int v = values[m];
            if (v == x) {
                return m;
            }
            if (v < x) {
                low = m + 1;
                continue;
            }
            high = m - 1;
        }
        return high;
    }

    private void reset() {
        this.m_instrument = false;
        this.m_metadata = false;
        this.m_ignoreAlreadyInstrumented = false;
        this.m_cls = null;
        this.m_classPackageName = null;
        this.m_className = null;
        this.m_classSrcFileName = null;
        this.m_classBlockMetadata = null;
        this.m_classMethodDescriptors = null;
        this.m_syntheticStringIndex = -1;
        this.m_coverageFieldrefIndex = -1;
        this.m_registerMethodrefIndex = -1;
        this.m_preclinitMethodrefIndex = -1;
        this.m_classNameConstantIndex = -1;
        this.m_stampIndex = -1;
        this.m_clinitID = -1;
        this.m_clinitStatus = 0;
        this.m_classInstrMethodCount = -1;
        this.m_classBlockCounts = null;
        this.m_classSignature = 0L;
        this.instument_one_dimensional_array_index = -1;
        this.instument_two_dimensional_array_index = -1;
        this.m_methodID = -1;
        this.m_methodName = null;
        this.m_methodFirstLine = 0;
        this.m_methodNewLocalSize = -1;
        this.m_methodOriginalCodeSize = -1;
        this.m_methodNewCodeSize = -1;
        this.m_methodBlockOffsets = null;
        this.m_methodJumpAdjOffsets = null;
        this.m_methodJumpAdjValues = null;
        this.m_methodInstrumentTargets = null;
    }

    private static final class LineNumberComparator
    implements Comparator {
        private LineNumberComparator() {
        }

        public final int compare(Object o1, Object o2) {
            return ((LineNumber_info)o1).m_start_pc - ((LineNumber_info)o2).m_start_pc;
        }
    }

    static final class BlockSegment
    extends CodeSegment {
        private final ByteArrayOStream m_buf;
        private static final int BLOCK_INIT_CAPACITY = 16;

        public BlockSegment(InstrVisitor visitor, int localVarIndex, int blockID) {
            super(visitor);
            ByteArrayOStream buf;
            this.m_buf = buf = new ByteArrayOStream(16);
            ClassDef cls = visitor.m_cls;
            CodeGen.load_local_object_var(buf, localVarIndex);
            CodeGen.push_int_value(buf, cls, blockID);
            buf.write2(4, 84);
        }

        int length() {
            return this.m_buf.size();
        }

        int maxstack() {
            return 3;
        }

        void emit(EmitCtx ctx) {
            try {
                this.m_buf.writeTo(ctx.m_out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static final class methodHeader
    extends CodeSegment {
        private final ByteArrayOStream m_buf;
        private static final int HEADER_INIT_CAPACITY = 16;

        methodHeader(InstrVisitor visitor, int localVarIndex) {
            super(visitor);
            ByteArrayOStream buf;
            this.m_buf = buf = new ByteArrayOStream(16);
            ClassDef cls = visitor.m_cls;
            int coverageFieldrefIndex = visitor.m_coverageFieldrefIndex;
            int preclinitMethodrefIndex = visitor.m_preclinitMethodrefIndex;
            buf.write4(178, coverageFieldrefIndex >>> 8, coverageFieldrefIndex, 89);
            buf.write3(199, 0, 7);
            buf.write4(87, 184, preclinitMethodrefIndex >>> 8, preclinitMethodrefIndex);
            CodeGen.push_int_value(buf, cls, visitor.m_methodID);
            buf.write(50);
            CodeGen.store_local_object_var(buf, localVarIndex);
        }

        int length() {
            return this.m_buf.size();
        }

        int maxstack() {
            return 2;
        }

        void emit(EmitCtx ctx) {
            try {
                this.m_buf.writeTo(ctx.m_out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static final class clinitHeader
    extends CodeSegment {
        private final ByteArrayOStream m_buf;
        private static final int CLINIT_HEADER_INIT_CAPACITY = 32;

        clinitHeader(InstrVisitor visitor, int localVarIndex) {
            super(visitor);
            ByteArrayOStream buf;
            this.m_buf = buf = new ByteArrayOStream(32);
            ClassDef cls = visitor.m_cls;
            int[] blockCounts = visitor.m_classBlockCounts;
            int instrMethodCount = visitor.m_classInstrMethodCount;
            int coverageFieldrefIndex = visitor.m_coverageFieldrefIndex;
            int preclinitMethodrefIndex = visitor.m_preclinitMethodrefIndex;
            int classNameConstantIndex = visitor.m_classNameConstantIndex;
            buf.write3(184, preclinitMethodrefIndex >>> 8, preclinitMethodrefIndex);
            CodeGen.push_int_value(buf, cls, visitor.m_methodID);
            buf.write(50);
            CodeGen.store_local_object_var(buf, localVarIndex);
        }

        int length() {
            return this.m_buf.size();
        }

        int maxstack() {
            return 2;
        }

        void emit(EmitCtx ctx) {
            try {
                this.m_buf.writeTo(ctx.m_out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static abstract class CodeSegment {
        final InstrVisitor m_visitor;

        CodeSegment(InstrVisitor visitor) {
            this.m_visitor = visitor;
        }

        abstract int length();

        abstract int maxstack();

        abstract void emit(EmitCtx var1);
    }

    static final class TABLESWITCH
    extends Branch {
        final int m_low;
        final int m_high;

        TABLESWITCH(int low, int high, int[] targets) {
            super(170, targets);
            this.m_low = low;
            this.m_high = high;
        }

        int maxlength() {
            return 12 + (this.m_targets.length << 2);
        }

        void emit(EmitCtx ctx) {
            ByteArrayOStream out = ctx.m_out;
            int ip = out.size();
            out.write(this.m_opcode);
            int padCount = 3 - (ip & 3);
            for (int p = 0; p < padCount; ++p) {
                out.write(0);
            }
            this.emitJumpOffset4(ctx, ip, this.m_targets[0]);
            int low = this.m_low;
            out.write4(low >>> 24, low >>> 16, low >>> 8, low);
            int high = this.m_high;
            out.write4(high >>> 24, high >>> 16, high >>> 8, high);
            for (int t = 1; t < this.m_targets.length; ++t) {
                this.emitJumpOffset4(ctx, ip, this.m_targets[t]);
            }
        }
    }

    static final class LOOKUPSWITCH
    extends Branch {
        final int[] m_keys;

        LOOKUPSWITCH(int[] keys, int[] targets) {
            super(171, targets);
            this.m_keys = keys;
        }

        int maxlength() {
            return 12 + (this.m_keys.length << 3);
        }

        void emit(EmitCtx ctx) {
            ByteArrayOStream out = ctx.m_out;
            int ip = out.size();
            out.write(this.m_opcode);
            int padCount = 3 - (ip & 3);
            for (int p = 0; p < padCount; ++p) {
                out.write(0);
            }
            this.emitJumpOffset4(ctx, ip, this.m_targets[0]);
            int npairs = this.m_keys.length;
            out.write4(npairs >>> 24, npairs >>> 16, npairs >>> 8, npairs);
            for (int t = 1; t < this.m_targets.length; ++t) {
                int key = this.m_keys[t - 1];
                out.write4(key >>> 24, key >>> 16, key >>> 8, key);
                this.emitJumpOffset4(ctx, ip, this.m_targets[t]);
            }
        }
    }

    static final class IFJUMP2
    extends Branch {
        IFJUMP2(int opcode, int target) {
            super(opcode, new int[]{target});
        }

        int maxlength() {
            return 8;
        }

        void emit(EmitCtx ctx) {
            ByteArrayOStream out = ctx.m_out;
            int targetBlockID = this.m_targets[0];
            int ip = out.size();
            out.write(this.m_opcode);
            this.emitJumpOffset2(ctx, ip, targetBlockID);
        }
    }

    static final class JUMP4
    extends Branch {
        JUMP4(int opcode, int target) {
            super(opcode, new int[]{target});
        }

        int maxlength() {
            return 5;
        }

        void emit(EmitCtx ctx) {
            ByteArrayOStream out = ctx.m_out;
            int targetBlockID = this.m_targets[0];
            int ip = out.size();
            out.write(this.m_opcode);
            this.emitJumpOffset4(ctx, ip, targetBlockID);
        }
    }

    static final class JUMP2
    extends Branch {
        JUMP2(int opcode, int target) {
            super(opcode, new int[]{target});
        }

        int maxlength() {
            return 5;
        }

        void emit(EmitCtx ctx) {
            ByteArrayOStream out = ctx.m_out;
            int targetBlockID = this.m_targets[0];
            int ip = out.size();
            out.write(this.m_opcode);
            this.emitJumpOffset2(ctx, ip, targetBlockID);
        }
    }

    static final class RET
    extends Branch {
        final int m_varindex;

        RET(int opcode, int varindex) {
            super(opcode, null);
            this.m_varindex = varindex;
        }

        int length() {
            return this.m_varindex <= 255 ? 2 : 3;
        }

        void emit(EmitCtx ctx) {
            ByteArrayOStream out = ctx.m_out;
            if (this.m_varindex <= 255) {
                out.write2(this.m_opcode, this.m_varindex);
            } else {
                out.write4(196, this.m_opcode, this.m_varindex >>> 8, this.m_varindex);
            }
        }
    }

    static final class TERMINATE
    extends Branch {
        TERMINATE(int opcode) {
            super(opcode, null);
        }

        int length() {
            return 1;
        }

        void emit(EmitCtx ctx) {
            ctx.m_out.write(this.m_opcode);
        }
    }

    static abstract class Branch {
        final byte m_opcode;
        final int[] m_targets;
        int m_parentBlockID;

        protected Branch(int opcode, int[] targets) {
            this.m_opcode = (byte)opcode;
            this.m_targets = targets;
        }

        int maxlength() {
            return 1;
        }

        abstract void emit(EmitCtx var1);

        protected final void emitJumpOffset2(EmitCtx ctx, int ip, int targetBlockID) {
            ByteArrayOStream out = ctx.m_out;
            if (targetBlockID <= this.m_parentBlockID) {
                int jumpOffset = ((Block)ctx.m_blocks.m_blocks.get((int)targetBlockID)).m_first - ip;
                out.write2(jumpOffset >>> 8, jumpOffset);
            } else {
                int jumpOffsetLocation = out.size();
                out.write2(0, 0);
                ctx.m_backpatchQueue.add(new int[]{2, jumpOffsetLocation, ip, targetBlockID});
            }
        }

        protected final void emitJumpOffset4(EmitCtx ctx, int ip, int targetBlockID) {
            ByteArrayOStream out = ctx.m_out;
            if (targetBlockID <= this.m_parentBlockID) {
                int jumpOffset = ((Block)ctx.m_blocks.m_blocks.get((int)targetBlockID)).m_first - ip;
                out.write4(jumpOffset >>> 24, jumpOffset >>> 16, jumpOffset >>> 8, jumpOffset);
            } else {
                int jumpOffsetLocation = out.size();
                out.write4(0, 0, 0, 0);
                ctx.m_backpatchQueue.add(new int[]{4, jumpOffsetLocation, ip, targetBlockID});
            }
        }
    }

    static final class EmitCtx {
        final BlockList m_blocks;
        final ByteArrayOStream m_out;
        final List m_backpatchQueue;

        EmitCtx(BlockList blocks, ByteArrayOStream out) {
            this.m_blocks = blocks;
            this.m_out = out;
            this.m_backpatchQueue = new ArrayList();
        }
    }

    private static final class Block {
        int m_first;
        int m_length;
        int m_instrCount;
        boolean isTarget;
        public CodeSegment m_insertion;
        public Branch m_branch;

        private Block() {
        }

        void emit(EmitCtx ctx, byte[] code) {
            ByteArrayOStream out = ctx.m_out;
            int first = this.m_first;
            this.m_first = out.size();
            int length = this.m_length;
            for (int i = 0; i < length; ++i) {
                out.write(code[first + i]);
            }
            if (this.m_insertion != null) {
                this.m_insertion.emit(ctx);
            }
            if (this.m_branch != null) {
                this.m_branch.emit(ctx);
            }
        }
    }

    private static final class BlockList {
        final List m_blocks;
        CodeSegment m_header;

        BlockList() {
            this.m_blocks = new ArrayList();
        }

        BlockList(int capacity) {
            this.m_blocks = new ArrayList(capacity);
        }
    }

    public static final class InstrResult {
        public boolean m_instrumented;
        public ClassDescriptor m_descriptor;
    }
}

