/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.Command;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.instr.InstrProcessor;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.args.IOptsParser;
import com.vladium.util.asserts.$assert;
import java.io.IOException;

public final class instrCommand
extends Command {
    private String[] m_instrpath;
    private String[] m_ixpath;
    private String m_outDirName;
    private String m_outFileName;
    private Boolean m_outDataMerge;
    private InstrProcessor.OutMode m_outMode = InstrProcessor.OutMode.OUT_MODE_COPY;

    public instrCommand(String usageToolName, String[] args) {
        super(usageToolName, args);
    }

    public synchronized void run() {
        ClassLoader loader;
        try {
            loader = ClassLoaderResolver.getClassLoader();
        }
        catch (Throwable t) {
            loader = this.getClass().getClassLoader();
        }
        try {
            IOptsParser parser = this.getOptParser(loader);
            IOptsParser.IOpts parsedopts = parser.parse(this.m_args);
            int usageRequestLevel = parsedopts.usageRequestLevel();
            if (usageRequestLevel > 0) {
                this.usageexit(null, parser, usageRequestLevel);
                return;
            }
            IOptsParser.IOpt[] opts = parsedopts.getOpts();
            if (opts == null) {
                parsedopts.error(this.m_out, 80);
                this.usageexit(null, parser, 1);
                return;
            }
            if (parsedopts.hasArg("v")) {
                this.usageexit(null, null, usageRequestLevel);
                return;
            }
            try {
                for (int o = 0; o < opts.length; ++o) {
                    IOptsParser.IOpt opt = opts[o];
                    String on = opt.getCanonicalName();
                    if (this.processOpt(opt)) continue;
                    if ("ip".equals(on)) {
                        this.m_instrpath = instrCommand.getListOptValue(opt, PATH_DELIMITERS, true);
                        continue;
                    }
                    if ("d".equals(on)) {
                        this.m_outDirName = opt.getFirstValue();
                        continue;
                    }
                    if ("out".equals(on)) {
                        this.m_outFileName = opt.getFirstValue();
                        continue;
                    }
                    if ("merge".equals(on)) {
                        this.m_outDataMerge = instrCommand.getOptionalBooleanOptValue(opt) ? Boolean.TRUE : Boolean.FALSE;
                        continue;
                    }
                    if ("ix".equals(on)) {
                        this.m_ixpath = instrCommand.getListOptValue(opt, ", \t\r\n", true);
                        continue;
                    }
                    if (!"m".equals(on)) continue;
                    String ov = opt.getFirstValue();
                    InstrProcessor.OutMode outMode = InstrProcessor.OutMode.nameToMode(ov);
                    if (outMode == null) {
                        this.usageexit("invalid '" + opts[o].getName() + "' option value: " + ov, parser, 1);
                        return;
                    }
                    this.m_outMode = outMode;
                }
                this.processCmdPropertyOverrides(parsedopts);
                if (!this.processFilePropertyOverrides()) {
                    return;
                }
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("ARGS_IO_FAILURE", ioe);
            }
            if (this.m_outMode != InstrProcessor.OutMode.OUT_MODE_OVERWRITE && this.m_outDirName == null) {
                this.usageexit("output directory must be specified for '" + this.m_outMode + "' output mode", parser, 1);
                return;
            }
            InstrProcessor processor = InstrProcessor.create();
            processor.setAppName("EMMA");
            processor.setInstrPath(this.m_instrpath, true);
            processor.setInclExclFilter(this.m_ixpath);
            $assert.ASSERT(this.m_outMode != null, "m_outMode not set");
            processor.setOutMode(this.m_outMode);
            processor.setInstrOutDir(this.m_outDirName);
            processor.setMetaOutFile(this.m_outFileName);
            processor.setMetaOutMerge(this.m_outDataMerge);
            processor.setPropertyOverrides(this.m_propertyOverrides);
            processor.run();
        }
        catch (EMMARuntimeException yre) {
            this.exit(true, yre.getMessage(), yre, 2);
            return;
        }
        catch (Throwable t) {
            this.exit(true, "unexpected failure: ", t, 2);
            return;
        }
        this.exit(false, null, null, 0);
    }

    protected String usageArgsMsg() {
        return "[options]";
    }
}

