/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Files;
import com.vladium.util.IProperties;
import com.vladium.util.IntIntMap;
import com.vladium.util.IntVector;
import com.vladium.util.ObjectIntMap;
import com.vladium.util.Property;
import java.io.File;
import java.util.HashSet;
import java.util.StringTokenizer;

public abstract class ReportProperties
implements IAppErrorCodes {
    public static final IProperties.IMapper REPORT_PROPERTY_MAPPER = new ReportPropertyMapper();
    private static final boolean REMOVE_DUPLICATE_COLUMNS = true;
    private static final ObjectIntMap COLUMNS;

    public static ParsedProperties parseProperties(IProperties properties, String type) {
        String columnName;
        String depth;
        ParsedProperties result = new ParsedProperties();
        result.setOutEncoding(ReportProperties.getReportProperty(properties, type, "out.encoding", false, false));
        String outDirName = ReportProperties.getReportProperty(properties, type, "out.dir", true, false);
        String outFileName = ReportProperties.getReportProperty(properties, type, "out.file", false, false);
        if (outFileName != null) {
            File fullOutFile = Files.newFile(outDirName, outFileName);
            File dir = fullOutFile.getParentFile();
            if (dir != null) {
                result.setOutDir(dir);
            }
            result.setOutFile(new File(fullOutFile.getName()));
        } else if (outDirName != null) {
            result.setOutDir(new File(outDirName));
        }
        String unitsType = ReportProperties.getReportProperty(properties, type, "units", true, true, "instr");
        result.setUnitsType("count".equals(unitsType) ? 0 : 1);
        result.setViewType(1);
        String hideClasses = ReportProperties.getReportProperty(properties, type, "hideclasses", true, true, "true");
        result.setHideClasses(Property.toBoolean(hideClasses));
        if (result.getViewType() == 0) {
            result.setHideClasses(false);
        }
        if ("all".equals(depth = ReportProperties.getReportProperty(properties, type, "depth", false, true, "package"))) {
            result.setDepth(AllItem.getTypeMetadata().getTypeID());
        } else if ("package".equals(depth)) {
            result.setDepth(PackageItem.getTypeMetadata().getTypeID());
        } else if ("source".equals(depth)) {
            result.setDepth(SrcFileItem.getTypeMetadata().getTypeID());
        } else if ("class".equals(depth)) {
            result.setDepth(ClassItem.getTypeMetadata().getTypeID());
        } else if ("method".equals(depth)) {
            result.setDepth(MethodItem.getTypeMetadata().getTypeID());
        } else {
            throw new EMMARuntimeException("INVALID_PARAMETER_VALUE", new Object[]{"depth", depth});
        }
        if (result.getHideClasses() && result.getViewType() == 1 && result.getDepth() == 3) {
            result.setDepth(2);
        }
        HashSet<String> columnNames = new HashSet<String>();
        String columnList = ReportProperties.getReportProperty(properties, type, "columns", false, true, "class,method,block,line,name");
        IntVector _columns = new IntVector();
        int[] out = new int[1];
        StringTokenizer tokenizer = new StringTokenizer(columnList, ",");
        while (tokenizer.hasMoreTokens()) {
            String columnName2 = tokenizer.nextToken().trim();
            if (!COLUMNS.get(columnName2, out)) {
                throw new EMMARuntimeException("INVALID_COLUMN_NAME", new Object[]{columnName2});
            }
            if (columnNames.contains(columnName2)) continue;
            columnNames.add(columnName2);
            _columns.add(out[0]);
        }
        result.setColumnOrder(_columns.values());
        String sortList = ReportProperties.getReportProperty(properties, type, "sort", false, true, "+block,+name");
        IntVector _sort = new IntVector();
        out = new int[1];
        tokenizer = new StringTokenizer(sortList, ",");
        while (tokenizer.hasMoreTokens()) {
            int dir;
            String sortSpec = tokenizer.nextToken().trim();
            switch (sortSpec.charAt(0)) {
                case '+': {
                    dir = 1;
                    columnName = sortSpec.substring(1);
                    break;
                }
                case '-': {
                    dir = -1;
                    columnName = sortSpec.substring(1);
                    break;
                }
                default: {
                    dir = 1;
                    columnName = sortSpec;
                }
            }
            if (columnNames.contains(columnName)) {
                COLUMNS.get(columnName, out);
                _sort.add(out[0]);
                _sort.add(dir);
            }
            result.setSortOrder(_sort.values());
        }
        String metricList = ReportProperties.getReportProperty(properties, type, "metrics", true, true, "method:70,block:80,line:80,class:100");
        IntIntMap _metrics = new IntIntMap();
        out = new int[1];
        tokenizer = new StringTokenizer(metricList, ",");
        while (tokenizer.hasMoreTokens()) {
            double criterion;
            int separator;
            String metricSpec;
            block28: {
                metricSpec = tokenizer.nextToken().trim();
                separator = metricSpec.indexOf(58);
                if (separator <= 0) continue;
                try {
                    criterion = Double.parseDouble(metricSpec.substring(separator + 1));
                    if (criterion < 0.0) continue;
                    if (criterion > 101.0) {
                    }
                    break block28;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace(System.out);
                }
                continue;
            }
            columnName = metricSpec.substring(0, separator);
            if (!columnNames.contains(columnName)) continue;
            COLUMNS.get(columnName, out);
            _metrics.put(out[0], (int)Math.round(criterion * 100.0 / 100.0));
        }
        result.setMetrics(_metrics);
        result.validate();
        return result;
    }

    private ReportProperties() {
    }

    private static String getReportProperty(IProperties properties, String type, String key, boolean allowBlank, boolean trim) {
        return ReportProperties.getReportProperty(properties, type, key, allowBlank, trim, null);
    }

    private static String getReportProperty(IProperties properties, String type, String key, boolean allowBlank, boolean trim, String dflt) {
        String result = properties.getProperty("report.".concat(type).concat(".").concat(key), dflt);
        if (!allowBlank && result != null && result.trim().length() == 0) {
            return dflt;
        }
        if (trim && result != null) {
            result = result.trim();
        }
        return result;
    }

    static {
        ObjectIntMap columns = new ObjectIntMap();
        columns.put("name", 0);
        columns.put("class", 1);
        columns.put("method", 2);
        columns.put("block", 3);
        columns.put("line", 4);
        COLUMNS = columns;
    }

    private static final class ReportPropertyMapper
    implements IProperties.IMapper {
        private ReportPropertyMapper() {
        }

        public String getMappedKey(String key) {
            int secondDot;
            if (key != null && key.startsWith("report.") && (secondDot = key.indexOf(46, "report.".length())) > 0) {
                return "report.".concat(key.substring(secondDot + 1));
            }
            return null;
        }
    }

    public static final class ParsedProperties {
        private String m_outEncoding;
        private File m_outDir;
        private File m_outFile;
        private int m_unitsType;
        private int m_viewType;
        private boolean m_hideClasses;
        private int m_depth;
        private int[] m_columnOrder;
        private int[] m_sortOrder;
        private IntIntMap m_metrics;

        public void setOutEncoding(String outEncoding) {
            this.m_outEncoding = outEncoding;
        }

        public String getOutEncoding() {
            return this.m_outEncoding;
        }

        public void setOutDir(File outDir) {
            this.m_outDir = outDir;
        }

        public File getOutDir() {
            return this.m_outDir;
        }

        public void setOutFile(File outFile) {
            this.m_outFile = outFile;
        }

        public File getOutFile() {
            return this.m_outFile;
        }

        public void setUnitsType(int unitsType) {
            this.m_unitsType = unitsType;
        }

        public int getUnitsType() {
            return this.m_unitsType;
        }

        public void setViewType(int viewType) {
            this.m_viewType = viewType;
        }

        public int getViewType() {
            return this.m_viewType;
        }

        public void setDepth(int depth) {
            this.m_depth = depth;
        }

        public int getDepth() {
            return this.m_depth;
        }

        public void setHideClasses(boolean hideClasses) {
            this.m_hideClasses = hideClasses;
        }

        public boolean getHideClasses() {
            return this.m_hideClasses;
        }

        public void setColumnOrder(int[] columnOrder) {
            this.m_columnOrder = columnOrder;
        }

        public int[] getColumnOrder() {
            return this.m_columnOrder;
        }

        public void setSortOrder(int[] sortOrder) {
            this.m_sortOrder = sortOrder;
        }

        public int[] getSortOrder() {
            return this.m_sortOrder;
        }

        public void setMetrics(IntIntMap metrics) {
            this.m_metrics = metrics;
        }

        public IntIntMap getMetrics() {
            return this.m_metrics;
        }

        void validate() throws IllegalArgumentException {
        }
    }
}

