/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.LocalVariableType_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class LocalVariableTypeTableAttribute_info
extends Attribute_info {
    private List m_locals;

    public LocalVariableType_info get(int offset) {
        return (LocalVariableType_info)this.m_locals.get(offset);
    }

    public int size() {
        return this.m_locals.size();
    }

    public long length() {
        return 8 + this.m_locals.size() * 10;
    }

    public void accept(IAttributeVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("LocalVariableTypeTableAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.length() + "]\n");
        for (int l = 0; l < this.size(); ++l) {
            s.append("            " + this.get(l));
            s.append("\n");
        }
        return s.toString();
    }

    public Object clone() {
        LocalVariableTypeTableAttribute_info _clone = (LocalVariableTypeTableAttribute_info)super.clone();
        int locals_count = this.m_locals.size();
        _clone.m_locals = new ArrayList(locals_count);
        for (int e = 0; e < locals_count; ++e) {
            _clone.m_locals.add(((LocalVariableType_info)this.m_locals.get(e)).clone());
        }
        return _clone;
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        super.writeInClassFormat(out);
        int locals_count = this.m_locals.size();
        out.writeU2(locals_count);
        for (int l = 0; l < locals_count; ++l) {
            ((LocalVariableType_info)this.m_locals.get(l)).writeInClassFormat(out);
        }
    }

    LocalVariableTypeTableAttribute_info(int attribute_name_index, long attribute_length, UDataInputStream bytes) throws IOException {
        super(attribute_name_index, attribute_length);
        int locals_count = bytes.readU2();
        this.m_locals = new ArrayList(locals_count);
        for (int i = 0; i < locals_count; ++i) {
            this.m_locals.add(new LocalVariableType_info(bytes));
        }
    }
}

