/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IFileLock;
import java.util.Random;

abstract class AbstractFileLock
implements IFileLock {
    protected final long m_timeout;
    protected final int m_retries;

    public abstract String toString();

    public final synchronized void acquire() throws IFileLock.FileLockException, InterruptedException {
        try {
            this.tryAcquire();
            return;
        }
        catch (IFileLock.FileLockException fle) {
            String errorCode = fle.getErrorCode();
            if ("LOCK_ACQUISITION_SECURITY_FAILURE".equals(errorCode) || "LOCK_ACQUIRED_ALREADY".equals(errorCode)) {
                throw fle;
            }
            if (this.m_timeout < 1L || this.m_retries < 1) {
                throw fle;
            }
            double D = Math.pow(2.0, this.m_retries) - 1.0;
            long end = System.currentTimeMillis() + this.m_timeout;
            Random rand = new Random(end + (long)this.hashCode());
            for (int r = 0; r < this.m_retries; ++r) {
                long delay = Math.max(1L, (long)((double)this.m_timeout * Math.pow(2.0, r) / D) + (long)rand.nextInt(10) - 5L);
                Thread.sleep(delay);
                try {
                    this.tryAcquire();
                    return;
                }
                catch (IFileLock.FileLockException fle2) {
                    String errorCode2 = fle2.getErrorCode();
                    if ("LOCK_ACQUISITION_SECURITY_FAILURE".equals(errorCode2) || "LOCK_ACQUIRED_ALREADY".equals(errorCode2)) {
                        throw fle;
                    }
                    if (System.currentTimeMillis() >= end) break;
                    continue;
                }
            }
            throw new IFileLock.FileLockException("LOCK_ACQUISITION_TIMEOUT");
        }
    }

    protected AbstractFileLock(long timeout, int retries) {
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    protected abstract void tryAcquire() throws IFileLock.FileLockException;

    protected final void finalize() {
        this.release();
    }
}

