/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

public final class IntIntMap {
    private final float m_loadFactor;
    private Entry[] m_buckets;
    private int m_size;
    private int m_sizeThreshold;
    private static final String EOL = System.getProperty("line.separator", "\n");

    public IntIntMap() {
        this(11, 0.75f);
    }

    public IntIntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntIntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("negative input: initialCapacity [" + initialCapacity + "]");
        }
        if ((double)loadFactor <= 0.0 || (double)loadFactor >= 1.000001) {
            throw new IllegalArgumentException("loadFactor not in (0.0, 1.0] range: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.m_loadFactor = (double)loadFactor > 1.0 ? 1.0f : loadFactor;
        this.m_sizeThreshold = (int)((float)initialCapacity * loadFactor);
        this.m_buckets = new Entry[initialCapacity];
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        this.debugDump(s);
        return s.toString();
    }

    public int size() {
        return this.m_size;
    }

    public boolean contains(int key) {
        Entry[] buckets = this.m_buckets;
        int bucketIndex = (key & Integer.MAX_VALUE) % buckets.length;
        Entry entry = buckets[bucketIndex];
        while (entry != null) {
            if (key == entry.m_key) {
                return true;
            }
            entry = entry.m_next;
        }
        return false;
    }

    public boolean get(int key, int[] out) {
        Entry[] buckets = this.m_buckets;
        int bucketIndex = (key & Integer.MAX_VALUE) % buckets.length;
        Entry entry = buckets[bucketIndex];
        while (entry != null) {
            if (key == entry.m_key) {
                out[0] = entry.m_value;
                return true;
            }
            entry = entry.m_next;
        }
        return false;
    }

    public boolean get(int key, int[] out, int index) {
        Entry[] buckets = this.m_buckets;
        int bucketIndex = (key & Integer.MAX_VALUE) % buckets.length;
        Entry entry = buckets[bucketIndex];
        while (entry != null) {
            if (key == entry.m_key) {
                out[index] = entry.m_value;
                return true;
            }
            entry = entry.m_next;
        }
        return false;
    }

    public int[] keys() {
        int[] result = new int[this.m_size];
        int scan = 0;
        for (int b = 0; b < this.m_buckets.length; ++b) {
            Entry entry = this.m_buckets[b];
            while (entry != null) {
                result[scan++] = entry.m_key;
                entry = entry.m_next;
            }
        }
        return result;
    }

    public void put(int key, int value) {
        Entry currentKeyEntry = null;
        int bucketIndex = (key & Integer.MAX_VALUE) % this.m_buckets.length;
        Entry[] buckets = this.m_buckets;
        Entry entry = buckets[bucketIndex];
        while (entry != null) {
            if (key == entry.m_key) {
                currentKeyEntry = entry;
                break;
            }
            entry = entry.m_next;
        }
        if (currentKeyEntry != null) {
            currentKeyEntry.m_value = value;
        } else {
            Entry newEntry;
            if (this.m_size >= this.m_sizeThreshold) {
                this.rehash();
            }
            buckets = this.m_buckets;
            bucketIndex = (key & Integer.MAX_VALUE) % buckets.length;
            Entry bucketListHead = buckets[bucketIndex];
            buckets[bucketIndex] = newEntry = new Entry(key, value, bucketListHead);
            ++this.m_size;
        }
    }

    public void remove(int key) {
        Entry entry;
        int bucketIndex = (key & Integer.MAX_VALUE) % this.m_buckets.length;
        Entry[] buckets = this.m_buckets;
        Entry prev = entry = buckets[bucketIndex];
        while (entry != null) {
            Entry next = entry.m_next;
            if (key == entry.m_key) {
                if (prev == entry) {
                    buckets[bucketIndex] = next;
                } else {
                    prev.m_next = next;
                }
                --this.m_size;
                break;
            }
            prev = entry;
            entry = next;
        }
    }

    void debugDump(StringBuffer out) {
        if (out != null) {
            out.append(super.toString());
            out.append(EOL);
            out.append("size = " + this.m_size + ", bucket table size = " + this.m_buckets.length + ", load factor = " + this.m_loadFactor + EOL);
            out.append("size threshold = " + this.m_sizeThreshold + EOL);
        }
    }

    private void rehash() {
        Entry[] buckets = this.m_buckets;
        int newBucketCount = (this.m_buckets.length << 1) + 1;
        Entry[] newBuckets = new Entry[newBucketCount];
        for (int b = 0; b < buckets.length; ++b) {
            Entry entry = buckets[b];
            while (entry != null) {
                Entry bucketListHead;
                Entry next = entry.m_next;
                int entryKeyHash = entry.m_key & Integer.MAX_VALUE;
                int newBucketIndex = entryKeyHash % newBucketCount;
                entry.m_next = bucketListHead = newBuckets[newBucketIndex];
                newBuckets[newBucketIndex] = entry;
                entry = next;
            }
        }
        this.m_sizeThreshold = (int)((float)newBucketCount * this.m_loadFactor);
        this.m_buckets = newBuckets;
    }

    private static final class Entry {
        int m_key;
        int m_value;
        Entry m_next;

        Entry(int key, int value, Entry next) {
            this.m_key = key;
            this.m_value = value;
            this.m_next = next;
        }
    }
}

