/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.attr;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.desktop.attr.Attributes;
import com.mathworks.util.Disposable;
import com.mathworks.util.event.EventListenerList;
import com.mathworks.util.logger.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DefaultAttributes
implements Attributes {
    private static final Log LOG = Log.getInstance((String)"com.mathworks.desktop.attr");
    private Map<Attribute, Object> fProperties;
    private EventListenerList<AttributeChangeListener> fListeners;
    private final Object fOwner;
    private static final Attribute[] EMPTY_ATTR_ARRAY = new Attribute[0];
    private static final String ATTRIBUTE = "attribute";
    private static final boolean DEBUG_PRINT_EVENTS = false;

    public DefaultAttributes() {
        this(null);
    }

    public DefaultAttributes(Object object) {
        this.fOwner = object;
    }

    @Override
    @NotNull
    public Attribute[] getAttributes() {
        if (this.fProperties != null) {
            Set<Attribute> set = this.fProperties.keySet();
            return set.toArray(new Attribute[set.size()]);
        }
        return EMPTY_ATTR_ARRAY;
    }

    @Override
    public <T> T setAttribute(Attribute<T> attribute, T t) {
        Preconditions.checkArgument((attribute.isMutable() || this.fProperties == null || !this.fProperties.containsKey(attribute) ? 1 : 0) != 0, (String)"Attribute %s cannot be changed once set", (Object[])new Object[]{attribute.getName()});
        Object object = null;
        T t2 = attribute.getDefault();
        if (t == null) {
            if (!(this.fProperties == null || (object = this.fProperties.remove(attribute)) == null || t2 != null && t2.equals(object))) {
                this.fireAttributeChangeEvent(attribute, object, t2);
            }
        } else {
            if (this.fProperties == null) {
                this.fProperties = new HashMap<Attribute, Object>(10);
            }
            if (!((object = this.fProperties.put(attribute, t)) == null && t2 != null && t2.equals(t) || Objects.equal((Object)object, t))) {
                this.fireAttributeChangeEvent(attribute, object, t);
            }
        }
        return (T)object;
    }

    @Override
    public <T> T getAttribute(Attribute<T> attribute) {
        Object object = this.fProperties == null ? null : this.fProperties.get(attribute);
        return (T)(object == null ? attribute.getDefault() : object);
    }

    @Override
    public void addAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        if (this.fListeners == null) {
            this.fListeners = EventListenerList.newEventListenerList(AttributeChangeListener.class);
        }
        this.fListeners.addListener((Object)attributeChangeListener);
    }

    @Override
    public void addAttributeChangeListener(AttributeChangeListener attributeChangeListener, Disposable disposable) {
        if (this.fListeners == null) {
            this.fListeners = EventListenerList.newEventListenerList(AttributeChangeListener.class);
        }
        this.fListeners.addListener((Object)attributeChangeListener, disposable);
    }

    @Override
    public void addAttributeChangeListenerWeakly(AttributeChangeListener attributeChangeListener) {
        if (this.fListeners == null) {
            this.fListeners = EventListenerList.newEventListenerList(AttributeChangeListener.class);
        }
        this.fListeners.addWeakListener((Object)attributeChangeListener);
    }

    @Override
    public void addAttributeChangeListenerWeakly(AttributeChangeListener attributeChangeListener, Disposable disposable) {
        if (this.fListeners == null) {
            this.fListeners = EventListenerList.newEventListenerList(AttributeChangeListener.class);
        }
        this.fListeners.addWeakListener((Object)attributeChangeListener, disposable);
    }

    @Override
    public void removeAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        if (this.fListeners != null) {
            this.fListeners.removeListener((Object)attributeChangeListener);
        }
    }

    public boolean isTrue(Attribute<Boolean> attribute) {
        Boolean bl = this.getAttribute(attribute);
        return bl != null && bl != false;
    }

    public static Map<String, Attribute> collectAttributes(Class clazz) {
        HashMap<String, Attribute> hashMap = new HashMap<String, Attribute>();
        for (Field field : clazz.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object object = field.get(clazz);
                if (!(object instanceof Attribute)) continue;
                Attribute attribute = (Attribute)object;
                hashMap.put(attribute.getName(), attribute);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOG.warn((Throwable)illegalAccessException);
            }
        }
        return hashMap;
    }

    private void fireAttributeChangeEvent(Attribute attribute, Object object, Object object2) {
        if (this.fListeners != null) {
            ((AttributeChangeListener)this.fListeners.fire()).attributeChange(new AttributeChangeEvent(this, attribute, object, object2));
        }
    }
}

