/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.attr;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.Attributes;
import com.mathworks.desktop.attr.DefaultAttributes;
import com.mathworks.util.logger.Log;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;

public class Resources {
    private static final Log LOG = Log.getInstance((String)"com.mathworks.desktop.attr.Resources");

    public static Attributes toAttributes(ResourceBundle resourceBundle, Class clazz, String string) {
        final String string2 = string + ".";
        return Resources.toAttributes(resourceBundle, clazz, new KeyMapper(){

            @Override
            @Nullable
            public String map(String string) {
                if (string.startsWith(string2)) {
                    return string.substring(string2.length());
                }
                return null;
            }
        });
    }

    public static Attributes toAttributes(ResourceBundle resourceBundle, Class clazz, KeyMapper keyMapper) {
        Map<String, Attribute> map = DefaultAttributes.collectAttributes(clazz);
        DefaultAttributes defaultAttributes = new DefaultAttributes();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            Attribute attribute;
            String string = enumeration.nextElement();
            String string2 = keyMapper.map(string);
            if (string2 == null || (attribute = map.get(string2)) == null) continue;
            Object t = attribute.parse(resourceBundle.getString(string));
            defaultAttributes.setAttribute(attribute, t);
        }
        return defaultAttributes;
    }

    public static ResourceBundle getBundle(Class clazz) {
        return Resources.getBundle("Resources", clazz);
    }

    public static ResourceBundle getBundle(String string, Class clazz) {
        return Resources.getBundle(string, clazz, clazz.getClassLoader(), Locale.getDefault());
    }

    public static ResourceBundle getBundle(String string, Class clazz, ClassLoader classLoader) {
        return Resources.getBundle(string, clazz, classLoader, Locale.getDefault());
    }

    public static ResourceBundle getBundle(String string, Class clazz, ClassLoader classLoader, Locale locale) {
        ResourceBundle resourceBundle;
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        string2 = string2 + "." + string;
        try {
            resourceBundle = ResourceBundle.getBundle(string2, locale, classLoader);
        }
        catch (Exception exception) {
            LOG.warn("Error loading resource bundle %s for class %s", new Object[]{string2, clazz.getName()});
            resourceBundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String string) {
                    return "";
                }

                @Override
                public Enumeration<String> getKeys() {
                    return new Enumeration<String>(){

                        @Override
                        public boolean hasMoreElements() {
                            return false;
                        }

                        @Override
                        public String nextElement() {
                            return null;
                        }
                    };
                }
            };
        }
        return resourceBundle;
    }

    public static interface KeyMapper {
        @Nullable
        public String map(String var1);
    }
}

