/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.client;

import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.desktop.client.ClientCollectionListener;
import com.mathworks.desktop.client.DefaultClientCollection;
import com.mathworks.util.Disposable;
import com.mathworks.util.event.EventListenerList;
import java.lang.reflect.Array;
import java.util.Iterator;

public class CompositeClientCollection<C extends Client>
implements ClientCollection<C>,
Disposable {
    private final ClientCollection<C> fHead;
    private final ClientCollection<C> fTail;
    private boolean doNotFireEvents;
    private final EventListenerList<ClientCollectionListener> fListeners = EventListenerList.newEventListenerList(ClientCollectionListener.class);

    public CompositeClientCollection(C c, ClientCollection<C> clientCollection) {
        this(new DefaultClientCollection(new Client[]{c}), clientCollection);
    }

    public CompositeClientCollection(ClientCollection<C> clientCollection, ClientCollection<C> clientCollection2) {
        this.fHead = clientCollection;
        this.fTail = clientCollection2;
        clientCollection.addClientCollectionListener(new ClientCollectionListener<C>(){

            @Override
            public void clientAdded(ClientCollectionListener.Added<C> added) {
                if (!CompositeClientCollection.this.doNotFireEvents) {
                    ((ClientCollectionListener)CompositeClientCollection.this.fListeners.fire()).clientAdded(added);
                }
            }

            @Override
            public void clientRemoved(ClientCollectionListener.Removed<C> removed) {
                if (!CompositeClientCollection.this.doNotFireEvents) {
                    ((ClientCollectionListener)CompositeClientCollection.this.fListeners.fire()).clientRemoved(removed);
                }
            }

            @Override
            public void clientMoved(ClientCollectionListener.Moved<C> moved) {
                ((ClientCollectionListener)CompositeClientCollection.this.fListeners.fire()).clientMoved(moved);
            }
        }, this);
        clientCollection2.addClientCollectionListener(new ClientCollectionListener<C>(){

            @Override
            public void clientAdded(ClientCollectionListener.Added<C> added) {
                if (!CompositeClientCollection.this.doNotFireEvents) {
                    ((ClientCollectionListener)CompositeClientCollection.this.fListeners.fire()).clientAdded(new ClientCollectionListener.Added(added.getClient(), CompositeClientCollection.this.fHead.size() + added.getIndex()));
                }
            }

            @Override
            public void clientRemoved(ClientCollectionListener.Removed<C> removed) {
                if (!CompositeClientCollection.this.doNotFireEvents) {
                    ((ClientCollectionListener)CompositeClientCollection.this.fListeners.fire()).clientRemoved(new ClientCollectionListener.Removed(removed.getClient(), CompositeClientCollection.this.fHead.size() + removed.getIndex()));
                }
            }

            @Override
            public void clientMoved(ClientCollectionListener.Moved<C> moved) {
                ((ClientCollectionListener)CompositeClientCollection.this.fListeners.fire()).clientMoved(new ClientCollectionListener.Moved(moved.getClient(), CompositeClientCollection.this.fHead.size() + moved.getIndex(), moved.getDelta()));
            }
        }, this);
    }

    public ClientCollection<C> getHead() {
        return this.fHead;
    }

    public ClientCollection<C> getTail() {
        return this.fTail;
    }

    public void dispose() {
    }

    @Override
    public int size() {
        return this.fHead.size() + this.fTail.size();
    }

    @Override
    public C get(int n) {
        if (n < this.fHead.size()) {
            return this.fHead.get(n);
        }
        return this.fTail.get(n - this.fHead.size());
    }

    @Override
    public C get(String string) {
        C c = this.fHead.get(string);
        if (c == null) {
            c = this.fTail.get(string);
        }
        return c;
    }

    @Override
    public int indexOf(C c) {
        int n = this.fHead.indexOf(c);
        if (n >= 0) {
            return n;
        }
        n = this.fTail.indexOf(c);
        if (n >= 0) {
            return this.fHead.size() + n;
        }
        return -1;
    }

    @Override
    public boolean add(C c) {
        return this.fTail.add(c);
    }

    @Override
    public boolean add(int n, C c) {
        if (n < this.fHead.size()) {
            return this.fHead.add(n, c);
        }
        return this.fTail.add(n - this.fHead.size(), c);
    }

    @Override
    public C remove(int n) {
        if (n < this.fHead.size()) {
            return this.fHead.remove(n);
        }
        return this.fTail.remove(n - this.fHead.size());
    }

    @Override
    public boolean remove(C c) {
        int n = this.indexOf(c);
        return n >= 0 && this.remove(n) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean move(int n, int n2) {
        int n3 = n + n2;
        if (n != n3 && this.size() >= 2) {
            C c;
            if (n < this.fHead.size() && n3 < this.fHead.size()) {
                return this.fHead.move(n, n2);
            }
            if (n >= this.fHead.size() && n3 >= this.fHead.size()) {
                return this.fTail.move(n - this.fHead.size(), n2);
            }
            try {
                this.doNotFireEvents = true;
                c = this.remove(n);
                this.add(n3, c);
            }
            finally {
                this.doNotFireEvents = false;
            }
            ((ClientCollectionListener)this.fListeners.fire()).clientMoved(new ClientCollectionListener.Moved<C>(c, n, n2));
            return true;
        }
        return false;
    }

    @Override
    public C[] toArray(C[] CArray) {
        Client[] clientArray = (Client[])CompositeClientCollection.newInstance(CArray.getClass(), this.fHead.size());
        Client[] clientArray2 = (Client[])CompositeClientCollection.newInstance(CArray.getClass(), this.fTail.size());
        clientArray = this.fHead.toArray(clientArray);
        clientArray2 = this.fTail.toArray(clientArray2);
        Client[] clientArray3 = (Client[])CompositeClientCollection.newInstance(CArray.getClass(), clientArray.length + clientArray2.length);
        System.arraycopy(clientArray, 0, clientArray3, 0, clientArray.length);
        System.arraycopy(clientArray2, 0, clientArray3, clientArray.length, clientArray2.length);
        return clientArray3;
    }

    private static <C> C[] newInstance(Class<? extends C[]> clazz, int n) {
        return clazz == Object[].class ? new Object[n] : (Object[])Array.newInstance(clazz.getComponentType(), n);
    }

    @Override
    public void addClientCollectionListener(ClientCollectionListener<C> clientCollectionListener, Disposable disposable) {
        this.fListeners.addListener(clientCollectionListener, disposable);
    }

    @Override
    public void addClientCollectionListener(ClientCollectionListener<C> clientCollectionListener) {
        this.fListeners.addListener(clientCollectionListener);
    }

    @Override
    public void removeClientCollectionListener(ClientCollectionListener<C> clientCollectionListener) {
        this.fListeners.removeListener(clientCollectionListener);
    }

    @Override
    public Iterator<C> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<C> {
        Iterator<C> p1;
        Iterator<C> p2;

        private MyIterator() {
            this.p1 = CompositeClientCollection.this.fHead.iterator();
            this.p2 = CompositeClientCollection.this.fTail.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.p1 == null) {
                return this.p2.hasNext();
            }
            if (this.p1.hasNext()) {
                return true;
            }
            this.p1 = null;
            return this.p2.hasNext();
        }

        @Override
        public C next() {
            if (this.p1 == null) {
                return (Client)this.p2.next();
            }
            if (this.p1.hasNext()) {
                return (Client)this.p1.next();
            }
            this.p1 = null;
            return (Client)this.p2.next();
        }

        @Override
        public void remove() {
            if (this.p1 == null) {
                this.p2.remove();
            } else {
                this.p1.remove();
            }
        }
    }
}

