/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.desktop.client.ClientCollectionListener;
import com.mathworks.util.Disposable;
import com.mathworks.util.event.EventListenerList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DefaultClientCollection<C extends Client>
implements ClientCollection<C> {
    private final List<C> fItems = Lists.newArrayList();
    private final EventListenerList<ClientCollectionListener> fListeners = EventListenerList.newEventListenerList(ClientCollectionListener.class);
    private static final String CLIENT = "client";

    public DefaultClientCollection() {
    }

    public DefaultClientCollection(C ... CArray) {
        this.fItems.addAll(Arrays.asList(CArray));
    }

    public DefaultClientCollection(Collection<C> collection) {
        this.fItems.addAll(collection);
    }

    @Override
    public Iterator<C> iterator() {
        return this.fItems.iterator();
    }

    @Override
    public int size() {
        return this.fItems.size();
    }

    @Override
    public boolean add(int n, C c) {
        boolean bl;
        if (n < 0 || n >= this.size()) {
            bl = this.add(c);
        } else {
            this.fItems.add(n, c);
            ((ClientCollectionListener)this.fListeners.fire()).clientAdded(new ClientCollectionListener.Added<C>(c, n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean add(C c) {
        boolean bl = this.fItems.add(c);
        ((ClientCollectionListener)this.fListeners.fire()).clientAdded(new ClientCollectionListener.Added<C>(c, this.size() - 1));
        return bl;
    }

    @Override
    public C get(int n) {
        return (C)((Client)this.fItems.get(n));
    }

    @Override
    @Nullable
    public C get(String string) {
        for (Client client : this.fItems) {
            if (!client.getName().equals(string)) continue;
            return (C)client;
        }
        return null;
    }

    @Override
    public int indexOf(C c) {
        for (int i = 0; i < this.fItems.size(); ++i) {
            Client client = (Client)this.fItems.get(i);
            if (client != c && !client.equals(c)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public C remove(int n) {
        Client client = (Client)this.fItems.remove(n);
        ((ClientCollectionListener)this.fListeners.fire()).clientRemoved(new ClientCollectionListener.Removed<Client>(client, n));
        return (C)client;
    }

    @Override
    public boolean remove(C c) {
        int n = this.fItems.indexOf(c);
        if (n >= 0) {
            this.fItems.remove(n);
            ((ClientCollectionListener)this.fListeners.fire()).clientRemoved(new ClientCollectionListener.Removed<C>(c, n));
        }
        return n >= 0;
    }

    @Override
    public boolean move(int n, int n2) {
        int n3 = this.size();
        int n4 = n + n2;
        Preconditions.checkArgument((n >= 0 && n < n3 && n4 >= 0 && n4 < n3 ? 1 : 0) != 0, (String)"Source index %s or destination index %s is invalid", (Object[])new Object[]{n, n4});
        boolean bl = false;
        if (n != n4 && n3 >= 2) {
            Client client = (Client)this.fItems.remove(n);
            this.fItems.add(n4, client);
            ((ClientCollectionListener)this.fListeners.fire()).clientMoved(new ClientCollectionListener.Moved<Client>(client, n, n2));
            bl = true;
        }
        return bl;
    }

    @Override
    public C[] toArray(C[] CArray) {
        return (Client[])this.fItems.toArray(CArray);
    }

    @Override
    public void addClientCollectionListener(ClientCollectionListener<C> clientCollectionListener) {
        this.fListeners.addListener(clientCollectionListener);
    }

    @Override
    public void addClientCollectionListener(ClientCollectionListener<C> clientCollectionListener, Disposable disposable) {
        this.fListeners.addListener(clientCollectionListener, disposable);
    }

    @Override
    public void removeClientCollectionListener(ClientCollectionListener<C> clientCollectionListener) {
        this.fListeners.removeListener(clientCollectionListener);
    }
}

