/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.mnemonics;

import com.google.common.collect.ImmutableList;
import com.mathworks.desktop.mnemonics.Mnemonic;
import org.jetbrains.annotations.NotNull;

public class MnemonicPath {
    private final ImmutableList<Mnemonic> fPath;

    public MnemonicPath() {
        this.fPath = ImmutableList.of();
    }

    public MnemonicPath(@NotNull Mnemonic mnemonic) {
        this.fPath = ImmutableList.of((Object)mnemonic);
    }

    public MnemonicPath(@NotNull MnemonicPath mnemonicPath, @NotNull Mnemonic mnemonic) {
        this.fPath = ImmutableList.builder().addAll(mnemonicPath.getPath()).add((Object)mnemonic).build();
    }

    public MnemonicPath(@NotNull Iterable<? extends Mnemonic> iterable) {
        this.fPath = ImmutableList.copyOf(iterable);
    }

    @NotNull
    public ImmutableList<Mnemonic> getPath() {
        return this.fPath;
    }

    public boolean isEmpty() {
        return this.fPath.isEmpty();
    }

    @NotNull
    public Mnemonic getRoot() {
        return (Mnemonic)this.fPath.get(0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.fPath.size(); ++i) {
            Mnemonic mnemonic = (Mnemonic)this.fPath.get(i);
            stringBuilder.append(mnemonic.getMnemonic());
            if (i >= this.fPath.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MnemonicPath)) {
            return false;
        }
        MnemonicPath mnemonicPath = (MnemonicPath)object;
        if (mnemonicPath.getPath().size() != this.getPath().size()) {
            return false;
        }
        int n = this.fPath.size();
        for (int i = 0; i < n; ++i) {
            Mnemonic mnemonic = (Mnemonic)this.fPath.get(i);
            Mnemonic mnemonic2 = (Mnemonic)mnemonicPath.getPath().get(i);
            if (mnemonic.getMnemonic().equals(mnemonic2.getMnemonic())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.fPath.hashCode();
    }
}

