/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.gridrulerguide;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.LayoutGridTarget;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.LayoutRuler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class GridDialog
extends MJPanel
implements ActionListener,
ItemListener,
LayoutGridTarget {
    private LayoutArea fLayoutArea;
    private LayoutRuler fHRuler;
    private LayoutRuler fVRuler;
    private MJCheckBox fShowGridCB;
    private MJCheckBox fSnapGridCB;
    private MJCheckBox fShowRulersCB;
    private MJCheckBox fShowGuidesCB;
    private MJComboBox fGridPopup;
    private boolean fShowRulersState;
    private boolean fShowGridState;
    private boolean fShowGuidesState;
    private int fGridWidthState;
    private boolean fSnapGridState;

    public GridDialog(LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
        this.fHRuler = this.fLayoutArea.getHRuler();
        this.fVRuler = this.fLayoutArea.getVRuler();
        this.setLayout(new BorderLayout());
        MJButton mJButton = new MJButton(ResourceManager.getString("button.cancel"));
        mJButton.setName("CANCEL_BTN");
        mJButton.addActionListener((ActionListener)this);
        mJButton.setActionCommand("Cancel");
        MJButton mJButton2 = new MJButton(ResourceManager.getString("button.ok"));
        mJButton2.setName("OK_BTN");
        mJButton2.addActionListener((ActionListener)this);
        mJButton2.setActionCommand("OK");
        JPanel jPanel = ButtonBarFactory.buildOKCancelBar((JButton)mJButton2, (JButton)mJButton);
        jPanel.setBorder(Borders.createEmptyBorder((String)"0dlu, 0dlu, 4dlu, 4dlu"));
        this.add(jPanel, "South");
        this.fShowRulersCB = new MJCheckBox(ResourceManager.getString("checkbox.show_rulers"));
        this.fShowRulersCB.setName("SHOW_RULERS");
        this.fShowRulersCB.addItemListener((ItemListener)this);
        this.fShowGuidesCB = new MJCheckBox(ResourceManager.getString("checkbox.show_guides"));
        this.fShowGuidesCB.setName("SHOW_GUIDES");
        this.fShowGuidesCB.addItemListener((ItemListener)this);
        this.fShowGridCB = new MJCheckBox(ResourceManager.getString("checkbox.show_grid"));
        this.fShowGridCB.setName("SHOW_GRID");
        this.fShowGridCB.addItemListener((ItemListener)this);
        MJLabel mJLabel = new MJLabel(ResourceManager.getString("label.grid_size"));
        this.fGridPopup = new MJComboBox();
        this.fGridPopup.setName("GRID_SIZE");
        this.buildPopup();
        this.setSelectedGridWidth(this.fLayoutArea.getGrid().getGridWidth());
        this.fGridPopup.addItemListener((ItemListener)this);
        this.fSnapGridCB = new MJCheckBox(ResourceManager.getString("checkbox.snap_to_grid"));
        this.fSnapGridCB.setName("SNAP_TO_GRID");
        this.fSnapGridCB.addItemListener((ItemListener)this);
        this.setMinimumSize(new Dimension(300, 200));
        FormLayout formLayout = new FormLayout("8dlu, p, 4dlu, p, 8dlu", "p, 4dlu, p, 4dlu, p, 4dlu, p, 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fShowRulersCB, cellConstraints.xyw(2, 1, 3));
        panelBuilder.add((Component)this.fShowGuidesCB, cellConstraints.xyw(2, 3, 3));
        panelBuilder.add((Component)this.fShowGridCB, cellConstraints.xyw(2, 5, 3));
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(2, 7));
        panelBuilder.add((Component)this.fGridPopup, cellConstraints.xy(4, 7));
        panelBuilder.add((Component)this.fSnapGridCB, cellConstraints.xyw(2, 9, 3));
        panelBuilder.setDefaultDialogBorder();
        this.add(panelBuilder.getPanel(), "Center");
        this.fLayoutArea.getGrid().addLayoutGridTarget(this);
    }

    public void updateState() {
        this.fShowRulersState = this.fHRuler.getRulerState();
        this.fShowRulersCB.setSelected(this.fShowRulersState);
        this.fShowGridState = this.fLayoutArea.getGrid().getShowGrid();
        this.fShowGridCB.setSelected(this.fShowGridState);
        this.fShowGuidesState = this.fLayoutArea.getGrid().getShowGuides();
        this.fShowGuidesCB.setSelected(this.fShowGuidesState);
        this.fGridWidthState = this.fHRuler.getGridWidth();
        this.setSelectedGridWidth(this.fGridWidthState);
        this.fSnapGridState = this.fLayoutArea.getGrid().getSnapToGrid();
        this.fSnapGridCB.setSelected(this.fSnapGridState);
        this.fShowRulersCB.requestFocusInWindow();
    }

    private void setSelectedGridWidth(int n) {
        String string = String.valueOf(n);
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.fGridPopup.getModel();
        if (defaultComboBoxModel.getIndexOf(string) >= 0) {
            defaultComboBoxModel.setSelectedItem(string);
        }
    }

    private void buildPopup() {
        String[] stringArray = new String[]{"10", "20", "30", "40", "50", "60", "70", "80", "90", "100", "110", "120", "130", "140", "150", "160", "170", "180", "190", "200"};
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        this.fGridPopup.setModel(defaultComboBoxModel);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.isVisible()) {
            return;
        }
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof MJCheckBox) {
            MJCheckBox mJCheckBox = (MJCheckBox)itemSelectable;
            if (mJCheckBox == this.fShowRulersCB) {
                this.fHRuler.setRulerState(this.fShowRulersCB.isSelected());
                this.fVRuler.setRulerState(this.fShowRulersCB.isSelected());
                this.fLayoutArea.resizeScroller();
            } else if (mJCheckBox == this.fShowGridCB) {
                this.fLayoutArea.getGrid().setShowGrid(this.fShowGridCB.isSelected());
                this.fLayoutArea.repaint(2L);
            } else if (mJCheckBox == this.fShowGuidesCB) {
                this.fLayoutArea.getGrid().setShowGuides(this.fShowGuidesCB.isSelected());
                this.fLayoutArea.repaint(2L);
            } else if (mJCheckBox == this.fSnapGridCB) {
                this.fLayoutArea.getGrid().setSnapToGrid(this.fSnapGridCB.isSelected());
            }
        } else if (itemSelectable instanceof MJComboBox) {
            int n = (this.fGridPopup.getSelectedIndex() + 1) * 10;
            this.fHRuler.setGridWidth(n);
            this.fVRuler.setGridWidth(n);
            this.fLayoutArea.getGrid().setGridWidth(n);
            this.fLayoutArea.repaint(2L);
            this.fHRuler.repaint(2L);
            this.fVRuler.repaint(2L);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            window.setVisible(false);
        } else if (string.equals("Cancel")) {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            window.setVisible(false);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.fShowRulersState != this.fHRuler.getRulerState()) {
                this.fHRuler.setRulerState(this.fShowRulersState);
                this.fVRuler.setRulerState(this.fShowRulersState);
                bl3 = true;
            }
            if (this.fShowGridState != this.fLayoutArea.getGrid().getShowGrid()) {
                this.fLayoutArea.getGrid().setShowGrid(this.fShowGridState);
                bl = true;
            }
            if (this.fShowGuidesState != this.fLayoutArea.getGrid().getShowGuides()) {
                this.fLayoutArea.getGrid().setShowGuides(this.fShowGuidesState);
                bl = true;
            }
            if (this.fGridWidthState != this.fHRuler.getGridWidth()) {
                this.fHRuler.setGridWidth(this.fGridWidthState);
                this.fVRuler.setGridWidth(this.fGridWidthState);
                this.fLayoutArea.getGrid().setGridWidth(this.fGridWidthState);
                bl = true;
                bl2 = true;
            }
            if (this.fSnapGridState != this.fLayoutArea.getGrid().getSnapToGrid()) {
                this.fLayoutArea.getGrid().setSnapToGrid(this.fSnapGridState);
            }
            if (bl3) {
                this.fLayoutArea.resizeScroller();
            } else {
                if (bl) {
                    this.fLayoutArea.repaint(2L);
                }
                if (bl2) {
                    this.fHRuler.repaint(2L);
                    this.fVRuler.repaint(2L);
                }
            }
        }
    }

    @Override
    public void snapToGridChanged(boolean bl) {
        this.fSnapGridCB.setSelected(bl);
    }
}

