/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.menueditor;

import com.mathworks.toolbox.matlab.guide.icons.MenuEditorIcon;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuNode;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuNodeType;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class MenuTreeNode
extends DefaultMutableTreeNode {
    private MenuNodeType type;

    public MenuTreeNode(MenuNodeType menuNodeType, MenuNode menuNode) {
        super(menuNode);
        this.type = menuNodeType;
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof String) {
            Object object2 = this.getUserObject();
            if (object2 != null && object2 instanceof MenuNode) {
                if (this.getType() != MenuNodeType.CONTEXTMENU) {
                    ((MenuNode)object2).setLabel((String)object);
                } else {
                    ((MenuNode)object2).setTag((String)object);
                }
            }
        } else {
            super.setUserObject(object);
        }
    }

    public MenuNodeType getType() {
        return this.type;
    }

    public Icon getIcon() {
        ImageIcon imageIcon = null;
        if (this.isLeaf() && this.getLevel() > 1) {
            imageIcon = MenuEditorIcon.NEW_MENUITEM.getIcon();
        } else if (this.type == MenuNodeType.MENU) {
            imageIcon = this.getLevel() > 1 && !this.isLeaf() ? MenuEditorIcon.SUBMENU.getIcon() : MenuEditorIcon.NEW_MENU.getIcon();
        } else if (this.type == MenuNodeType.CONTEXTMENU) {
            imageIcon = MenuEditorIcon.NEW_CONTEXTMENU.getIcon();
        }
        return imageIcon;
    }

    @Override
    public String toString() {
        if (this.getUserObject() != null) {
            if (this.getType() != MenuNodeType.CONTEXTMENU) {
                return ((MenuNode)this.getUserObject()).getLabel();
            }
            return ((MenuNode)this.getUserObject()).getTag();
        }
        return this.getClass().getName();
    }
}

