/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.template;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.matlab.guide.template.TemplateInfo;
import com.mathworks.util.FileUtils;
import com.mathworks.util.ResLoader;
import java.awt.Image;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class TemplateParser
implements ErrorHandler {
    public static final String TEMPLATES_TAG = "Templates";
    public static final String GROUP_TAG = "Group";
    public static final String DEFAULT_TAG = "Default";
    public static final String PATH_TAG = "Path";
    public static final String TEMPLATE_TAG = "Template";
    public static final String CLASS_TAG = "Class";
    public static final String NAME_TAG = "Name";
    public static final String FILE_TAG = "File";
    private static final String sMatlabRoot = FileUtils.fromJavaPath((String)Matlab.matlabRoot());
    private Document fTemplateDoc;
    private static DocumentBuilder sDocBuilder;
    private int fDefaultGroupIndex;
    private TemplateGroup[] fTemplateGroups = null;

    public void parseTemplateInfo(String string) {
        this.xmlParse(string);
    }

    public void xmlParse(String string) {
        Object object;
        try {
            if (sDocBuilder == null) {
                object = DocumentBuilderFactory.newInstance();
                sDocBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            }
            this.fTemplateDoc = sDocBuilder.parse(string);
        }
        catch (SAXParseException sAXParseException) {
            System.err.println("Parsing failed. \n" + sAXParseException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Parsing Failed. \n" + fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("File " + string + " could not be parsed successfully.");
            exception.printStackTrace();
        }
        if (null != this.fTemplateDoc) {
            try {
                object = this.fTemplateDoc.getDocumentElement();
                NodeList nodeList = object.getElementsByTagName(GROUP_TAG);
                if (nodeList.getLength() <= 0) {
                    return;
                }
                this.fTemplateGroups = new TemplateGroup[nodeList.getLength()];
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string2 = element.getAttribute(CLASS_TAG);
                    int n = Integer.parseInt(element.getAttribute(DEFAULT_TAG));
                    String string3 = element.getAttribute(PATH_TAG);
                    NodeList nodeList2 = element.getElementsByTagName(TEMPLATE_TAG);
                    TemplateInfo[] templateInfoArray = null;
                    if (nodeList2.getLength() > 0) {
                        templateInfoArray = new Template[nodeList2.getLength()];
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Element element2 = (Element)nodeList2.item(j);
                            String string4 = element2.getAttribute(NAME_TAG);
                            String string5 = element2.getAttribute(FILE_TAG);
                            templateInfoArray[j] = new Template(string4, string3 + string5);
                        }
                    }
                    if (1 == n) {
                        this.fDefaultGroupIndex = i;
                    }
                    this.fTemplateGroups[i] = new TemplateGroup(string2, string3, templateInfoArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("File " + string + " could not be parsed successfully.");
            }
        }
    }

    public String[] getTemplateGroupNames() {
        String[] stringArray = null;
        if (null != this.fTemplateGroups) {
            stringArray = new String[this.fTemplateGroups.length];
            for (int i = 0; i < this.fTemplateGroups.length; ++i) {
                stringArray[i] = this.fTemplateGroups[i].getName();
            }
        }
        return stringArray;
    }

    public TemplateInfo[] getTemplates(int n) {
        if (null != this.fTemplateGroups) {
            return this.fTemplateGroups[n].fTemplates;
        }
        return null;
    }

    public int getDefaultGroupIndex() {
        return this.fDefaultGroupIndex;
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        System.out.println(sAXParseException.getLocalizedMessage());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        System.out.println(sAXParseException.getLocalizedMessage());
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        System.out.println(sAXParseException.getLocalizedMessage());
    }

    private static class Template
    implements TemplateInfo {
        private String fTemplateName;
        private String fFileName;
        private Image fTemplatePreview;

        private Template(String string, String string2) {
            this.fTemplateName = string;
            this.fFileName = sMatlabRoot + string2;
            ResLoader resLoader = new ResLoader(Object.class);
            try {
                this.fTemplatePreview = resLoader.loadImage(new URL("file", "", this.fFileName + ".gif"));
            }
            catch (MalformedURLException malformedURLException) {
                this.fTemplatePreview = null;
            }
        }

        @Override
        public String getName() {
            return this.fTemplateName;
        }

        @Override
        public String getFilename() {
            return this.fFileName;
        }

        @Override
        public Image getPreview() {
            return this.fTemplatePreview;
        }

        public String toString() {
            return this.fTemplateName;
        }
    }

    private class TemplateGroup {
        private String fGroupName;
        private String fGroupPath;
        private TemplateInfo[] fTemplates = null;

        public TemplateGroup(String string, String string2, TemplateInfo[] templateInfoArray) {
            this.fGroupName = string;
            this.fGroupPath = string2;
            this.fTemplates = templateInfoArray;
        }

        public String getName() {
            return this.fGroupName;
        }

        public String getPath() {
            return this.fGroupPath;
        }

        public TemplateInfo[] getTemplates() {
            return this.fTemplates;
        }
    }
}

