/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.undoredo;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import com.mathworks.toolbox.matlab.guide.undoredo.LayoutUndoableEdit;
import java.util.Vector;

public class UndoDelete
extends LayoutUndoableEdit {
    private LayoutArea fLayout;
    private int fControlCount;
    private LOControlWrapper[] fControlWrappers;
    private LOWrapperOwner[] fControlOwners;
    private int[] fControlIndexs;

    public UndoDelete(LayoutArea layoutArea, Vector vector) {
        this.fLayout = layoutArea;
        this.fControlCount = vector.size();
        this.fControlWrappers = new LOControlWrapper[this.fControlCount];
        this.fControlOwners = new LOWrapperOwner[this.fControlCount];
        this.fControlIndexs = new int[this.fControlCount];
        vector.copyInto(this.fControlWrappers);
        for (int i = 0; i < this.fControlCount; ++i) {
            this.fControlOwners[i] = this.fControlWrappers[i].getParent();
            if (this.fControlOwners[i] == null) {
                this.fControlOwners[i] = this.fLayout;
            }
            this.fControlIndexs[i] = this.fControlOwners[i].getIndexOfWrapper(this.fControlWrappers[i]);
        }
    }

    @Override
    public void undo() {
        this.fLayout.selectAll(false);
        Vector<GObjectWrapper> vector = new Vector<GObjectWrapper>(this.fControlCount);
        for (int i = 0; i < this.fControlCount; ++i) {
            if (this.fControlWrappers[i].isGObject()) {
                GObjectWrapper gObjectWrapper = (GObjectWrapper)this.fControlWrappers[i];
                this.fLayout.selectObject(gObjectWrapper, true);
                vector.addElement(gObjectWrapper);
                this.fControlOwners[i].addWrapper(gObjectWrapper, this.fControlIndexs[i], false);
                if (!this.fControlWrappers[i].isBean()) continue;
                this.fLayout.addServices(this.fControlWrappers[i]);
                continue;
            }
            this.fLayout.selectObject(this.fControlWrappers[i], true);
            this.fControlOwners[i].addWrapper(this.fControlWrappers[i], this.fControlIndexs[i], true);
            this.fLayout.register(this.fControlWrappers[i]);
            this.fLayout.addServices(this.fControlWrappers[i]);
        }
        if (vector.size() > 0) {
            GObjectWrapper[] gObjectWrapperArray = new GObjectWrapper[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                gObjectWrapperArray[i] = (GObjectWrapper)vector.elementAt(i);
            }
            LayoutLooper.requestGObjects(this.fControlOwners, gObjectWrapperArray, this.fLayout);
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    public void redo() {
        this.fLayout.selectAll(false);
        Vector<GObjectWrapper> vector = new Vector<GObjectWrapper>(this.fControlCount);
        for (int i = 0; i < this.fControlCount; ++i) {
            if (this.fControlWrappers[i].isGObject()) {
                GObjectWrapper gObjectWrapper = (GObjectWrapper)this.fControlWrappers[i];
                this.fLayout.removeServices(gObjectWrapper);
                this.fLayout.unregister(gObjectWrapper);
                vector.addElement(gObjectWrapper);
                this.fControlOwners[i].removeWrapper(gObjectWrapper, false);
                continue;
            }
            this.fLayout.removeServices(this.fControlWrappers[i]);
            this.fLayout.unregister(this.fControlWrappers[i]);
            this.fControlOwners[i].removeWrapper(this.fControlWrappers[i], false);
        }
        if (vector.size() > 0) {
            GObjectWrapper[] gObjectWrapperArray = new GObjectWrapper[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                gObjectWrapperArray[i] = (GObjectWrapper)vector.elementAt(i);
            }
            LayoutLooper.deleteGObjects(gObjectWrapperArray, this.fLayout);
        }
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    String getUndoTypeKey() {
        return "undo.delete";
    }
}

