/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.undoredo;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.undoredo.LayoutUndoableEdit;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;

public class UndoResize
extends LayoutUndoableEdit {
    private LayoutArea fLayout;
    private LOControlWrapper fWrapper;
    private Point fStartLocation;
    private Point fFinalLocation;
    private Dimension fStartSize;
    private Dimension fFinalSize;
    private Object[] fOldValues;
    private Object[] fNewValues;

    public UndoResize(LayoutArea layoutArea, LOControlWrapper lOControlWrapper) {
        this.fLayout = layoutArea;
        this.fWrapper = lOControlWrapper;
        this.fStartLocation = this.fWrapper.getControl().getLocation();
        this.fStartSize = this.fWrapper.getControl().getSize();
        this.fOldValues = new Object[1];
        this.fNewValues = new Object[1];
        if (this.fWrapper.isGObject()) {
            this.fOldValues[0] = ((GObjectWrapper)this.fWrapper).getProperties();
        }
    }

    public boolean resizeComplete() {
        boolean bl;
        this.fFinalLocation = this.fWrapper.getControl().getLocation();
        this.fFinalSize = this.fWrapper.getControl().getSize();
        boolean bl2 = bl = this.fStartSize.width != this.fFinalSize.width || this.fStartSize.height != this.fFinalSize.height || this.fStartLocation.x != this.fFinalLocation.x || this.fStartLocation.y != this.fFinalLocation.y;
        if (bl) {
            if (this.fStartSize.width == this.fFinalSize.width && this.fStartSize.height == this.fFinalSize.height) {
                this.fStartSize = null;
                this.fFinalSize = null;
            }
            if (this.fStartLocation.x == this.fFinalLocation.x && this.fStartLocation.y == this.fFinalLocation.y) {
                this.fStartLocation = null;
                this.fFinalLocation = null;
            }
        }
        return bl;
    }

    @Override
    public void undo() {
        this.fLayout.selectAll(false);
        if (this.fStartLocation != null) {
            this.fWrapper.getControl().setLocation(this.fStartLocation);
        }
        if (this.fStartSize != null) {
            this.fWrapper.getControl().setSize(this.fStartSize);
        }
        if (this.fWrapper.getNeedsLayout()) {
            LayoutArea.forceLayout((Container)this.fWrapper.getControl());
        }
        if (this.fWrapper.isGObject()) {
            this.fNewValues[0] = ((GObjectWrapper)this.fWrapper).getProperties();
            Object[] objectArray = (Object[])this.fOldValues[0];
            ((GObjectWrapper)this.fWrapper).setProperties(objectArray);
            Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>(1);
            vector.addElement(this.fWrapper);
            LayoutLooper.requestMove(vector, this.fLayout);
        } else {
            this.fLayout.fireObjectChangedEvent(this.fWrapper);
        }
        this.fLayout.selectObject(this.fWrapper, true);
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    public void redo() {
        this.fLayout.selectAll(false);
        if (this.fFinalLocation != null) {
            this.fWrapper.getControl().setLocation(this.fFinalLocation);
        }
        if (this.fFinalSize != null) {
            this.fWrapper.getControl().setSize(this.fFinalSize);
        }
        if (this.fWrapper.getNeedsLayout()) {
            LayoutArea.forceLayout((Container)this.fWrapper.getControl());
        }
        if (this.fWrapper.isGObject()) {
            Object[] objectArray = (Object[])this.fNewValues[0];
            ((GObjectWrapper)this.fWrapper).setProperties(objectArray);
            Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>(1);
            vector.addElement(this.fWrapper);
            LayoutLooper.requestMove(vector, this.fLayout);
        } else {
            this.fLayout.fireObjectChangedEvent(this.fWrapper);
        }
        this.fLayout.selectObject(this.fWrapper, true);
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    String getUndoTypeKey() {
        return "undo.resize";
    }
}

