/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.URLConverter;
import com.sun.javafx.scene.layout.region.Border;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.Repeat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.text.Font;

public class BorderImage
extends Border {
    private final Image image;
    private final boolean fillCenter;
    private final double leftSlice;
    private final double topSlice;
    private final double rightSlice;
    private final double bottomSlice;
    private final boolean proportionalSlice;
    private final Repeat repeatX;
    private final Repeat repeatY;

    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return BorderImage.impl_CSS_STYLEABLES();
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isFillCenter() {
        return this.fillCenter;
    }

    public double getLeftSlice() {
        return this.leftSlice;
    }

    public double getTopSlice() {
        return this.topSlice;
    }

    public double getRightSlice() {
        return this.rightSlice;
    }

    public double getBottomSlice() {
        return this.bottomSlice;
    }

    public boolean isProportionalSlice() {
        return this.proportionalSlice;
    }

    public Repeat getRepeatX() {
        return this.repeatX;
    }

    public Repeat getRepeatY() {
        return this.repeatY;
    }

    private BorderImage(Image image, boolean bl, double d, double d2, double d3, double d4, Repeat repeat, Repeat repeat2, boolean bl2, boolean bl3, double d5, double d6, double d7, double d8, Insets insets) {
        super(d5, d6, d7, d8, bl3, insets);
        this.image = image;
        this.fillCenter = bl;
        this.topSlice = d;
        this.rightSlice = d2;
        this.bottomSlice = d3;
        this.leftSlice = d4;
        this.repeatX = repeat;
        this.repeatY = repeat2;
        this.proportionalSlice = bl2;
    }

    public static final class SliceConverter
    extends StyleConverter<ParsedValue[], BorderImageSlice> {
        public static SliceConverter getInstance() {
            return Holder.BORDER_IMAGE_SLICE_CONVERTER;
        }

        private SliceConverter() {
        }

        @Override
        public BorderImageSlice convert(ParsedValue<ParsedValue[], BorderImageSlice> parsedValue, Font font) {
            ParsedValue[] parsedValueArray = parsedValue.getValue();
            ParsedValue[] parsedValueArray2 = (ParsedValue[])parsedValueArray[0].getValue();
            Size size = (Size)parsedValueArray2[0].convert(font);
            Size size2 = (Size)parsedValueArray2[1].convert(font);
            Size size3 = (Size)parsedValueArray2[2].convert(font);
            Size size4 = (Size)parsedValueArray2[3].convert(font);
            boolean bl = false;
            if (size.getUnits() == size2.getUnits() && size.getUnits() == size3.getUnits() && size2.getUnits() == size4.getUnits()) {
                bl = size.getUnits() == SizeUnits.PERCENT;
            } else {
                System.err.println("border-image-slice size units do not match");
            }
            Double d = size.pixels(font);
            Double d2 = size2.pixels(font);
            Double d3 = size3.pixels(font);
            Double d4 = size4.pixels(font);
            Boolean bl2 = (Boolean)parsedValueArray[1].getValue();
            return new BorderImageSlice(d, d2, d3, d4, bl, bl2);
        }

        public String toString() {
            return "BorderImageSliceType";
        }
    }

    public static final class SliceSequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue[], BorderImageSlice>[], BorderImageSlice[]> {
        public static SliceSequenceConverter getInstance() {
            return Holder.BORDER_IMAGE_SLICE_SEQUENCE_CONVERTER;
        }

        @Override
        public BorderImageSlice[] convert(ParsedValue<ParsedValue<ParsedValue[], BorderImageSlice>[], BorderImageSlice[]> parsedValue, Font font) {
            ParsedValue<ParsedValue[], BorderImageSlice>[] parsedValueArray = parsedValue.getValue();
            BorderImageSlice[] borderImageSliceArray = new BorderImageSlice[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                borderImageSliceArray[i] = SliceConverter.getInstance().convert((ParsedValue)parsedValueArray[i], font);
            }
            return borderImageSliceArray;
        }

        public String toString() {
            return "BorderImageSliceSequenceConverter";
        }
    }

    public static final class BorderImageSlice {
        private final double top;
        private final double right;
        private final double bottom;
        private final double left;
        private final boolean proportional;
        private final boolean fill;

        public BorderImageSlice(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
            this.top = d;
            this.right = d2;
            this.bottom = d3;
            this.left = d4;
            this.proportional = bl;
            this.fill = bl2;
        }

        public double getTop() {
            return this.top;
        }

        public double getRight() {
            return this.right;
        }

        public double getBottom() {
            return this.bottom;
        }

        public double getLeft() {
            return this.left;
        }

        public boolean isProportional() {
            return this.proportional;
        }

        public boolean isFill() {
            return this.fill;
        }
    }

    public static final class RepeatConverter
    extends StyleConverter<ParsedValue<String, Repeat>[][], BorderImageRepeat[]> {
        private final EnumConverter<Repeat> repeatConverter = new EnumConverter(Repeat.class);

        public static RepeatConverter getInstance() {
            return Holder.BORDER_IMAGE_REPEAT_CONVERTER;
        }

        private RepeatConverter() {
        }

        @Override
        public BorderImageRepeat[] convert(ParsedValue<ParsedValue<String, Repeat>[][], BorderImageRepeat[]> parsedValue, Font font) {
            ParsedValue<String, Repeat>[][] parsedValueArray = parsedValue.getValue();
            BorderImageRepeat[] borderImageRepeatArray = new BorderImageRepeat[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                ParsedValue<String, Repeat>[] parsedValueArray2 = parsedValueArray[i];
                Repeat repeat = (Repeat)((Object)this.repeatConverter.convert((ParsedValue)parsedValueArray2[0], (Font)null));
                Repeat repeat2 = (Repeat)((Object)this.repeatConverter.convert((ParsedValue)parsedValueArray2[1], (Font)null));
                borderImageRepeatArray[i] = new BorderImageRepeat(repeat, repeat2);
            }
            return borderImageRepeatArray;
        }

        public String toString() {
            return "BorderImageRepeatConverter";
        }
    }

    public static final class BorderImageRepeat {
        private final Repeat repeatX;
        private final Repeat repeatY;

        public BorderImageRepeat(Repeat repeat, Repeat repeat2) {
            this.repeatX = repeat;
            this.repeatY = repeat2;
        }

        public Repeat getRepeatX() {
            return this.repeatX;
        }

        public Repeat getRepeatY() {
            return this.repeatY;
        }
    }

    public static class Builder
    extends Border.Builder {
        private Image image;
        private boolean fillCenter;
        private boolean proportionalSlice = true;
        private double topSlice = 1.0;
        private double rightSlice = 1.0;
        private double bottomSlice = 1.0;
        private double leftSlice = 1.0;
        private Repeat repeatX = Repeat.NO_REPEAT;
        private Repeat repeatY = Repeat.NO_REPEAT;

        public Builder setImage(Image image) {
            this.image = image;
            return this;
        }

        public Builder setFillCenter(boolean bl) {
            this.fillCenter = bl;
            return this;
        }

        public Builder setProportionalSlice(boolean bl) {
            this.proportionalSlice = bl;
            return this;
        }

        public Builder setTopSlice(double d) {
            this.topSlice = d;
            return this;
        }

        public Builder setRightSlice(double d) {
            this.rightSlice = d;
            return this;
        }

        public Builder setBottomSlice(double d) {
            this.bottomSlice = d;
            return this;
        }

        public Builder setLeftSlice(double d) {
            this.leftSlice = d;
            return this;
        }

        public Builder setRepeatX(Repeat repeat) {
            this.repeatX = repeat;
            return this;
        }

        public Builder setRepeatY(Repeat repeat) {
            this.repeatY = repeat;
            return this;
        }

        @Override
        public Builder setLeftWidth(double d) {
            super.setLeftWidth(d);
            return this;
        }

        @Override
        public Builder setTopWidth(double d) {
            super.setTopWidth(d);
            return this;
        }

        @Override
        public Builder setRightWidth(double d) {
            super.setRightWidth(d);
            return this;
        }

        @Override
        public Builder setBottomWidth(double d) {
            super.setBottomWidth(d);
            return this;
        }

        @Override
        public Builder setProportionalWidth(boolean bl) {
            super.setProportionalWidth(bl);
            return this;
        }

        @Override
        public Builder setOffsets(Insets insets) {
            super.setOffsets(insets);
            return this;
        }

        public BorderImage build() {
            return new BorderImage(this.image, this.fillCenter, this.topSlice, this.rightSlice, this.bottomSlice, this.leftSlice, this.repeatX, this.repeatY, this.proportionalSlice, this.proportionalWidth, this.topWidth, this.rightWidth, this.bottomWidth, this.leftWidth, this.offsets);
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Node, String[]> BORDER_IMAGE_SOURCE = new StyleableProperty<Node, String[]>("-fx-border-image-source", (StyleConverter)URLConverter.SequenceConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<String[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, BorderImageRepeat[]> BORDER_IMAGE_REPEAT = new StyleableProperty<Node, BorderImageRepeat[]>("-fx-border-image-repeat", (StyleConverter)RepeatConverter.getInstance(), new BorderImageRepeat[]{new BorderImageRepeat(Repeat.REPEAT, Repeat.REPEAT)}){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<BorderImageRepeat[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, BorderImageSlice[]> BORDER_IMAGE_SLICE = new StyleableProperty<Node, BorderImageSlice[]>("-fx-border-image-slice", (StyleConverter)SliceSequenceConverter.getInstance(), new BorderImageSlice[]{new BorderImageSlice(1.0, 1.0, 1.0, 1.0, true, false)}){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<BorderImageSlice[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, Margins[]> BORDER_IMAGE_WIDTH = new StyleableProperty<Node, Margins[]>("-fx-border-image-width", (StyleConverter)Margins.SequenceConverter.getInstance(), new Margins[]{new Margins(1.0, 1.0, 1.0, 1.0, true)}){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<Margins[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, Insets[]> BORDER_IMAGE_INSETS = new StyleableProperty<Node, Insets[]>("-fx-border-image-insets", (StyleConverter)InsetsConverter.SequenceConverter.getInstance(), new Insets[]{Insets.EMPTY}){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<Insets[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, BORDER_IMAGE_SOURCE, BORDER_IMAGE_REPEAT, BORDER_IMAGE_SLICE, BORDER_IMAGE_WIDTH, BORDER_IMAGE_INSETS);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    private static class Holder {
        private static final RepeatConverter BORDER_IMAGE_REPEAT_CONVERTER = new RepeatConverter();
        private static final SliceConverter BORDER_IMAGE_SLICE_CONVERTER = new SliceConverter();
        private static final SliceSequenceConverter BORDER_IMAGE_SLICE_SEQUENCE_CONVERTER = new SliceSequenceConverter();

        private Holder() {
        }
    }
}

