/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaFileChooserUI;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;
import sun.security.action.LoadLibraryAction;

class AquaFileView
extends FileView {
    private static final boolean DEBUG = false;
    private static final int UNINITALIZED_LS_INFO = -1;
    static final int kLSItemInfoIsPlainFile = 1;
    static final int kLSItemInfoIsPackage = 2;
    static final int kLSItemInfoIsApplication = 4;
    static final int kLSItemInfoIsContainer = 8;
    static final int kLSItemInfoIsAliasFile = 16;
    static final int kLSItemInfoIsSymlink = 32;
    static final int kLSItemInfoIsInvisible = 64;
    static final int kLSItemInfoIsNativeApp = 128;
    static final int kLSItemInfoIsClassicApp = 256;
    static final int kLSItemInfoAppPrefersNative = 512;
    static final int kLSItemInfoAppPrefersClassic = 1024;
    static final int kLSItemInfoAppIsScriptable = 2048;
    static final int kLSItemInfoIsVolume = 4096;
    static final int kLSItemInfoExtensionIsHidden = 0x100000;
    static final AquaUtils.RecyclableSingleton<String> machineName;
    final int MAX_CACHED_ENTRIES = 256;
    protected final Map<File, FileInfo> cache = new LinkedHashMap<File, FileInfo>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, FileInfo> entry) {
            return this.size() > 256;
        }
    };
    final AquaFileChooserUI fFileChooserUI;

    private static native String getNativePathToSharedJDKBundle();

    private static native String getNativeMachineName();

    private static native String getNativeDisplayName(byte[] var0, boolean var1);

    private static native int getNativeLSInfo(byte[] var0, boolean var1);

    private static native String getNativePathForResolvedAlias(byte[] var0, boolean var1);

    private static String getMachineName() {
        return machineName.get();
    }

    protected static String getPathToRunningJDKBundle() {
        return "";
    }

    protected static String getPathToSharedJDKBundle() {
        return AquaFileView.getNativePathToSharedJDKBundle();
    }

    FileInfo getFileInfoFor(File file) {
        FileInfo fileInfo = this.cache.get(file);
        if (fileInfo != null) {
            return fileInfo;
        }
        FileInfo fileInfo2 = new FileInfo(file);
        this.cache.put(file, fileInfo2);
        return fileInfo2;
    }

    public AquaFileView(AquaFileChooserUI aquaFileChooserUI) {
        this.fFileChooserUI = aquaFileChooserUI;
    }

    String _directoryDescriptionText() {
        return this.fFileChooserUI.directoryDescriptionText;
    }

    String _fileDescriptionText() {
        return this.fFileChooserUI.fileDescriptionText;
    }

    boolean _packageIsTraversable() {
        return this.fFileChooserUI.fPackageIsTraversable == 0;
    }

    boolean _applicationIsTraversable() {
        return this.fFileChooserUI.fApplicationIsTraversable == 0;
    }

    @Override
    public String getName(File file) {
        FileInfo fileInfo = this.getFileInfoFor(file);
        if (fileInfo.displayName != null) {
            return fileInfo.displayName;
        }
        String string = AquaFileView.getNativeDisplayName(fileInfo.pathBytes, fileInfo.isDirectory);
        if (string != null) {
            fileInfo.displayName = string;
            return string;
        }
        String string2 = file.getName();
        if (file.isDirectory() && this.fFileChooserUI.getFileChooser().getFileSystemView().isRoot(file)) {
            String string3;
            fileInfo.displayName = string3 = AquaFileView.getMachineName();
            return string3;
        }
        fileInfo.displayName = string2;
        return string2;
    }

    @Override
    public String getDescription(File file) {
        return file.getName();
    }

    @Override
    public String getTypeDescription(File file) {
        if (file.isDirectory()) {
            return this._directoryDescriptionText();
        }
        return this._fileDescriptionText();
    }

    @Override
    public Icon getIcon(File file) {
        FileInfo fileInfo = this.getFileInfoFor(file);
        if (fileInfo.icon != null) {
            return fileInfo.icon;
        }
        if (file == null) {
            fileInfo.icon = AquaIcon.SystemIcon.getDocumentIconUIResource();
        } else {
            AquaIcon.FileIcon fileIcon = new AquaIcon.FileIcon(file);
            fileInfo.icon = fileIcon;
            if (!fileIcon.hasIconRef()) {
                fileInfo.icon = file.isDirectory() ? (this.fFileChooserUI.getFileChooser().getFileSystemView().isRoot(file) ? AquaIcon.SystemIcon.getComputerIconUIResource() : (file.getParent() == null || file.getParent().equals("/") ? AquaIcon.SystemIcon.getHardDriveIconUIResource() : AquaIcon.SystemIcon.getFolderIconUIResource())) : AquaIcon.SystemIcon.getDocumentIconUIResource();
            }
        }
        return fileInfo.icon;
    }

    @Override
    public Boolean isTraversable(File file) {
        if (file.isDirectory()) {
            if (this._packageIsTraversable() && this._applicationIsTraversable()) {
                return Boolean.TRUE;
            }
            if (!this._packageIsTraversable() && !this._applicationIsTraversable() ? this.isPackage(file) || this.isApplication(file) : (!this._applicationIsTraversable() ? this.isApplication(file) : !this._packageIsTraversable() && this.isPackage(file) && !this.isApplication(file))) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (this.isAlias(file)) {
            File file2 = this.resolveAlias(file);
            return file2.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    int getLSInfoFor(File file) {
        FileInfo fileInfo = this.getFileInfoFor(file);
        if (fileInfo.launchServicesInfo == -1) {
            fileInfo.launchServicesInfo = AquaFileView.getNativeLSInfo(fileInfo.pathBytes, fileInfo.isDirectory);
        }
        return fileInfo.launchServicesInfo;
    }

    boolean isAlias(File file) {
        int n = this.getLSInfoFor(file);
        return (n & 0x10) != 0 && (n & 0x20) == 0;
    }

    boolean isApplication(File file) {
        return (this.getLSInfoFor(file) & 4) != 0;
    }

    boolean isPackage(File file) {
        return (this.getLSInfoFor(file) & 2) != 0;
    }

    File resolveAlias(File file) {
        if (file.exists() && !this.isAlias(file)) {
            return file;
        }
        LinkedList<String> linkedList = AquaFileView.getPathComponents(file);
        if (linkedList == null) {
            return file;
        }
        File file2 = new File("/");
        for (String string : linkedList) {
            file2 = new File(file2, string);
            FileInfo fileInfo = this.getFileInfoFor(file2);
            if (!file2.exists()) {
                return file;
            }
            if (!this.isAlias(file2)) continue;
            String string2 = AquaFileView.getNativePathForResolvedAlias(fileInfo.pathBytes, fileInfo.isDirectory);
            if (string2 == null) {
                return file;
            }
            file2 = new File(string2);
        }
        return file2;
    }

    private static LinkedList<String> getPathComponents(File file) {
        String string;
        LinkedList<String> linkedList = new LinkedList<String>();
        File file2 = new File(file.getAbsolutePath());
        linkedList.add(0, file2.getName());
        while ((string = file2.getParent()) != null) {
            file2 = new File(string);
            linkedList.add(0, file2.getName());
        }
        return linkedList;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("osxui"));
        machineName = new AquaUtils.RecyclableSingleton<String>(){

            @Override
            protected String getInstance() {
                return AquaFileView.getNativeMachineName();
            }
        };
    }

    static class FileInfo {
        final boolean isDirectory;
        final String absolutePath;
        byte[] pathBytes;
        String displayName;
        Icon icon;
        int launchServicesInfo = -1;

        FileInfo(File file) {
            this.isDirectory = file.isDirectory();
            this.absolutePath = file.getAbsolutePath();
            try {
                this.pathBytes = this.absolutePath.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.pathBytes = new byte[0];
            }
        }
    }
}

