/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifScrollBarButton;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class MotifScrollBarUI
extends BasicScrollBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifScrollBarUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        return this.scrollbar.getOrientation() == 1 ? new Dimension(n + 11, n2 + 33) : new Dimension(n + 33, n2 + 11);
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        return new MotifScrollBarButton(n);
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        return new MotifScrollBarButton(n);
    }

    @Override
    public void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(this.trackColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(this.thumbColor);
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.thumbHighlightColor);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.drawLine(1, 0, n - 1, 0);
        graphics.setColor(this.thumbLightShadowColor);
        graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
        graphics.translate(-rectangle.x, -rectangle.y);
    }
}

