/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.util;

import com.sun.script.util.BindingsBase;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

public class BindingsEntrySet
extends AbstractSet<Map.Entry<String, Object>> {
    private BindingsBase base;
    private String[] keys;

    public BindingsEntrySet(BindingsBase bindingsBase) {
        this.base = bindingsBase;
        this.keys = bindingsBase.getNames();
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new BindingsIterator();
    }

    public class BindingsIterator
    implements Iterator<Map.Entry<String, Object>> {
        private int current = 0;
        private boolean stale = false;

        @Override
        public boolean hasNext() {
            return this.current < BindingsEntrySet.this.keys.length;
        }

        @Override
        public BindingsEntry next() {
            this.stale = false;
            return new BindingsEntry(BindingsEntrySet.this.keys[this.current++]);
        }

        @Override
        public void remove() {
            if (this.stale || this.current == 0) {
                throw new IllegalStateException();
            }
            this.stale = true;
            BindingsEntrySet.this.base.remove(BindingsEntrySet.this.keys[this.current - 1]);
        }
    }

    public class BindingsEntry
    implements Map.Entry<String, Object> {
        private String key;

        public BindingsEntry(String string) {
            this.key = string;
        }

        @Override
        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return BindingsEntrySet.this.base.get(this.key);
        }
    }
}

