/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.AbstractWatchKey;
import sun.nio.fs.AbstractWatchService;

class PollingWatchService
extends AbstractWatchService {
    private final Map<Object, PollingWatchKey> map = new HashMap<Object, PollingWatchKey>();
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });

    PollingWatchService() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    WatchKey register(final Path path, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        if (kindArray.length == 0) {
            throw new IllegalArgumentException("No events to register");
        }
        final HashSet hashSet = new HashSet(kindArray.length);
        for (WatchEvent.Kind<?> kind : kindArray) {
            if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY || kind == StandardWatchEventKinds.ENTRY_DELETE) {
                hashSet.add(kind);
                continue;
            }
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                if (kindArray.length != 1) continue;
                throw new IllegalArgumentException("No events to register");
            }
            if (kind == null) {
                throw new NullPointerException("An element in event set is 'null'");
            }
            throw new UnsupportedOperationException(kind.name());
        }
        SensitivityWatchEventModifier sensitivityWatchEventModifier = SensitivityWatchEventModifier.MEDIUM;
        if (modifierArray.length > 0) {
            for (WatchEvent.Modifier modifier : modifierArray) {
                if (modifier == null) {
                    throw new NullPointerException();
                }
                if (!(modifier instanceof SensitivityWatchEventModifier)) {
                    throw new UnsupportedOperationException("Modifier not supported");
                }
                SensitivityWatchEventModifier sensitivityWatchEventModifier2 = (SensitivityWatchEventModifier)modifier;
            }
        }
        if (!this.isOpen()) {
            throw new ClosedWatchServiceException();
        }
        try {
            void var5_7;
            void var6_11 = var5_7;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<PollingWatchKey>((SensitivityWatchEventModifier)var6_11){
                final /* synthetic */ SensitivityWatchEventModifier val$s;
                {
                    this.val$s = sensitivityWatchEventModifier;
                }

                @Override
                public PollingWatchKey run() throws IOException {
                    return PollingWatchService.this.doPrivilegedRegister(path, hashSet, this.val$s);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable != null && throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new AssertionError((Object)privilegedActionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollingWatchKey doPrivilegedRegister(Path path, Set<? extends WatchEvent.Kind<?>> set, SensitivityWatchEventModifier sensitivityWatchEventModifier) throws IOException {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        if (!basicFileAttributes.isDirectory()) {
            throw new NotDirectoryException(path.toString());
        }
        Object object = basicFileAttributes.fileKey();
        if (object == null) {
            throw new AssertionError((Object)"File keys must be supported");
        }
        Object object2 = this.closeLock();
        synchronized (object2) {
            PollingWatchKey pollingWatchKey;
            if (!this.isOpen()) {
                throw new ClosedWatchServiceException();
            }
            Map<Object, PollingWatchKey> map = this.map;
            synchronized (map) {
                pollingWatchKey = this.map.get(object);
                if (pollingWatchKey == null) {
                    pollingWatchKey = new PollingWatchKey(path, this, object);
                    this.map.put(object, pollingWatchKey);
                } else {
                    pollingWatchKey.disable();
                }
            }
            pollingWatchKey.enable(set, sensitivityWatchEventModifier.sensitivityValueInSeconds());
            return pollingWatchKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void implClose() throws IOException {
        Map<Object, PollingWatchKey> map = this.map;
        synchronized (map) {
            for (Map.Entry<Object, PollingWatchKey> entry : this.map.entrySet()) {
                PollingWatchKey pollingWatchKey = entry.getValue();
                pollingWatchKey.disable();
                pollingWatchKey.invalidate();
            }
            this.map.clear();
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PollingWatchService.this.scheduledExecutor.shutdown();
                return null;
            }
        });
    }

    private class PollingWatchKey
    extends AbstractWatchKey {
        private final Object fileKey;
        private Set<? extends WatchEvent.Kind<?>> events;
        private ScheduledFuture<?> poller;
        private volatile boolean valid;
        private int tickCount;
        private Map<Path, CacheEntry> entries;

        PollingWatchKey(Path path, PollingWatchService pollingWatchService2, Object object) throws IOException {
            super(path, pollingWatchService2);
            this.fileKey = object;
            this.valid = true;
            this.tickCount = 0;
            this.entries = new HashMap<Path, CacheEntry>();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path path2 : directoryStream) {
                    long l = Files.getLastModifiedTime(path2, LinkOption.NOFOLLOW_LINKS).toMillis();
                    this.entries.put(path2.getFileName(), new CacheEntry(l, this.tickCount));
                }
            }
            catch (DirectoryIteratorException directoryIteratorException) {
                throw directoryIteratorException.getCause();
            }
        }

        Object fileKey() {
            return this.fileKey;
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        void invalidate() {
            this.valid = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enable(Set<? extends WatchEvent.Kind<?>> set, long l) {
            PollingWatchKey pollingWatchKey = this;
            synchronized (pollingWatchKey) {
                this.events = set;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PollingWatchKey.this.poll();
                    }
                };
                this.poller = PollingWatchService.this.scheduledExecutor.scheduleAtFixedRate(runnable, l, l, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disable() {
            PollingWatchKey pollingWatchKey = this;
            synchronized (pollingWatchKey) {
                if (this.poller != null) {
                    this.poller.cancel(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            this.valid = false;
            Map map = PollingWatchService.this.map;
            synchronized (map) {
                PollingWatchService.this.map.remove(this.fileKey());
            }
            this.disable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void poll() {
            if (!this.valid) {
                return;
            }
            ++this.tickCount;
            DirectoryStream<Path> directoryStream = null;
            try {
                directoryStream = Files.newDirectoryStream(this.watchable());
            }
            catch (IOException iOException) {
                this.cancel();
                this.signal();
                return;
            }
            try {
                for (Path object : directoryStream) {
                    long cacheEntry = 0L;
                    try {
                        cacheEntry = Files.getLastModifiedTime(object, LinkOption.NOFOLLOW_LINKS).toMillis();
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    CacheEntry cacheEntry2 = this.entries.get(object.getFileName());
                    if (cacheEntry2 == null) {
                        this.entries.put(object.getFileName(), new CacheEntry(cacheEntry, this.tickCount));
                        if (this.events.contains(StandardWatchEventKinds.ENTRY_CREATE)) {
                            this.signalEvent(StandardWatchEventKinds.ENTRY_CREATE, object.getFileName());
                            continue;
                        }
                        if (!this.events.contains(StandardWatchEventKinds.ENTRY_MODIFY)) continue;
                        this.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, object.getFileName());
                        continue;
                    }
                    if (cacheEntry2.lastModified != cacheEntry && this.events.contains(StandardWatchEventKinds.ENTRY_MODIFY)) {
                        this.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, object.getFileName());
                    }
                    cacheEntry2.update(cacheEntry, this.tickCount);
                }
            }
            catch (DirectoryIteratorException directoryIteratorException) {
            }
            finally {
                try {
                    directoryStream.close();
                }
                catch (IOException iOException) {}
            }
            Iterator<Object> iterator = this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                CacheEntry cacheEntry = (CacheEntry)entry.getValue();
                if (cacheEntry.lastTickCount() == this.tickCount) continue;
                Path path = (Path)entry.getKey();
                iterator.remove();
                if (!this.events.contains(StandardWatchEventKinds.ENTRY_DELETE)) continue;
                this.signalEvent(StandardWatchEventKinds.ENTRY_DELETE, path);
            }
        }
    }

    private static class CacheEntry {
        private long lastModified;
        private int lastTickCount;

        CacheEntry(long l, int n) {
            this.lastModified = l;
            this.lastTickCount = n;
        }

        int lastTickCount() {
            return this.lastTickCount;
        }

        long lastModified() {
            return this.lastModified;
        }

        void update(long l, int n) {
            this.lastModified = l;
            this.lastTickCount = n;
        }
    }
}

