/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AxisComponent;
import com.mathworks.util.PlatformInfo;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import javax.swing.DebugGraphics;
import sun.awt.AWTAccessor;

public class AxisCanvas
extends Canvas
implements AxisComponent {
    private long fNativeWindowHandle = 0L;
    private GraphicsConfiguration fOriginalGraphicsConfiguration = null;

    public AxisCanvas(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.fOriginalGraphicsConfiguration = graphicsConfiguration;
    }

    public AxisCanvas() {
        this(null);
    }

    @Override
    public long getNativeWindowHandle() {
        return this.fNativeWindowHandle;
    }

    @Override
    public void setNativeWindowHandle(long l) {
        this.fNativeWindowHandle = l;
    }

    public boolean isNativeWindowHandleValid() {
        return this.fNativeWindowHandle != 0L && this.fNativeWindowHandle != -1L;
    }

    @Override
    public Graphics getUIJGraphics() {
        return super.getGraphics();
    }

    @Override
    public Graphics getGraphics() {
        HGDebugGraphics hGDebugGraphics = new HGDebugGraphics(super.getGraphics());
        hGDebugGraphics.setDebugOptions(-1);
        return hGDebugGraphics;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public native void paint(Graphics var1);

    private native void updateCanvasWindow();

    @Override
    public void paintCallback(Graphics graphics) {
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.fNativeWindowHandle = -1L;
        if (PlatformInfo.isWindows()) {
            this.updateCanvasWindow();
        }
        if (PlatformInfo.isLinux() && this.fOriginalGraphicsConfiguration != null && this.getGraphicsConfiguration() != null && this.getGraphicsConfiguration() != this.fOriginalGraphicsConfiguration) {
            AWTAccessor.getComponentAccessor().setGraphicsConfiguration(this.getParent(), this.fOriginalGraphicsConfiguration);
        }
    }

    @Override
    public void removeNotify() {
        this.fNativeWindowHandle = 0L;
        super.removeNotify();
    }

    class HGDebugGraphics
    extends DebugGraphics {
        private boolean fClearRect;

        public HGDebugGraphics(Graphics graphics) {
            super(graphics);
            this.fClearRect = false;
        }

        @Override
        public void clearRect(int n, int n2, int n3, int n4) {
            if (this.fClearRect) {
                super.clearRect(n, n2, n3, n4);
            } else if (this.getDebugOptions() != 0 && this.getDebugOptions() != -1) {
                System.out.println("NOT Clearing rect: " + new Rectangle(n, n2, n3, n4));
            }
        }
    }
}

