/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureComponentContainerProxy;
import com.mathworks.hg.peer.FigureFrameProxy;
import com.mathworks.hg.peer.FigureHG2Client;
import com.mathworks.hg.peer.FigureMediator;
import com.mathworks.hg.peer.FigureMenuBarNotification;
import com.mathworks.hg.peer.FigureMoveResizeNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigurePaintNotification;
import com.mathworks.hg.peer.FigurePositionHandler;
import com.mathworks.hg.peer.FigurePositionableProxy;
import com.mathworks.hg.peer.FigureToolBarNotification;
import com.mathworks.hg.peer.FigureWindowNotification;
import com.mathworks.hg.peer.HG2FigureClientProxy;
import com.mathworks.hg.peer.JavaComponentNotification;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class FigureHG2Mediator
extends FigureMediator
implements FigureHG2Client {
    protected FigurePositionableProxy fPositionableProxy = null;
    private FigurePositionHandler fPosHandler = null;

    public FigureHG2Mediator(Desktop desktop, String string, boolean bl, String string2, UIComponentParent uIComponentParent) {
        this.fClientProxy = new HG2FigureClientProxy(desktop, string, bl, string2);
        this.createFigureBase(desktop, string, bl, string2, uIComponentParent);
        this.createPositionableProxy();
        this.fPositionableProxy.setFigureClient(this.fClientProxy);
        this.fPositionableProxy.setFigurePanel(this.fFigurePanel);
        this.createPositionHandler();
    }

    @Override
    protected void createFigureFrameProxy() {
        this.fFrameProxy = new FigureFrameProxy(false);
    }

    @Override
    protected void createFigureComponentProxy() {
        this.fFigureCompContainerProxy = new FigureComponentContainerProxy(true);
    }

    protected void createPositionHandler() {
        this.fPosHandler = new FigurePositionHandler(this.fPositionableProxy);
    }

    protected void createPositionableProxy() {
        this.fPositionableProxy = new FigurePositionableProxy();
    }

    @Override
    public void setClientWindowStyle(boolean bl, boolean bl2) {
        this.fFrameProxy.setAllowDesktopSelectionParticipation(bl || bl2);
        super.setClientWindowStyle(bl, bl2);
    }

    @Override
    public Component getAxisComponent() {
        Component component = super.getAxisComponent();
        if (component == null) {
            component = this.fFigurePanel.getContainer();
        }
        return component;
    }

    @Override
    public void requestFocusInAxis() {
        this.fFigurePanel.requestFocus();
    }

    @Override
    public void paintCallback(Graphics graphics) {
        this.handleNotification(new FigureWindowNotification(2));
        this.handleNotification(new FigurePaintNotification(this.fFigureCompContainerProxy.getComponent(), graphics));
    }

    @Override
    public void addSceneServerPeer(JavaSceneServerPeer javaSceneServerPeer) {
        assert (javaSceneServerPeer != null);
        javaSceneServerPeer.setParent(this.fFigurePanel);
        if (javaSceneServerPeer.getComponent() != null) {
            javaSceneServerPeer.getComponent().requestFocusInWindow();
        }
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.fFigurePanel.setBackgroundColor(color);
    }

    @Override
    public void setPosition(Rectangle rectangle) {
        this.fPosHandler.setPosition(rectangle);
    }

    @Override
    public void setResizable(boolean bl) {
        super.setResizable(bl);
        this.fPositionableProxy.setResizable(bl);
    }

    @Override
    public void initializeClient(int n, boolean bl) {
        super.initializeClient(n, bl);
        this.fPosHandler.peerCreated();
    }

    @Override
    public void disposeClient() {
        this.fPosHandler.peerDestroyed();
        super.disposeClient();
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        if (figureNotification instanceof FigureMoveResizeNotification) {
            this.fPositionableProxy.handleOuterBoundsChange();
        } else if (figureNotification instanceof FigureToolBarNotification) {
            int n = ((FigureToolBarNotification)figureNotification).getHeight();
            this.fPositionableProxy.setToolbarHeight(n);
            super.handleNotification(figureNotification);
        } else if (figureNotification instanceof FigureMenuBarNotification) {
            if (figureNotification.getType() == 1) {
                this.fPositionableProxy.setMenubarHeight(((FigureMenuBarNotification)figureNotification).getHeight());
            }
            super.handleNotification(figureNotification);
        } else if (figureNotification instanceof JavaComponentNotification) {
            JavaComponentNotification javaComponentNotification = (JavaComponentNotification)figureNotification;
            this.fPositionableProxy.handleJavaComponentMarginChange(javaComponentNotification.getMargin(), javaComponentNotification.getType());
        } else {
            super.handleNotification(figureNotification);
        }
    }
}

