/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.jogamp.opengl.util.GLDrawableUtil;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import com.mathworks.hg.peer.GraphicsImageListener;
import java.awt.image.BufferedImage;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.SwingUtilities;

public class GraphicsImageGrabber {
    private GLAutoDrawable fDrawable = null;
    private AWTGLReadBufferUtil fAWTGLReadBufferUtil = null;
    private GraphicsImageListener fImageListener = null;
    private GLEventListener fGLEventListener = null;
    private boolean fEnabled = false;
    private BufferedImage fLastImage = null;
    private boolean fFirstSinceSetListener = false;
    private boolean fPrevAutoSwapMode = true;
    private boolean fSwapBuffersBeforeRead = false;

    public GraphicsImageGrabber(GLAutoDrawable gLAutoDrawable) {
        this.fDrawable = gLAutoDrawable;
        this.fGLEventListener = new GrabberGLEventListener();
        this.fEnabled = false;
    }

    public void setGraphicsImageListener(GraphicsImageListener graphicsImageListener) {
        this.fImageListener = graphicsImageListener;
        this.fDrawable.addGLEventListener(this.fGLEventListener);
        this.fLastImage = null;
        if (this.fEnabled) {
            this.fDrawable.display();
        } else {
            this.fFirstSinceSetListener = true;
        }
    }

    public void removeGraphicsImageListener() {
        this.fDrawable.disposeGLEventListener(this.fGLEventListener, true);
        this.fImageListener = null;
        this.fLastImage = null;
    }

    public void setEnabled(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        boolean bl2 = this.fEnabled;
        this.fEnabled = bl;
        if (!bl2 && this.fEnabled && this.fImageListener != null) {
            if (this.fLastImage != null) {
                this.fImageListener.acceptImage(this.fLastImage);
            } else if (this.fFirstSinceSetListener) {
                this.fDrawable.display();
                this.fFirstSinceSetListener = false;
            }
        }
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    private class GrabberGLEventListener
    implements GLEventListener {
        private GrabberGLEventListener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GraphicsImageGrabber.this.fPrevAutoSwapMode = gLAutoDrawable.getAutoSwapBufferMode();
            GraphicsImageGrabber.this.fSwapBuffersBeforeRead = GLDrawableUtil.swapBuffersBeforeRead((GLCapabilitiesImmutable)gLAutoDrawable.getChosenGLCapabilities());
            gLAutoDrawable.setAutoSwapBufferMode(!GraphicsImageGrabber.this.fSwapBuffersBeforeRead);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            Object object;
            if (GraphicsImageGrabber.this.fAWTGLReadBufferUtil == null) {
                GraphicsImageGrabber.this.fAWTGLReadBufferUtil = new AWTGLReadBufferUtil(gLAutoDrawable.getGLProfile(), false);
            }
            boolean bl = true;
            if (gLAutoDrawable instanceof GLJPanel) {
                object = (GLJPanel)gLAutoDrawable;
                boolean bl2 = bl = !gLAutoDrawable.isGLOriented() || !object.getSkipGLOrientationVerticalFlip();
            }
            if (GraphicsImageGrabber.this.fSwapBuffersBeforeRead) {
                gLAutoDrawable.swapBuffers();
            }
            object = GraphicsImageGrabber.this.fAWTGLReadBufferUtil.readPixelsToBufferedImage(gLAutoDrawable.getGL(), bl);
            if (GraphicsImageGrabber.this.fEnabled && GraphicsImageGrabber.this.fImageListener != null) {
                GraphicsImageGrabber.this.fImageListener.acceptImage((BufferedImage)object);
                GraphicsImageGrabber.this.fLastImage = null;
            } else {
                GraphicsImageGrabber.this.fLastImage = (BufferedImage)object;
            }
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.setAutoSwapBufferMode(GraphicsImageGrabber.this.fPrevAutoSwapMode);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    }
}

