/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class HGDebugRepaintManager
extends RepaintManager {
    private Vector<ComponentInfo> fComponents = null;
    private static HGDebugRepaintManager sHGRepaintManager = null;
    private static RepaintManager sOldHGRepaintManager = null;
    private static boolean sAddNewCanvasToHGRepaintManager = false;

    private void checkComponent(Component component, String string, String string2) {
        Container container = null;
        if (component instanceof Container) {
            container = (Container)component;
        }
        boolean bl = false;
        System.err.println("Adding " + component.getClass());
        for (ComponentInfo componentInfo : this.fComponents) {
            Component component2 = componentInfo.component;
            if (component.equals(component2)) {
                if (bl) continue;
                System.err.println(string + " " + componentInfo.label + " " + string2);
                bl = true;
                continue;
            }
            if (container == null || !container.isAncestorOf(component2)) continue;
            if (!bl) {
                System.err.println(string + " " + string2 + " " + component);
                bl = true;
            }
            System.err.println("    ancestor of " + componentInfo.label);
        }
    }

    @Override
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkComponent(jComponent, "addDirtyRegion", "(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        super.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    @Override
    public void addDirtyRegion(Window window, int n, int n2, int n3, int n4) {
        this.checkComponent(window, "addDirtyRegion Window", "(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        super.addDirtyRegion(window, n, n2, n3, n4);
    }

    @Override
    public void addInvalidComponent(JComponent jComponent) {
        this.checkComponent(jComponent, "addInvalidComponent", "");
        super.addInvalidComponent(jComponent);
    }

    @Override
    public void markCompletelyDirty(JComponent jComponent) {
        this.checkComponent(jComponent, "markCompletelyDirty", "");
        super.markCompletelyDirty(jComponent);
    }

    public void addComponentOfInterest(Component component, String string) {
        if (this.fComponents == null) {
            this.fComponents = new Vector();
        }
        ComponentInfo componentInfo = new ComponentInfo(component, string);
        this.fComponents.add(componentInfo);
    }

    public void removeComponentOfInterest(Component component) {
        if (this.fComponents != null) {
            ComponentInfo componentInfo = null;
            for (ComponentInfo componentInfo2 : this.fComponents) {
                if (!componentInfo2.component.equals(component)) continue;
                componentInfo = componentInfo2;
            }
            if (componentInfo != null) {
                this.fComponents.remove(componentInfo);
            }
        }
    }

    public void clearComponentsOfInterest() {
        if (this.fComponents != null) {
            this.fComponents.clear();
        }
    }

    public static void addToRepaintManager(Component component, String string) {
        assert (component != null);
        if (sHGRepaintManager == null) {
            sHGRepaintManager = new HGDebugRepaintManager();
            sOldHGRepaintManager = RepaintManager.currentManager(null);
            RepaintManager.setCurrentManager(sHGRepaintManager);
        }
        sHGRepaintManager.addComponentOfInterest(component, string);
    }

    public static void removeFromRepaintManager(Component component) {
        if (sHGRepaintManager != null) {
            sHGRepaintManager.removeComponentOfInterest(component);
        }
    }

    public static void clearRepaintManager() {
        if (sHGRepaintManager != null) {
            sHGRepaintManager.clearComponentsOfInterest();
            RepaintManager.setCurrentManager(sOldHGRepaintManager);
        }
    }

    public static void setAddNewCanvasesToRepaintManager(boolean bl) {
        sAddNewCanvasToHGRepaintManager = bl;
    }

    private static class ComponentInfo {
        public Component component;
        public String label;

        ComponentInfo(Component component, String string) {
            this.component = component;
            this.label = string;
        }
    }
}

